/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class QueryJoinOptimizer
implements QueryOptimizer {
    protected final EvaluationStatistics statistics;

    public QueryJoinOptimizer() {
        this(new EvaluationStatistics());
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics) {
        this.statistics = statistics;
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new JoinVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JoinVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        Set<String> boundVars = new HashSet<String>();

        protected JoinVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void meet(LeftJoin leftJoin) {
            leftJoin.getLeftArg().visit(this);
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                this.boundVars.addAll(leftJoin.getLeftArg().getBindingNames());
                leftJoin.getRightArg().visit(this);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void meet(Join node) {
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                ArrayList<TupleExpr> joinArgs = this.getJoinArgs(node, new ArrayList());
                ArrayList<TupleExpr> orderedJoinArgs = new ArrayList<TupleExpr>(joinArgs.size());
                while (!joinArgs.isEmpty()) {
                    TupleExpr tupleExpr = this.selectNextTupleExpr(joinArgs, this.boundVars);
                    joinArgs.remove(tupleExpr);
                    orderedJoinArgs.add(tupleExpr);
                    tupleExpr.visit(this);
                    this.boundVars.addAll(tupleExpr.getBindingNames());
                }
                TupleExpr replacement = (TupleExpr)orderedJoinArgs.get(0);
                for (int i = 1; i < orderedJoinArgs.size(); ++i) {
                    replacement = new Join(replacement, (TupleExpr)orderedJoinArgs.get(i));
                }
                node.replaceWith(replacement);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        protected <L extends List<TupleExpr>> L getJoinArgs(TupleExpr tupleExpr, L joinArgs) {
            if (tupleExpr instanceof Join) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            } else {
                joinArgs.add((TupleExpr)tupleExpr);
            }
            return joinArgs;
        }

        protected TupleExpr selectNextTupleExpr(List<TupleExpr> expressions, Set<String> boundVars) {
            double lowestCardinality = Double.MAX_VALUE;
            TupleExpr result = null;
            for (TupleExpr tupleExpr : expressions) {
                double cardinality = QueryJoinOptimizer.this.statistics.getCardinality(tupleExpr, boundVars);
                if (!(cardinality < lowestCardinality)) continue;
                lowestCardinality = cardinality;
                result = tupleExpr;
            }
            return result;
        }
    }
}

