/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.manager.RemoteRepositoryManager;
import org.openrdf.repository.manager.RepositoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String location;
    private RemoteRepositoryManager repositoryManager;

    public Server(String location) throws RepositoryException {
        this.location = location;
        if (!this.location.endsWith("/")) {
            this.location = this.location + "/";
        }
        this.repositoryManager = new RemoteRepositoryManager(location);
        this.repositoryManager.initialize();
    }

    public String getLocation() {
        return this.location;
    }

    public RemoteRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public List<RepositoryInfo> getRepositoryInfos() throws RepositoryException {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        result.addAll(this.repositoryManager.getAllRepositoryInfos(false));
        Collections.sort(result);
        return result;
    }
}

