
#ifndef LANGS_H
#define LANGS_H 1

#include <stdio.h>
#include "stl.h"

class TEntry {
 public:
  TEntry(const char *K, const char *D);
  virtual ~TEntry();

  bool  match(const char *testkey);
  int   calcHash();
  char *getData();

  static int hashOf(const char *x);

 private:
  char *key, *data;
};

class Translator {
 public:
  Translator();
  virtual ~Translator();

  /* language = 0 will guess based on the environment */
  void setContext(const char *language, const char *package, 
		  const char *searchpath);

  const char *translate(const char *key);

 private:
  bool ready;

  char Lang[3];
  char SubLang[3];
  char Package[32];

  void guessLanguage();
  void setLanguage(const char *locale);
  bool loadDictionary(FILE *f);

  list<TEntry *> dict[128];
};

void langs_prepare(const char *language, 
		   const char *package, 
		   const char *searchpath);

char * langs_translate(const char *key);

#endif
