// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

import QtQuick

QtObject {
    readonly property int width: 1920
    readonly property int height: 1080

    property FontLoader controlIcons: FontLoader {
        source: "icons.ttf"
    }

    objectName: "internalConstantsObject"

    readonly property string actionIcon: "\u0021"
    readonly property string actionIconBinding: "\u0022"
    readonly property string addColumnAfter: "\u0023"
    readonly property string addColumnBefore: "\u0024"
    readonly property string addFile: "\u0025"
    readonly property string addGroup_medium: "\u0026"
    readonly property string addRowAfter: "\u0027"
    readonly property string addRowBefore: "\u0028"
    readonly property string addTable: "\u0029"
    readonly property string add_medium: "\u002A"
    readonly property string add_small: "\u002B"
    readonly property string addcolumnleft_medium: "\u002C"
    readonly property string addcolumnright_medium: "\u002D"
    readonly property string addrowabove_medium: "\u002E"
    readonly property string addrowbelow_medium: "\u002F"
    readonly property string adjust_medium: "\u0030"
    readonly property string adsClose: "\u0031"
    readonly property string adsDetach: "\u0032"
    readonly property string adsDropDown: "\u0033"
    readonly property string advancedCodeView_medium: "\u0034"
    readonly property string alias: "\u0035"
    readonly property string aliasAnimated: "\u0036"
    readonly property string alignBottom: "\u0037"
    readonly property string alignCenterHorizontal: "\u0038"
    readonly property string alignCenterVertical: "\u0039"
    readonly property string alignLeft: "\u003A"
    readonly property string alignRight: "\u003B"
    readonly property string alignTo: "\u003C"
    readonly property string alignToCam_medium: "\u003D"
    readonly property string alignToCamera_small: "\u003E"
    readonly property string alignToObject_small: "\u003F"
    readonly property string alignToView_medium: "\u0040"
    readonly property string alignTop: "\u0041"
    readonly property string alphabetical_medium: "\u0042"
    readonly property string anchorBaseline: "\u0043"
    readonly property string anchorBottom: "\u0044"
    readonly property string anchorFill: "\u0045"
    readonly property string anchorLeft: "\u0046"
    readonly property string anchorRight: "\u0047"
    readonly property string anchorTop: "\u0048"
    readonly property string anchors_small: "\u0049"
    readonly property string animatedProperty: "\u004A"
    readonly property string annotationBubble: "\u004B"
    readonly property string annotationDecal: "\u004C"
    readonly property string annotations_large: "\u004D"
    readonly property string annotations_small: "\u004E"
    readonly property string applyMaterialToSelected: "\u004F"
    readonly property string apply_medium: "\u0050"
    readonly property string apply_small: "\u0051"
    readonly property string arrange_small: "\u0052"
    readonly property string arrow_small: "\u0053"
    readonly property string assign: "\u0054"
    readonly property string assignTo: "\u0055"
    readonly property string assignTo_medium: "\u0056"
    readonly property string assignTo_small: "\u0057"
    readonly property string attach_medium: "\u0058"
    readonly property string back_medium: "\u0059"
    readonly property string backspace_small: "\u005A"
    readonly property string bakeLights_medium: "\u005B"
    readonly property string bevelAll: "\u005C"
    readonly property string bevelCorner: "\u005D"
    readonly property string bezier_medium: "\u005E"
    readonly property string binding_medium: "\u005F"
    readonly property string bounds_small: "\u0060"
    readonly property string branch_medium: "\u0061"
    readonly property string cameraSpeed_medium: "\u0062"
    readonly property string camera_medium: "\u0063"
    readonly property string camera_small: "\u0064"
    readonly property string centerHorizontal: "\u0065"
    readonly property string centerVertical: "\u0066"
    readonly property string cleanLogs_medium: "\u0067"
    readonly property string clearList_large: "\u0068"
    readonly property string clearList_medium: "\u0069"
    readonly property string closeCross: "\u006A"
    readonly property string closeFile_large: "\u006B"
    readonly property string closeLink: "\u006C"
    readonly property string close_small: "\u006D"
    readonly property string code: "\u006E"
    readonly property string codeEditor_medium: "\u006F"
    readonly property string codeEditor_small: "\u0070"
    readonly property string codeview_medium: "\u0071"
    readonly property string colorPopupClose: "\u0072"
    readonly property string colorSelection_medium: "\u0073"
    readonly property string columnsAndRows: "\u0074"
    readonly property string comboBox_medium: "\u0075"
    readonly property string cone_medium: "\u0076"
    readonly property string cone_small: "\u0077"
    readonly property string connection_small: "\u0078"
    readonly property string connections_medium: "\u0079"
    readonly property string copyLink: "\u007A"
    readonly property string copyStyle: "\u007B"
    readonly property string copy_small: "\u007C"
    readonly property string cornerA: "\u007D"
    readonly property string cornerB: "\u007E"
    readonly property string cornersAll: "\u007F"
    readonly property string createComponent_large: "\u0080"
    readonly property string createComponent_small: "\u0081"
    readonly property string createObject_medium: "\u0082"
    readonly property string create_medium: "\u0083"
    readonly property string create_small: "\u0084"
    readonly property string cube_medium: "\u0085"
    readonly property string cube_small: "\u0086"
    readonly property string curveDesigner: "\u0087"
    readonly property string curveDesigner_medium: "\u0088"
    readonly property string curveEditor: "\u0089"
    readonly property string customMaterialEditor: "\u008A"
    readonly property string cylinder_medium: "\u008B"
    readonly property string cylinder_small: "\u008C"
    readonly property string decisionNode: "\u008D"
    readonly property string deleteColumn: "\u008E"
    readonly property string deleteMaterial: "\u008F"
    readonly property string deleteRow: "\u0090"
    readonly property string deleteTable: "\u0091"
    readonly property string delete_medium: "\u0092"
    readonly property string delete_small: "\u0093"
    readonly property string deletecolumn_medium: "\u0094"
    readonly property string deletepermanently_medium: "\u0095"
    readonly property string deletepermanently_small: "\u0096"
    readonly property string deleterow_medium: "\u0097"
    readonly property string designMode_large: "\u0098"
    readonly property string detach: "\u0099"
    readonly property string directionalLight_small: "\u009A"
    readonly property string distributeBottom: "\u009B"
    readonly property string distributeCenterHorizontal: "\u009D"
    readonly property string distributeCenterVertical: "\u009E"
    readonly property string distributeLeft: "\u009F"
    readonly property string distributeOriginBottomRight: "\u00A0"
    readonly property string distributeOriginCenter: "\u00A1"
    readonly property string distributeOriginNone: "\u00A2"
    readonly property string distributeOriginTopLeft: "\u00A3"
    readonly property string distributeRight: "\u00A4"
    readonly property string distributeSpacingHorizontal: "\u00A5"
    readonly property string distributeSpacingVertical: "\u00A6"
    readonly property string distributeTop: "\u00A7"
    readonly property string download: "\u00A8"
    readonly property string downloadUnavailable: "\u00A9"
    readonly property string downloadUpdate: "\u00AA"
    readonly property string downloaded: "\u00AB"
    readonly property string dragmarks: "\u00AC"
    readonly property string duplicate_small: "\u00AE"
    readonly property string edit: "\u00AF"
    readonly property string editComponent_large: "\u00B0"
    readonly property string editComponent_small: "\u00B1"
    readonly property string editLightOff_medium: "\u00B2"
    readonly property string editLightOn_medium: "\u00B3"
    readonly property string edit_medium: "\u00B4"
    readonly property string edit_small: "\u00B5"
    readonly property string effects: "\u00B6"
    readonly property string effects_medium: "\u00B7"
    readonly property string environment_medium: "\u00B8"
    readonly property string error_medium: "\u00B9"
    readonly property string events_small: "\u00BA"
    readonly property string export_medium: "\u00BB"
    readonly property string eyeDropper: "\u00BC"
    readonly property string favorite: "\u00BD"
    readonly property string fitAll_medium: "\u00BE"
    readonly property string fitSelected_small: "\u00BF"
    readonly property string fitSelection_medium: "\u00C0"
    readonly property string fitToView_medium: "\u00C1"
    readonly property string flag_medium: "\u00C2"
    readonly property string flowAction: "\u00C3"
    readonly property string flowTransition: "\u00C4"
    readonly property string fontStyleBold: "\u00C5"
    readonly property string fontStyleItalic: "\u00C6"
    readonly property string fontStyleStrikethrough: "\u00C7"
    readonly property string fontStyleUnderline: "\u00C8"
    readonly property string forward_medium: "\u00C9"
    readonly property string globalOrient_medium: "\u00CA"
    readonly property string gradient: "\u00CB"
    readonly property string gridView: "\u00CC"
    readonly property string grid_medium: "\u00CD"
    readonly property string group_small: "\u00CE"
    readonly property string help: "\u00CF"
    readonly property string home_large: "\u00D0"
    readonly property string idAliasOff: "\u00D1"
    readonly property string idAliasOn: "\u00D2"
    readonly property string import_medium: "\u00D3"
    readonly property string imported: "\u00D4"
    readonly property string importedModels_small: "\u00D5"
    readonly property string infinity: "\u00D6"
    readonly property string invisible_medium: "\u00D7"
    readonly property string invisible_small: "\u00D8"
    readonly property string jumpToCode_medium: "\u00D9"
    readonly property string jumpToCode_small: "\u00DA"
    readonly property string keyframe: "\u00DB"
    readonly property string languageList_medium: "\u00DC"
    readonly property string layouts_small: "\u00DD"
    readonly property string lights_small: "\u00DE"
    readonly property string linear_medium: "\u00DF"
    readonly property string linkTriangle: "\u00E0"
    readonly property string linked: "\u00E1"
    readonly property string listView: "\u00E2"
    readonly property string listView_medium: "\u00E3"
    readonly property string list_medium: "\u00E4"
    readonly property string localOrient_medium: "\u00E5"
    readonly property string lockOff: "\u00E6"
    readonly property string lockOn: "\u00E7"
    readonly property string loopPlayback_medium: "\u00E8"
    readonly property string materialBrowser_medium: "\u00E9"
    readonly property string materialPreviewEnvironment: "\u00EA"
    readonly property string materialPreviewModel: "\u00EB"
    readonly property string material_medium: "\u00EC"
    readonly property string maxBar_small: "\u00ED"
    readonly property string mergeCells: "\u00EE"
    readonly property string merge_small: "\u00EF"
    readonly property string minus: "\u00F0"
    readonly property string mirror: "\u00F1"
    readonly property string more_medium: "\u00F2"
    readonly property string mouseArea_small: "\u00F3"
    readonly property string moveDown_medium: "\u00F4"
    readonly property string moveInwards_medium: "\u00F5"
    readonly property string moveUp_medium: "\u00F6"
    readonly property string moveUpwards_medium: "\u00F7"
    readonly property string move_medium: "\u00F8"
    readonly property string multi_viewport_1_medium: "\u00F9"
    readonly property string multi_viewport_1_selected_medium: "\u00FA"
    readonly property string multi_viewport_2hl_medium: "\u00FB"
    readonly property string multi_viewport_2hl_selected_medium: "\u00FC"
    readonly property string multi_viewport_2vl_medium: "\u00FD"
    readonly property string multi_viewport_2vl_selected_medium: "\u00FE"
    readonly property string multi_viewport_2x2_medium: "\u00FF"
    readonly property string multi_viewport_2x2_selected_medium: "\u0100"
    readonly property string multi_viewport_3plus1_medium: "\u0101"
    readonly property string multi_viewport_3plus1_selected_medium: "\u0102"
    readonly property string newMaterial: "\u0103"
    readonly property string nextFile_large: "\u0104"
    readonly property string normalBar_small: "\u0105"
    readonly property string number_medium: "\u0106"
    readonly property string openLink: "\u0107"
    readonly property string openMaterialBrowser: "\u0108"
    readonly property string orientation: "\u0109"
    readonly property string orthCam_medium: "\u010A"
    readonly property string orthCam_small: "\u010B"
    readonly property string paddingEdge: "\u010C"
    readonly property string paddingFrame: "\u010D"
    readonly property string particleAnimation_medium: "\u010E"
    readonly property string pasteStyle: "\u010F"
    readonly property string paste_small: "\u0110"
    readonly property string pause: "\u0111"
    readonly property string pause_medium: "\u0112"
    readonly property string perspectiveCam_medium: "\u0113"
    readonly property string perspectiveCam_small: "\u0114"
    readonly property string pin: "\u0115"
    readonly property string plane_medium: "\u0116"
    readonly property string plane_small: "\u0117"
    readonly property string play: "\u0118"
    readonly property string playFill_medium: "\u0119"
    readonly property string playOutline_medium: "\u011A"
    readonly property string plus: "\u011B"
    readonly property string pointLight_small: "\u011C"
    readonly property string positioners_small: "\u011D"
    readonly property string previewEnv_medium: "\u011E"
    readonly property string previousFile_large: "\u011F"
    readonly property string promote: "\u0120"
    readonly property string properties_medium: "\u0121"
    readonly property string readOnly: "\u0122"
    readonly property string recent_medium: "\u0123"
    readonly property string recordFill_medium: "\u0124"
    readonly property string recordOutline_medium: "\u0125"
    readonly property string redo: "\u0126"
    readonly property string reload_medium: "\u0127"
    readonly property string remove_medium: "\u0128"
    readonly property string remove_small: "\u0129"
    readonly property string rename_small: "\u012A"
    readonly property string replace_small: "\u012B"
    readonly property string resetView_small: "\u012C"
    readonly property string restartParticles_medium: "\u012D"
    readonly property string reverseOrder_medium: "\u012E"
    readonly property string revert_medium: "\u012F"
    readonly property string roatate_medium: "\u0130"
    readonly property string rotationFill: "\u0131"
    readonly property string rotationOutline: "\u0132"
    readonly property string runProjFill_large: "\u0133"
    readonly property string runProjOutline_large: "\u0134"
    readonly property string s_anchors: "\u0135"
    readonly property string s_annotations: "\u0136"
    readonly property string s_arrange: "\u0137"
    readonly property string s_boundingBox: "\u0138"
    readonly property string s_component: "\u0139"
    readonly property string s_connections: "\u013A"
    readonly property string s_edit: "\u013B"
    readonly property string s_enterComponent: "\u013C"
    readonly property string s_eventList: "\u013D"
    readonly property string s_group: "\u013E"
    readonly property string s_layouts: "\u013F"
    readonly property string s_merging: "\u0140"
    readonly property string s_mouseArea: "\u0141"
    readonly property string s_positioners: "\u0142"
    readonly property string s_selection: "\u0143"
    readonly property string s_snapping: "\u0144"
    readonly property string s_timeline: "\u0145"
    readonly property string s_visibility: "\u0146"
    readonly property string saveAs_medium: "\u0147"
    readonly property string saveLogs_medium: "\u0148"
    readonly property string save_medium: "\u0149"
    readonly property string scale_medium: "\u014A"
    readonly property string search: "\u014B"
    readonly property string search_small: "\u014C"
    readonly property string sectionToggle: "\u014D"
    readonly property string selectFill_medium: "\u014E"
    readonly property string selectOutline_medium: "\u014F"
    readonly property string selectParent_small: "\u0150"
    readonly property string selection_small: "\u0151"
    readonly property string settings_medium: "\u0152"
    readonly property string share_large: "\u0153"
    readonly property string signal_small: "\u0154"
    readonly property string signin_medium: "\u0155"
    readonly property string signout_medium: "\u0156"
    readonly property string snapping_conf_medium: "\u0157"
    readonly property string snapping_medium: "\u0158"
    readonly property string snapping_small: "\u0159"
    readonly property string sortascending_medium: "\u015A"
    readonly property string sortdescending_medium: "\u015B"
    readonly property string sphere_medium: "\u015C"
    readonly property string sphere_small: "\u015D"
    readonly property string splitColumns: "\u015E"
    readonly property string splitRows: "\u015F"
    readonly property string splitScreen_medium: "\u0160"
    readonly property string spotLight_small: "\u0161"
    readonly property string stackedContainer_small: "\u0162"
    readonly property string startNode: "\u0163"
    readonly property string step_medium: "\u0164"
    readonly property string stop_medium: "\u0165"
    readonly property string string_medium: "\u0166"
    readonly property string tableView_medium: "\u0167"
    readonly property string testIcon: "\u0168"
    readonly property string textAlignBottom: "\u0169"
    readonly property string textAlignCenter: "\u016A"
    readonly property string textAlignJustified: "\u016B"
    readonly property string textAlignLeft: "\u016C"
    readonly property string textAlignMiddle: "\u016D"
    readonly property string textAlignRight: "\u016E"
    readonly property string textAlignTop: "\u016F"
    readonly property string textBulletList: "\u0170"
    readonly property string textFullJustification: "\u0171"
    readonly property string textNumberedList: "\u0172"
    readonly property string textures_medium: "\u0173"
    readonly property string tickIcon: "\u0174"
    readonly property string tickMark_small: "\u0175"
    readonly property string timeline_small: "\u0176"
    readonly property string toEndFrame_medium: "\u0177"
    readonly property string toNextFrame_medium: "\u0178"
    readonly property string toPrevFrame_medium: "\u0179"
    readonly property string toStartFrame_medium: "\u017A"
    readonly property string topToolbar_annotations: "\u017B"
    readonly property string topToolbar_closeFile: "\u017C"
    readonly property string topToolbar_designMode: "\u017D"
    readonly property string topToolbar_enterComponent: "\u017E"
    readonly property string topToolbar_home: "\u017F"
    readonly property string topToolbar_makeComponent: "\u0180"
    readonly property string topToolbar_navFile: "\u0181"
    readonly property string topToolbar_runProject: "\u0182"
    readonly property string translationCreateFiles: "\u0183"
    readonly property string translationCreateReport: "\u0184"
    readonly property string translationExport: "\u0185"
    readonly property string translationImport: "\u0186"
    readonly property string translationSelectLanguages: "\u0187"
    readonly property string translationTest: "\u0188"
    readonly property string transparent: "\u0189"
    readonly property string trash_medium: "\u018A"
    readonly property string triState: "\u018B"
    readonly property string triangleArcA: "\u018C"
    readonly property string triangleArcB: "\u018D"
    readonly property string triangleCornerA: "\u018E"
    readonly property string triangleCornerB: "\u018F"
    readonly property string unLinked: "\u0190"
    readonly property string undo: "\u0191"
    readonly property string unify_medium: "\u0192"
    readonly property string unpin: "\u0193"
    readonly property string upDownIcon: "\u0194"
    readonly property string upDownSquare2: "\u0195"
    readonly property string updateAvailable_medium: "\u0196"
    readonly property string updateContent_medium: "\u0197"
    readonly property string upload_medium: "\u0198"
    readonly property string userAssets_medium: "\u0199"
    readonly property string user_medium: "\u019A"
    readonly property string visibilityOff: "\u019B"
    readonly property string visibilityOn: "\u019C"
    readonly property string visible_medium: "\u019D"
    readonly property string visible_small: "\u019E"
    readonly property string warning2_medium: "\u019F"
    readonly property string warning_medium: "\u01A0"
    readonly property string wildcard: "\u01A1"
    readonly property string wizardsAutomotive: "\u01A2"
    readonly property string wizardsDesktop: "\u01A3"
    readonly property string wizardsGeneric: "\u01A4"
    readonly property string wizardsMcuEmpty: "\u01A5"
    readonly property string wizardsMcuGraph: "\u01A6"
    readonly property string wizardsMobile: "\u01A7"
    readonly property string wizardsUnknown: "\u01A8"
    readonly property string zoomAll: "\u01A9"
    readonly property string zoomIn: "\u01AA"
    readonly property string zoomIn_medium: "\u01AB"
    readonly property string zoomOut: "\u01AC"
    readonly property string zoomOut_medium: "\u01AD"
    readonly property string zoomSelection: "\u01AE"

    readonly property font iconFont: Qt.font({
        family: controlIcons.name,
        pixelSize: 12
    })

    readonly property font font: Qt.font({
        family: Qt.application.font.family,
        pointSize: Qt.application.font.pixelSize
    })

    readonly property font largeFont: Qt.font({
        family: "Arial",
        pointSize: Qt.application.font.pixelSize * 1.6
    })
}
