// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is included from autogenerated files based on
// chrome/common/extensions/api/enterprise_device_attributes.idl.

#ifndef CHROME_BROWSER_EXTENSIONS_API_ENTERPRISE_DEVICE_ATTRIBUTES_ENTERPRISE_DEVICE_ATTRIBUTES_API_H_
#define CHROME_BROWSER_EXTENSIONS_API_ENTERPRISE_DEVICE_ATTRIBUTES_ENTERPRISE_DEVICE_ATTRIBUTES_API_H_

#include <concepts>
#include <memory>
#include <type_traits>

#include "base/types/pass_key.h"
#include "extensions/browser/extension_function.h"
#include "extensions/browser/extension_function_histogram_value.h"

namespace policy {
class DeviceAttributes;
}  // namespace policy

namespace extensions {

class EnterpriseDeviceAttributesApiAshTest;

// The implementation requires forwarding to ash via crosapi. This subclass is
// used to reduce redundant code.
class EnterpriseDeviceAttributesBase : public ExtensionFunction {
 public:
  // Injects DeviceAttributes for testing.
  void SetDeviceAttributes(
      base::PassKey<EnterpriseDeviceAttributesApiAshTest>,
      std::unique_ptr<policy::DeviceAttributes> device_attributes);

 protected:
  EnterpriseDeviceAttributesBase();
  ~EnterpriseDeviceAttributesBase() override;

  // Checks whether it is allowed to respond with a valid value, and if it is
  // responds the value returned from `f()`, which is called synchronously.
  // Otherwise, responds with an empty string as an error.
  // We cannot use RespondWithValidation/PreRunValidation, because it'll cause
  // to return Error on error, while enterprise.deviceAttributes functions
  // expect to return an empty string as an error.
  template <std::invocable F>
    requires std::convertible_to<std::invoke_result_t<F>, std::string>
  ResponseAction RespondWithCheck(F&& f);

  policy::DeviceAttributes& device_attributes() { return *device_attributes_; }

 private:
  std::unique_ptr<policy::DeviceAttributes> device_attributes_;
};

class EnterpriseDeviceAttributesGetDirectoryDeviceIdFunction
    : public EnterpriseDeviceAttributesBase {
 public:
  EnterpriseDeviceAttributesGetDirectoryDeviceIdFunction() = default;

 protected:
  ~EnterpriseDeviceAttributesGetDirectoryDeviceIdFunction() override = default;

  ResponseAction Run() override;

 private:
  DECLARE_EXTENSION_FUNCTION("enterprise.deviceAttributes.getDirectoryDeviceId",
                             ENTERPRISE_DEVICEATTRIBUTES_GETDIRECTORYDEVICEID)
};

class EnterpriseDeviceAttributesGetDeviceSerialNumberFunction
    : public EnterpriseDeviceAttributesBase {
 public:
  EnterpriseDeviceAttributesGetDeviceSerialNumberFunction() = default;

 protected:
  ~EnterpriseDeviceAttributesGetDeviceSerialNumberFunction() override = default;

  ResponseAction Run() override;

 private:
  DECLARE_EXTENSION_FUNCTION(
      "enterprise.deviceAttributes.getDeviceSerialNumber",
      ENTERPRISE_DEVICEATTRIBUTES_GETDEVICESERIALNUMBER)
};

class EnterpriseDeviceAttributesGetDeviceAssetIdFunction
    : public EnterpriseDeviceAttributesBase {
 public:
  EnterpriseDeviceAttributesGetDeviceAssetIdFunction() = default;

 protected:
  ~EnterpriseDeviceAttributesGetDeviceAssetIdFunction() override = default;

  ResponseAction Run() override;

 private:
  DECLARE_EXTENSION_FUNCTION("enterprise.deviceAttributes.getDeviceAssetId",
                             ENTERPRISE_DEVICEATTRIBUTES_GETDEVICEASSETID)
};

class EnterpriseDeviceAttributesGetDeviceAnnotatedLocationFunction
    : public EnterpriseDeviceAttributesBase {
 public:
  EnterpriseDeviceAttributesGetDeviceAnnotatedLocationFunction() = default;

 protected:
  ~EnterpriseDeviceAttributesGetDeviceAnnotatedLocationFunction() override =
      default;

  ResponseAction Run() override;

 private:
  DECLARE_EXTENSION_FUNCTION(
      "enterprise.deviceAttributes.getDeviceAnnotatedLocation",
      ENTERPRISE_DEVICEATTRIBUTES_GETDEVICEANNOTATEDLOCATION)
};

class EnterpriseDeviceAttributesGetDeviceHostnameFunction
    : public EnterpriseDeviceAttributesBase {
 public:
  EnterpriseDeviceAttributesGetDeviceHostnameFunction() = default;

 protected:
  ~EnterpriseDeviceAttributesGetDeviceHostnameFunction() override = default;

  ResponseAction Run() override;

 private:
  DECLARE_EXTENSION_FUNCTION("enterprise.deviceAttributes.getDeviceHostname",
                             ENTERPRISE_DEVICEATTRIBUTES_GETDEVICEHOSTNAME)
};

}  //  namespace extensions

#endif  // CHROME_BROWSER_EXTENSIONS_API_ENTERPRISE_DEVICE_ATTRIBUTES_ENTERPRISE_DEVICE_ATTRIBUTES_API_H_
