/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineWrappingHandler;

public class IfHandler
extends BlockParentHandler {
    public IfHandler(IndentationCheck indentCheck, DetailAST ast, ExpressionHandler parent) {
        super(indentCheck, "if", ast, parent);
    }

    @Override
    public IndentLevel suggestedChildLevel(ExpressionHandler child) {
        if (child instanceof ElseHandler) {
            return this.getLevel();
        }
        return super.suggestedChildLevel(child);
    }

    @Override
    protected IndentLevel getLevelImpl() {
        if (this.isIfAfterElse()) {
            return this.getParent().getLevel();
        }
        return super.getLevelImpl();
    }

    private boolean isIfAfterElse() {
        DetailAST parent = this.getMainAst().getParent();
        return parent.getType() == 92 && parent.getLineNo() == this.getMainAst().getLineNo();
    }

    @Override
    protected void checkToplevelToken() {
        if (this.isIfAfterElse()) {
            return;
        }
        super.checkToplevelToken();
    }

    private void checkCondExpr() {
        DetailAST condAst = this.getMainAst().findFirstToken(76).getNextSibling();
        IndentLevel expected = new IndentLevel(this.getLevel(), this.getBasicOffset());
        this.checkExpressionSubtree(condAst, expected, false, false);
    }

    @Override
    public void checkIndentation() {
        super.checkIndentation();
        this.checkCondExpr();
        LineWrappingHandler lineWrap = new LineWrappingHandler(this.getIndentCheck(), this.getMainAst(), IfHandler.getIfStatementRightParen(this.getMainAst()));
        lineWrap.checkIndentation();
    }

    private static DetailAST getIfStatementRightParen(DetailAST literalIfAst) {
        return literalIfAst.findFirstToken(77);
    }
}

