/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AtclauseOrderCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "at.clause.order";
    private static final String[] DEFAULT_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@exception", "@see", "@since", "@serial", "@serialField", "@serialData", "@deprecated"};
    private List<Integer> target = Arrays.asList(14, 15, 154, 9, 8, 10);
    private List<String> tagOrder = Arrays.asList(DEFAULT_ORDER);

    public void setTarget(String target) {
        ArrayList<Integer> customTarget = new ArrayList<Integer>();
        for (String type : target.split(", ")) {
            customTarget.add(TokenTypes.getTokenId(type));
        }
        this.target = customTarget;
    }

    public void setTagOrder(String order) {
        ArrayList<String> customOrder = new ArrayList<String>();
        Collections.addAll(customOrder, order.split(", "));
        this.tagOrder = customOrder;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        int parentType = this.getParentType(this.getBlockCommentAst());
        if (this.target.contains(parentType)) {
            this.checkOrderInTagSection(ast);
        }
    }

    private void checkOrderInTagSection(DetailNode javadoc) {
        int indexOrderOfPreviousTag = 0;
        int indexOrderOfCurrentTag = 0;
        for (DetailNode node : javadoc.getChildren()) {
            if (node.getType() != 10071) continue;
            String tagText = JavadocUtils.getFirstChild(node).getText();
            indexOrderOfCurrentTag = this.tagOrder.indexOf(tagText);
            if (this.tagOrder.contains(tagText) && indexOrderOfCurrentTag < indexOrderOfPreviousTag) {
                this.log(node.getLineNumber(), MSG_KEY, this.tagOrder.toString());
            }
            indexOrderOfPreviousTag = indexOrderOfCurrentTag;
        }
    }

    private int getParentType(DetailAST commentBlock) {
        int type = 0;
        DetailAST parentNode = commentBlock.getParent();
        if (parentNode != null && ((type = parentNode.getType()) == 13 || type == 5)) {
            type = parentNode.getParent().getType();
        }
        return type;
    }
}

