/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.Guard;
import java.util.LinkedList;
import java.util.List;

class PkgControl {
    private final LinkedList<Guard> guards = Lists.newLinkedList();
    private final List<PkgControl> children = Lists.newArrayList();
    private final PkgControl parent;
    private final String fullPackage;

    PkgControl(String pkgName) {
        assert (pkgName != null);
        this.parent = null;
        this.fullPackage = pkgName;
    }

    PkgControl(PkgControl parent, String subPkg) {
        assert (parent != null);
        assert (subPkg != null);
        this.parent = parent;
        this.fullPackage = parent.getFullPackage() + "." + subPkg;
        parent.children.add(this);
    }

    void addGuard(Guard thug) {
        this.guards.addFirst(thug);
    }

    String getFullPackage() {
        return this.fullPackage;
    }

    PkgControl locateFinest(String forPkg) {
        if (!forPkg.startsWith(this.getFullPackage())) {
            return null;
        }
        for (PkgControl pc : this.children) {
            PkgControl match = pc.locateFinest(forPkg);
            if (match == null) continue;
            return match;
        }
        return this;
    }

    AccessResult checkAccess(String forImport, String inPkg) {
        AccessResult retVal = this.localCheckAccess(forImport, inPkg);
        if (retVal != AccessResult.UNKNOWN) {
            return retVal;
        }
        if (this.parent == null) {
            return AccessResult.DISALLOWED;
        }
        return this.parent.checkAccess(forImport, inPkg);
    }

    private AccessResult localCheckAccess(String forImport, String inPkg) {
        for (Guard g : this.guards) {
            AccessResult result;
            if (g.isLocalOnly() && !this.fullPackage.equals(inPkg) || (result = g.verifyImport(forImport)) == AccessResult.UNKNOWN) continue;
            return result;
        }
        return AccessResult.UNKNOWN;
    }
}

