/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public final class CheckDocsDoclet {
    private static final String DEST_DIR_OPT = "-d";

    private CheckDocsDoclet() {
    }

    private static String getDescription(ClassDoc classDoc) {
        Tag[] tags = classDoc.firstSentenceTags();
        StringBuffer buf = new StringBuffer();
        if (tags.length > 0) {
            buf.append(tags[0].text());
        }
        CheckDocsDoclet.removeOpeningParagraphTag(buf);
        return buf.toString();
    }

    private static void removeOpeningParagraphTag(StringBuffer text) {
        String openTag = "<p>";
        int tagLen = "<p>".length();
        if (text.length() > tagLen && text.substring(0, tagLen).equals("<p>")) {
            text.delete(0, tagLen);
        }
    }

    private static String getCheckName(ClassDoc classDoc) {
        String strippedClassName = classDoc.typeName();
        String checkName = strippedClassName.endsWith("Check") ? strippedClassName.substring(0, strippedClassName.length() - "Check".length()) : strippedClassName;
        return checkName;
    }

    private static void writeXdocsHeader(PrintWriter printWriter, String title) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<document>");
        printWriter.println("<properties>");
        printWriter.println("<title>" + title + "</title>");
        printWriter.println("<author email=\"checkstyle-devel@lists.sourceforge.net\">Checkstyle Development Team</author>");
        printWriter.println("</properties>");
        printWriter.println("<body>");
        printWriter.flush();
    }

    private static void writeXdocsFooter(PrintWriter printWriter) {
        printWriter.println("</body>");
        printWriter.println("</document>");
        printWriter.flush();
    }

    public static boolean start(RootDoc root) throws IOException {
        ClassDoc[] classDocs = root.classes();
        File destDir = new File(CheckDocsDoclet.getDestDir(root.options()));
        File checksIndexFile = new File(destDir, "checks.xml");
        PrintWriter fileWriter = new PrintWriter(new FileWriter(checksIndexFile));
        CheckDocsDoclet.writeXdocsHeader(fileWriter, "Available Checks");
        fileWriter.println("<p>Checkstyle provides many checks that you can apply to your source code. Below is an alphabetical reference, the site navigation menu provides a reference organized by functionality.</p>");
        fileWriter.println("<table>");
        Arrays.sort(classDocs, new ClassDocByCheckNameComparator());
        for (ClassDoc classDoc : classDocs) {
            if (!classDoc.typeName().endsWith("Check") || classDoc.isAbstract()) continue;
            String pageName = CheckDocsDoclet.getPageName(classDoc);
            Tag[] docPageTags = classDoc.tags("checkstyle-docpage");
            if (docPageTags != null && docPageTags.length > 0) {
                pageName = docPageTags[0].text();
            }
            String descr = CheckDocsDoclet.getDescription(classDoc);
            String checkName = CheckDocsDoclet.getCheckName(classDoc);
            fileWriter.println("<tr><td><a href=\"config_" + pageName + ".html#" + checkName + "\">" + checkName + "</a></td><td>" + descr + "</td></tr>");
        }
        fileWriter.println("</table>");
        CheckDocsDoclet.writeXdocsFooter(fileWriter);
        fileWriter.close();
        return true;
    }

    private static String getPageName(ClassDoc classDoc) {
        String packageName = classDoc.containingPackage().name();
        String pageName = packageName.substring(packageName.lastIndexOf(46) + 1);
        if ("checks".equals(pageName)) {
            return "misc";
        }
        return pageName;
    }

    public static String getDestDir(String[][] options) {
        for (String[] opt : options) {
            if (!DEST_DIR_OPT.equalsIgnoreCase(opt[0])) continue;
            return opt[1];
        }
        return null;
    }

    public static int optionLength(String option) {
        if (DEST_DIR_OPT.equals(option)) {
            return 2;
        }
        return 0;
    }

    private static class ClassDocByCheckNameComparator
    implements Comparator<ClassDoc>,
    Serializable {
        private static final long serialVersionUID = 1731995210294871881L;

        private ClassDocByCheckNameComparator() {
        }

        @Override
        public int compare(ClassDoc object1, ClassDoc object2) {
            String checkName1 = CheckDocsDoclet.getCheckName(object1);
            String checkName2 = CheckDocsDoclet.getCheckName(object2);
            return checkName1.compareTo(checkName2);
        }
    }
}

