/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Utils {
    private static final Log EXCEPTION_LOG = LogFactory.getLog("com.puppycrawl.tools.checkstyle.ExceptionLog");

    private Utils() {
    }

    public static boolean fileExtensionMatches(File file, String[] fileExtensions) {
        boolean result = false;
        if (fileExtensions == null || fileExtensions.length == 0) {
            result = true;
        } else {
            String[] withDotExtensions = new String[fileExtensions.length];
            for (int i = 0; i < fileExtensions.length; ++i) {
                String extension = fileExtensions[i];
                withDotExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
            }
            String fileName = file.getName();
            for (String fileExtension : withDotExtensions) {
                if (!fileName.endsWith(fileExtension)) continue;
                result = true;
            }
        }
        return result;
    }

    public static Log getExceptionLogger() {
        return EXCEPTION_LOG;
    }

    public static boolean whitespaceBefore(int index, String line) {
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int lengthMinusTrailingWhitespace(String line) {
        int len = line.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(line.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String string, int toIdx, int tabWidth) {
        int len = 0;
        for (int idx = 0; idx < toIdx; ++idx) {
            if (string.charAt(idx) == '\t') {
                len = (len / tabWidth + 1) * tabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean isPatternValid(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public static Pattern createPattern(String pattern) throws ConversionException {
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("Failed to initialise regular expression " + pattern, e);
        }
    }

    public static String baseClassname(String type) {
        int i = type.lastIndexOf(".");
        return i == -1 ? type : type.substring(i + 1);
    }

    public static String getStrippedFileName(String basedir, String fileName) {
        String stripped;
        if (basedir == null || !fileName.startsWith(basedir)) {
            stripped = fileName;
        } else {
            int skipSep = basedir.endsWith(File.separator) ? 0 : 1;
            stripped = fileName.substring(basedir.length() + skipSep);
        }
        return stripped;
    }
}

