/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class ThrowsCountCheck
extends Check {
    public static final String MSG_KEY = "throws.count";
    private static final int DEFAULT_MAX = 1;
    private int max;

    public ThrowsCountCheck() {
        this.setMax(1);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{81};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{81};
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 81: {
                this.visitLiteralThrows(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitLiteralThrows(DetailAST ast) {
        int count = (ast.getChildCount() + 1) / 2;
        if (count > this.getMax()) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, count, this.getMax());
        }
    }
}

