/*
 * Copyright 2018 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/**************************************************************************************************
 *** This file was autogenerated from GrArithmeticFP.fp; do not modify.
 **************************************************************************************************/
#ifndef GrArithmeticFP_DEFINED
#define GrArithmeticFP_DEFINED
#include "SkTypes.h"
#include "GrFragmentProcessor.h"
#include "GrCoordTransform.h"
class GrArithmeticFP : public GrFragmentProcessor {
public:
    float k1() const { return fK1; }
    float k2() const { return fK2; }
    float k3() const { return fK3; }
    float k4() const { return fK4; }
    bool enforcePMColor() const { return fEnforcePMColor; }
    static std::unique_ptr<GrFragmentProcessor> Make(float k1, float k2, float k3, float k4,
                                                     bool enforcePMColor,
                                                     std::unique_ptr<GrFragmentProcessor> child) {
        return std::unique_ptr<GrFragmentProcessor>(
                new GrArithmeticFP(k1, k2, k3, k4, enforcePMColor, std::move(child)));
    }
    GrArithmeticFP(const GrArithmeticFP& src);
    std::unique_ptr<GrFragmentProcessor> clone() const override;
    const char* name() const override { return "ArithmeticFP"; }

private:
    GrArithmeticFP(float k1, float k2, float k3, float k4, bool enforcePMColor,
                   std::unique_ptr<GrFragmentProcessor> child)
            : INHERITED(kGrArithmeticFP_ClassID, kNone_OptimizationFlags)
            , fK1(k1)
            , fK2(k2)
            , fK3(k3)
            , fK4(k4)
            , fEnforcePMColor(enforcePMColor) {
        this->registerChildProcessor(std::move(child));
    }
    GrGLSLFragmentProcessor* onCreateGLSLInstance() const override;
    void onGetGLSLProcessorKey(const GrShaderCaps&, GrProcessorKeyBuilder*) const override;
    bool onIsEqual(const GrFragmentProcessor&) const override;
    GR_DECLARE_FRAGMENT_PROCESSOR_TEST
    float fK1;
    float fK2;
    float fK3;
    float fK4;
    bool fEnforcePMColor;
    typedef GrFragmentProcessor INHERITED;
};
#endif
