// Copyright (C) 2025 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#ifndef TRANSLATIONUTILS_H
#define TRANSLATIONUTILS_H

#include <QHash>
#include <QJsonValue>
#include <QString>

QT_BEGIN_NAMESPACE

// Extracts key-value pairs from a JSON structure by finding an array with the given key.
// Recursively searches the JSON value for the array, then extracts all string key-value
// pairs from objects in that array. Handles both formats:
// 1. Array of single-key objects: [{"k1":"v1"},{"k2":"v2"}]
// 2. Array with multi-key object: [{"k1":"v1","k2":"v2"}]
QHash<QString, QString> extractKeyValuePairs(const QJsonValue &jval, const QString &arrayKey);

// Returns the system prompt used for translation requests.
QString translationSystemPrompt();

QT_END_NAMESPACE

#endif // TRANSLATIONUTILS_H
