import qbs.File
import qbs.FileInfo

Project {
    name: "Unit test & helper products"

    Product {
        name: "qtc_gtest_gmock"

        Export {
            property bool useExternalLibs: preferExternalLibs && externalLibsPresent
            property bool useRepo: !useExternalLibs && hasRepo
            property bool preferExternalLibs: true
            property bool externalLibsPresent: preferExternalLibs && gtest.present && gmock.present
            property string repoDir: FileInfo.joinPaths(path, "3rdparty", "googletest")
            property string gtestDir: FileInfo.joinPaths(repoDir, "googletest")
            property string gmockDir: FileInfo.joinPaths(repoDir, "googlemock")
            property bool hasRepo: File.exists(gtestDir)

            Depends { name: "pkgconfig"; condition: preferExternalLibs; required: false }
            Depends { name: "gtest"; condition: preferExternalLibs; required: false }
            Depends { name: "gmock"; condition: preferExternalLibs; required: false }

            Depends { name: "cpp" }
            Group {
                name: "Files from repository"
                condition: qtc_gtest_gmock.useRepo
                cpp.includePaths: [
                    qtc_gtest_gmock.gtestDir,
                    qtc_gtest_gmock.gmockDir,
                    FileInfo.joinPaths(qtc_gtest_gmock.gtestDir, "include"),
                    FileInfo.joinPaths(qtc_gtest_gmock.gmockDir, "include"),
                ]
                files: [
                    FileInfo.joinPaths(qtc_gtest_gmock.gtestDir, "src", "gtest-all.cc"),
                    FileInfo.joinPaths(qtc_gtest_gmock.gmockDir, "src", "gmock-all.cc"),
                ]
            }

            Properties {
                condition: useRepo
                cpp.includePaths: [
                    FileInfo.joinPaths(gtestDir, "include"),
                    FileInfo.joinPaths(gmockDir, "include"),
                ]
            }
        }
    }

    QtcProduct {
        name: "Unit test"
        condition: qtc_gtest_gmock.hasRepo || qtc_gtest_gmock.externalLibsPresent
        type: ["application", "autotest", "json_copy"]
        consoleApplication: true
        destinationDirectory: FileInfo.joinPaths(project.buildDirectory,
                FileInfo.relativePath(project.ide_source_tree, sourceDirectory))
        install: false

        Depends { name: "echoserver" }
        Depends { name: "pluginjson" }
        Depends { name: "libclang"; required: false }
        Depends { name: "clang_defines" }

        Depends { name: "QmlDesigner" }

        Depends { name: "sqlite_sources" }
        Depends { name: "Core" }
        Depends { name: "CPlusPlus" }
        Depends { name: "yaml-cpp" }

        Depends { name: "Qt"; submodules: ["network", "widgets", "testlib"] }

        Depends { name: "pkgconfig"; required: false }
        Depends { name: "benchmark"; required: false }

        Depends { name: "qtc_gtest_gmock" }

        pluginjson.useVcsData: false
        sqlite_sources.buildSharedLib: false

        cpp.defines: {
            var defines = [
                        "QT_NO_CAST_TO_ASCII",
                        "QT_RESTRICTED_CAST_FROM_ASCII",
                        "QT_USE_FAST_OPERATOR_PLUS",
                        "QT_USE_FAST_CONCATENATION",
                        "CLANGSUPPORT_BUILD_STATIC_LIB",
                        "CLANGTOOLS_STATIC_LIBRARY",
                        "CPPTOOLS_STATIC_LIBRARY",
                        "DEBUGGER_STATIC_LIBRARY",
                        "PROJECTEXPLORER_STATIC_LIBRARY",
                        "UNIT_TESTS",
                        "DONT_CHECK_MESSAGE_COUNTER",
                        'QTC_RESOURCE_DIR="' + path + "/../../../share/qtcreator" + '"',
                        'TESTDATA_DIR="' + FileInfo.joinPaths(sourceDirectory, "data") + '"',
                        'ECHOSERVER="' + FileInfo.joinPaths(project.buildDirectory, "tests", "unit",
                                                            "echoserver", "echo") + '"',
                        'RELATIVE_DATA_PATH="' + FileInfo.relativePath(destinationDirectory,
                                                                       FileInfo.joinPaths(project.sourceDirectory, "share", "qtcreator")) + '"',
                        'CPPTOOLS_JSON="' + FileInfo.joinPaths(destinationDirectory, "CppTools.json") + '"',
                    ];
            if (libclang.present) {
                defines.push("CLANG_UNIT_TESTS");
            }
            return defines;
        }
        cpp.cxxFlags: {
            var flags = [];
            if (qbs.toolchain.contains("msvc"))
                flags.push("-w34100", "/bigobj", "/wd4267", "/wd4141", "/wd4146");
            if (qbs.toolchain.contains("gcc") && !qbs.toolchain.contains("clang"))
                flags.push("-Wno-noexcept-type");
            if (qbs.toolchain.contains("clang")) {
                flags.push("-Wno-inconsistent-missing-override", "-Wno-self-move",
                           "-Wno-self-assign-overloaded");
                flags.push("-Wno-unused-command-line-argument"); // gtest puts -lpthread on compiler command line
                if (!qbs.hostOS.contains("darwin")
                        && Utilities.versionCompare(cpp.compilerVersion, "10") >= 0) {
                    flags.push("-Wno-deprecated-copy", "-Wno-constant-logical-operand");
                }
            }
            if (qbs.toolchain.contains("gcc"))
                flags.push("-Wno-unused-parameter");
            return flags;
        }
        cpp.cxxLanguageVersion: "c++17"
        cpp.dynamicLibraries: {
            var libs = [];
            if (libclang.present) {
                libs = libs.concat(libclang.llvmLibs);
                if (libclang.llvmFormattingLibs.length
                        && (!qbs.targetOS.contains("windows") || libclang.llvmBuildModeMatches)) {
                    libs = libs.concat(libclang.llvmFormattingLibs);
                }
            }
            return libs;
        }
        cpp.includePaths: {
            var paths = [
                        ".",
                        "../mockup",
                        "../../../src/libs",
                        "../../../src/libs/3rdparty",
                        "../../../src/libs/clangsupport",
                        "../../../src/plugins",
                        "../../../src/plugins/clangcodemodel",
                        "../../../src/tools/clangbackend/source",
                        "../../../share/qtcreator/qml/qmlpuppet/types",
                    ];
            if (libclang.present) {
                paths.push(libclang.llvmIncludeDir);
            }
            return paths;
        }
        cpp.libraryPaths: {
            var paths = [];
            if (libclang.present)
                paths.push(libclang.llvmLibDir);
            return paths;
        }
        cpp.rpaths: {
            var paths = [
                        FileInfo.joinPaths(project.buildDirectory, qtc.ide_library_path),
                        FileInfo.joinPaths(project.buildDirectory, qtc.ide_plugin_path)
                    ];
            if (libclang.present)
                paths.push(libclang.llvmLibDir);
            return paths;
        }

        files: [
            "clientserverinprocess-test.cpp",
            "clientserveroutsideprocess-test.cpp",
            "compare-operators.h",
            "compilationdatabaseutils-test.cpp",
            "compileroptionsbuilder-test.cpp",
            "conditionally-disabled-tests.h",
            "cppprojectfilecategorizer-test.cpp",
            "cppprojectinfogenerator-test.cpp",
            "cppprojectpartchooser-test.cpp",
            "createtablesqlstatementbuilder-test.cpp",
            "dummyclangipcclient.h",
            "dynamicastmatcherdiagnosticcontainer-matcher.h",
            "eventspy.cpp",
            "eventspy.h",
            "fakeprocess.cpp",
            "fakeprocess.h",
            "filesystem-utilities.h",
            "google-using-declarations.h",
            "googletest.h",
            "gtest-creator-printing.cpp",
            "gtest-creator-printing.h",
            "gtest-llvm-printing.h",
            "gtest-qt-printing.cpp",
            "gtest-qt-printing.h",
            "headerpathfilter-test.cpp",
            "lineprefixer-test.cpp",
            "matchingtext-test.cpp",
            "mimedatabase-utilities.cpp",
            "mimedatabase-utilities.h",
            "mockclangcodemodelclient.h",
            "mockclangcodemodelserver.h",
            "mockcppmodelmanager.h",
            "mockfutureinterface.h",
            "mockmutex.h",
            "mockqfilesystemwatcher.h",
            "mockqueue.h",
            "mocksqlitestatement.h",
            "mocksqlitetransactionbackend.h",
            "mocksyntaxhighligher.h",
            "mocktimer.cpp",
            "mocktimer.h",
            "processcreator-test.cpp",
            "processevents-utilities.cpp",
            "processevents-utilities.h",
            "readandwritemessageblock-test.cpp",
            "rundocumentparse-utility.h",
            "sizedarray-test.cpp",
            "smallstring-test.cpp",
            "sourcerangecontainer-matcher.h",
            "spydummy.cpp",
            "spydummy.h",
            "sqlitecolumn-test.cpp",
            "sqlitedatabase-test.cpp",
            "sqlitedatabasebackend-test.cpp",
            "sqlitedatabasemock.h",
            "sqliteindex-test.cpp",
            "sqlitereadstatementmock.cpp",
            "sqlitereadstatementmock.h",
            "sqlitestatement-test.cpp",
            "sqlitetable-test.cpp",
            "sqliteteststatement.h",
            "sqlitetransaction-test.cpp",
            "sqlitevalue-test.cpp",
            "sqlitewritestatementmock.cpp",
            "sqlitewritestatementmock.h",
            "sqlstatementbuilder-test.cpp",
            "task.cpp",
            "unittest-utility-functions.h",
            "unittests-main.cpp",
            "utf8-test.cpp",
        ]

        Group {
            name: "libclang tests"
            condition: libclang.present && (!qbs.targetOS.contains("windows") || libclang.llvmBuildModeMatches)
            files: [
                "activationsequencecontextprocessor-test.cpp",
                "activationsequenceprocessor-test.cpp",
                "chunksreportedmonitor.cpp",
                "chunksreportedmonitor.h",
                "clangasyncjob-base.cpp",
                "clangasyncjob-base.h",
                "clangcodecompleteresults-test.cpp",
                "clangcodemodelserver-test.cpp",
                "clangcompareoperators.h",
                "clangcompletecodejob-test.cpp",
                "clangcompletioncontextanalyzer-test.cpp",
                "clangdiagnosticfilter-test.cpp",
                "clangdocument-test.cpp",
                "clangdocumentprocessor-test.cpp",
                "clangdocumentprocessors-test.cpp",
                "clangdocuments-test.cpp",
                "clangfixitoperation-test.cpp",
                "clangfollowsymbol-test.cpp",
                "clangisdiagnosticrelatedtolocation-test.cpp",
                "clangjobqueue-test.cpp",
                "clangjobs-test.cpp",
                "clangparsesupportivetranslationunitjob-test.cpp",
                "clangrequestannotationsjob-test.cpp",
                "clangrequestreferencesjob-test.cpp",
                "clangresumedocumentjob-test.cpp",
                "clangstring-test.cpp",
                "clangsupportivetranslationunitinitializer-test.cpp",
                "clangsuspenddocumentjob-test.cpp",
                "clangtooltipinfo-test.cpp",
                "clangtranslationunit-test.cpp",
                "clangtranslationunits-test.cpp",
                "clangupdateannotationsjob-test.cpp",
                "codecompleter-test.cpp",
                "codecompletionsextractor-test.cpp",
                "completionchunkstotextconverter-test.cpp",
                "cursor-test.cpp",
                "diagnostic-test.cpp",
                "diagnosticcontainer-matcher.h",
                "diagnosticset-test.cpp",
                "fixit-test.cpp",
                "gtest-clang-printing.cpp",
                "gtest-clang-printing.h",
                "highlightingresultreporter-test.cpp",
                "readexporteddiagnostics-test.cpp",
                "senddocumenttracker-test.cpp",
                "skippedsourceranges-test.cpp",
                "sourcelocation-test.cpp",
                "sourcerange-test.cpp",
                "token-test.cpp",
                "tokenprocessor-test.cpp",
                "translationunitupdater-test.cpp",
                "unsavedfile-test.cpp",
                "unsavedfiles-test.cpp",
                "utf8positionfromlinecolumn-test.cpp",
            ]
        }

        Group {
            name: "ClangFormat tests"
            condition: libclang.present
                       && libclang.llvmFormattingLibs.length
                       && (!qbs.targetOS.contains("windows") || libclang.llvmBuildModeMatches)
            files: "clangformat-test.cpp"
        }

        Group {
            name: "benchmark test"
            condition: benchmark.present
            files: "smallstring-benchmark.cpp"
        }

        Group {
            name: "data"
            files: [
                "data/*",
                "data/include/*",
            ]
            fileTags: []
        }

        Group {
            name: "json.in file"
            files: "../../../src/plugins/cpptools/CppTools.json.in"
            fileTags: "pluginJsonIn"
        }

        Group {
            name: "sources from clangbackend"
            condition: libclang.present
            prefix: "../../../src/tools/clangbackend/source/"
            files: [
                "clangasyncjob.h",
                "clangbackend_global.h",
                "clangclock.h",
                "clangcodecompleteresults.cpp",
                "clangcodecompleteresults.h",
                "clangcodemodelserver.cpp",
                "clangcodemodelserver.h",
                "clangcompletecodejob.cpp",
                "clangcompletecodejob.h",
                "clangdocument.cpp",
                "clangdocument.h",
                "clangdocumentjob.h",
                "clangdocumentprocessor.cpp",
                "clangdocumentprocessor.h",
                "clangdocumentprocessors.cpp",
                "clangdocumentprocessors.h",
                "clangdocuments.cpp",
                "clangdocuments.h",
                "clangdocumentsuspenderresumer.cpp",
                "clangdocumentsuspenderresumer.h",
                "clangexceptions.cpp",
                "clangexceptions.h",
                "clangfilepath.cpp",
                "clangfilepath.h",
                "clangfilesystemwatcher.cpp",
                "clangfilesystemwatcher.h",
                "clangfollowsymbol.cpp",
                "clangfollowsymbol.h",
                "clangfollowsymboljob.cpp",
                "clangfollowsymboljob.h",
                "clangiasyncjob.cpp",
                "clangiasyncjob.h",
                "clangjobcontext.cpp",
                "clangjobcontext.h",
                "clangjobqueue.cpp",
                "clangjobqueue.h",
                "clangjobrequest.cpp",
                "clangjobrequest.h",
                "clangjobs.cpp",
                "clangjobs.h",
                "clangparsesupportivetranslationunitjob.cpp",
                "clangparsesupportivetranslationunitjob.h",
                "clangreferencescollector.cpp",
                "clangreferencescollector.h",
                "clangrequestannotationsjob.cpp",
                "clangrequestannotationsjob.h",
                "clangrequestreferencesjob.cpp",
                "clangrequestreferencesjob.h",
                "clangrequesttooltipjob.cpp",
                "clangrequesttooltipjob.h",
                "clangresumedocumentjob.cpp",
                "clangresumedocumentjob.h",
                "clangstring.h",
                "clangsupportivetranslationunitinitializer.cpp",
                "clangsupportivetranslationunitinitializer.h",
                "clangsuspenddocumentjob.cpp",
                "clangsuspenddocumentjob.h",
                "clangtooltipinfocollector.cpp",
                "clangtooltipinfocollector.h",
                "clangtranslationunit.cpp",
                "clangtranslationunit.h",
                "clangtranslationunits.cpp",
                "clangtranslationunits.h",
                "clangtranslationunitupdater.cpp",
                "clangtranslationunitupdater.h",
                "clangtype.cpp",
                "clangtype.h",
                "clangunsavedfilesshallowarguments.cpp",
                "clangunsavedfilesshallowarguments.h",
                "clangupdateannotationsjob.cpp",
                "clangupdateannotationsjob.h",
                "clangupdateextraannotationsjob.cpp",
                "clangupdateextraannotationsjob.h",
                "codecompleter.cpp",
                "codecompleter.h",
                "codecompletionchunkconverter.cpp",
                "codecompletionchunkconverter.h",
                "codecompletionsextractor.cpp",
                "codecompletionsextractor.h",
                "commandlinearguments.cpp",
                "commandlinearguments.h",
                "cursor.cpp",
                "cursor.h",
                "diagnostic.cpp",
                "diagnostic.h",
                "diagnosticset.cpp",
                "diagnosticset.h",
                "diagnosticsetiterator.h",
                "fixit.cpp",
                "fixit.h",
                "fulltokeninfo.cpp",
                "fulltokeninfo.h",
                "skippedsourceranges.cpp",
                "skippedsourceranges.h",
                "sourcelocation.cpp",
                "sourcelocation.h",
                "sourcerange.cpp",
                "sourcerange.h",
                "token.cpp",
                "token.h",
                "tokeninfo.cpp",
                "tokeninfo.h",
                "tokenprocessor.h",
                "tokenprocessoriterator.h",
                "unsavedfile.cpp",
                "unsavedfile.h",
                "unsavedfiles.cpp",
                "unsavedfiles.h",
                "utf8positionfromlinecolumn.cpp",
                "utf8positionfromlinecolumn.h",
            ]
        }

        Group {
            name: "sources from clangsupport"
            prefix: "../../../src/libs/clangsupport/"
            files: [
                "*.cpp",
                "*.h",
            ]
        }

        Group {
            name: "sources from clangcodemodel"
            prefix: "../../../src/plugins/clangcodemodel/"
            files: [
                "clangactivationsequencecontextprocessor.cpp",
                "clangactivationsequencecontextprocessor.h",
                "clangactivationsequenceprocessor.cpp",
                "clangactivationsequenceprocessor.h",
                "clangcompletionchunkstotextconverter.cpp",
                "clangcompletionchunkstotextconverter.h",
                "clangcompletioncontextanalyzer.cpp",
                "clangcompletioncontextanalyzer.h",
                "clangdiagnosticfilter.cpp",
                "clangdiagnosticfilter.h",
                "clangfixitoperation.cpp",
                "clangfixitoperation.h",
                "clanghighlightingresultreporter.cpp",
                "clanghighlightingresultreporter.h",
                "clangisdiagnosticrelatedtolocation.h",
                "clanguiheaderondiskmanager.cpp",
                "clanguiheaderondiskmanager.h",
            ]
        }

        Group {
            name: "sources from cpptools"
            prefix: "../../../src/plugins/cpptools/"
            files: [
                "compileroptionsbuilder.cpp",
                "compileroptionsbuilder.h",
                "cppprojectfile.cpp",
                "cppprojectfile.h",
                "cppprojectfilecategorizer.cpp",
                "cppprojectfilecategorizer.h",
                "cppprojectinfogenerator.cpp",
                "cppprojectpartchooser.cpp",
                "cppprojectpartchooser.h",
                "headerpathfilter.cpp",
                "headerpathfilter.h",
                "projectinfo.cpp",
                "projectinfo.h",
                "projectpart.cpp",
                "projectpart.h",
                "senddocumenttracker.cpp",
                "senddocumenttracker.h",
            ]
        }

        Group {
            name: "sources from clangtools"
            condition: libclang.present
            prefix: "../../../src/plugins/clangtools/"
            files: [
                "clangtoolsdiagnostic.cpp",
                "clangtoolsdiagnostic.h",
                "clangtoolslogfilereader.cpp",
                "clangtoolslogfilereader.h",
            ]
        }

        Group {
            name: "sources from clangdbpm"
            prefix: "../../../src/plugins/compilationdatabaseprojectmanager/"
            files: [
                "compilationdatabaseutils.cpp",
                "compilationdatabaseutils.h",
            ]
        }

        Group {
            name: "sources from ProjectExplorer"
            prefix: "../../../src/plugins/projectexplorer/"
            files: [
                "projectmacro.cpp",
                "projectmacro.h",
            ]
        }

        Group {
            name: "sources from ClangFormat"
            prefix: "../../../src/plugins/clangformat/"
            condition: libclang.present
                       && libclang.llvmFormattingLibs.length
                       && (!qbs.targetOS.contains("windows") || libclang.llvmBuildModeMatches)
            files: [
                "clangformatbaseindenter.cpp",
                "clangformatbaseindenter.h",
                "clangformatconstants.h",
            ]
        }

        Group {
            name: "sources from Debugger"
            prefix: "../../../src/plugins/debugger/analyzer/"
            files: [
                "diagnosticlocation.cpp",
                "diagnosticlocation.h",
            ]
        }

        Rule {
            inputs: "qt_plugin_metadata"
            Artifact {
                filePath: FileInfo.joinPaths(product.destinationDirectory, "CppTools.json")
                fileTags: "json_copy"
            }
            prepare: {
                var cmd = new JavaScriptCommand;
                cmd.description = "copying " + input.fileName;
                cmd.sourceCode = function() { File.copy(input.filePath, output.filePath); };
                return cmd;
            }
        }
    }
}
