/****************************************************************************
**
** Copyright (C) 2018 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Quick Templates 2 module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL3$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPLv3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or later as published by the Free
** Software Foundation and appearing in the file LICENSE.GPL included in
** the packaging of this file. Please review the following information to
** ensure the GNU General Public License version 2.0 requirements will be
** met: http://www.gnu.org/licenses/gpl-2.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qquickpopupanchors_p.h"
#include "qquickpopupanchors_p_p.h"
#include "qquickpopup_p_p.h"

QT_BEGIN_NAMESPACE

QQuickPopupAnchors::QQuickPopupAnchors(QQuickPopup *popup)
    : QObject(*(new QQuickPopupAnchorsPrivate), popup)
{
    Q_D(QQuickPopupAnchors);
    d->popup = popup;
}

QQuickPopupAnchors::~QQuickPopupAnchors()
{
    Q_D(const QQuickPopupAnchors);
    if (d->centerIn) {
        auto centerInPrivate = QQuickItemPrivate::get(d->centerIn);
        centerInPrivate->removeItemChangeListener(this, QQuickItemPrivate::Destroyed);
    }
}

QQuickItem *QQuickPopupAnchors::centerIn() const
{
    Q_D(const QQuickPopupAnchors);
    return d->centerIn;
}

void QQuickPopupAnchors::setCenterIn(QQuickItem *item)
{
    Q_D(QQuickPopupAnchors);
    if (item == d->centerIn)
        return;

    if (d->centerIn) {
        auto centerInPrivate = QQuickItemPrivate::get(d->centerIn);
        centerInPrivate->removeItemChangeListener(this, QQuickItemPrivate::Destroyed);
    }

    d->centerIn = item;

    if (d->centerIn) {
        auto centerInPrivate = QQuickItemPrivate::get(d->centerIn);
        centerInPrivate->addItemChangeListener(this, QQuickItemPrivate::Destroyed);
    }

    QQuickPopupPrivate::get(d->popup)->reposition();

    emit centerInChanged();
}

void QQuickPopupAnchors::resetCenterIn()
{
    setCenterIn(nullptr);
}

void QQuickPopupAnchors::itemDestroyed(QQuickItem *)
{
    resetCenterIn();
}

QT_END_NAMESPACE

#include "moc_qquickpopupanchors_p.cpp"
