// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CAST_CERTIFICATE_CAST_CERT_READER_H_
#define COMPONENTS_CAST_CERTIFICATE_CAST_CERT_READER_H_

#include <memory>
#include <string>
#include <vector>

#include "base/files/file_path.h"
#include "net/cert/internal/trust_store_in_memory.h"

namespace cast_certificate {

// Creates a trust store using the test roots encoded in the PEM file at |path|.
bool PopulateStoreWithCertsFromPath(net::TrustStoreInMemory* store,
                                    const base::FilePath& path);

// Reads a PEM file located at |path|, containing certificates to a vector of
// their DER data.
std::vector<std::string> ReadCertificateChainFromFile(
    const base::FilePath& path);

}  // namespace cast_certificate

#endif  // COMPONENTS_CAST_CERTIFICATE_CAST_CERT_READER_H_
