/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.AWTException;
import java.awt.BDRootWindow;
import java.awt.Component;
import java.awt.image.BufferedImage;
import org.havi.ui.HScene;
import org.videolan.Logger;

public class GUIManager
extends BDRootWindow {
    private static GUIManager instance = null;
    private static final long serialVersionUID = 8670041014494973439L;

    private GUIManager() {
    }

    public static synchronized GUIManager createInstance() {
        if (instance == null) {
            instance = new GUIManager();
        } else {
            instance.clearOverlay();
        }
        return instance;
    }

    public static synchronized GUIManager getInstance() {
        if (instance == null) {
            Logger.getLogger("GUIManager").error("getInstance(): no instance !");
            throw new Error("no GUIManager instance");
        }
        return instance;
    }

    public BufferedImage createBufferedImage(int width, int height) throws AWTException {
        BufferedImage img = this.getGraphicsConfiguration().createCompatibleImage(width, height);
        if (img == null) {
            throw new AWTException("Failed to create buffered image");
        }
        return img;
    }

    public HScene getFocusHScene() {
        for (Component component = this.getFocusOwner(); component != null; component = component.getParent()) {
            if (!(component instanceof HScene)) continue;
            return (HScene)component;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() throws Throwable {
        Class clazz = GUIManager.class;
        synchronized (clazz) {
            if (instance != null) {
                instance.setVisible(false);
                instance.removeAll();
                instance.dispose();
                instance = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            super.dispose();
        }
        finally {
            instance = null;
        }
    }
}

