/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.provider.apache;

import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class CapiConnectionSocketFactory
implements ConnectionSocketFactory {
    private NetworkConfig config = null;

    public CapiConnectionSocketFactory(NetworkConfig config) {
        this.config = config;
    }

    public Socket createSocket(HttpContext context) throws IOException {
        Proxy proxy = null;
        if (this.config != null && (this.config.getProxy() != null && !this.config.getProxy().isEmpty() || this.config.getProxyPort() != null && !this.config.getProxyPort().isEmpty())) {
            InetSocketAddress addr = new InetSocketAddress(this.config.getProxy(), Integer.parseInt(this.config.getProxyPort()));
            proxy = new Proxy(this.getType(this.config.getProxyType()), addr);
        } else {
            proxy = Proxy.NO_PROXY;
        }
        return new Socket(proxy);
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException, ConnectTimeoutException {
        Socket sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException((IOException)ex, host, new InetAddress[]{remoteAddress.getAddress()});
        }
        return sock;
    }

    private Proxy.Type getType(String type) {
        if (type.startsWith("http")) {
            return Proxy.Type.HTTP;
        }
        if (type.startsWith("socks")) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.DIRECT;
    }
}

