/*
 * Decompiled with CFR 0.152.
 */
package esecurity.statistics.utils;

import esecurity.statistics.utils.AdditionalLogInfo;
import esecurity.statistics.utils.StatisticKeyEnum;
import esecurity.statistics.utils.StatisticKeyEnumInt;
import esecurity.statistics.utils.StatisticTimeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticsInfoUtils {
    private static HashMap<String, HashMap<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>>> statisticsInfo = new HashMap();
    private static HashMap<String, AdditionalLogInfo> additionalLogInfo = new HashMap();

    private StatisticsInfoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initStatisticInfo() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        HashMap value = new HashMap();
        StatisticTimeInfo sti = new StatisticTimeInfo();
        sti.start();
        ArrayList<StatisticTimeInfo> values = new ArrayList<StatisticTimeInfo>();
        values.add(sti);
        value.put(StatisticKeyEnum.TOTAL_TIME, values);
        HashMap<String, HashMap<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>>> hashMap = statisticsInfo;
        synchronized (hashMap) {
            statisticsInfo.put(threadId, value);
            additionalLogInfo.put(threadId, new AdditionalLogInfo());
        }
    }

    public static Map<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> getStatisticInfo() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        HashMap<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> objReturn = null;
        try {
            if (statisticsInfo.containsKey(threadId)) {
                objReturn = statisticsInfo.get(threadId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objReturn;
    }

    public static void start(StatisticKeyEnumInt key) {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        if (statisticsInfo.containsKey(threadId)) {
            HashMap<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> threadStats = statisticsInfo.get(threadId);
            StatisticTimeInfo thisTime = new StatisticTimeInfo();
            thisTime.start();
            if (threadStats.containsKey(key)) {
                threadStats.get(key).add(thisTime);
            } else {
                ArrayList<StatisticTimeInfo> keyTimes = new ArrayList<StatisticTimeInfo>();
                keyTimes.add(thisTime);
                threadStats.put(key, keyTimes);
            }
        }
    }

    public static void end(StatisticKeyEnumInt key) {
        HashMap<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> threadStats;
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        if (statisticsInfo.containsKey(threadId) && (threadStats = statisticsInfo.get(threadId)).containsKey(key)) {
            threadStats.get(key).get(threadStats.get(key).size() - 1).end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> clearHeaders() {
        HashMap<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> objReturn;
        block5: {
            objReturn = null;
            String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
            try {
                if (!statisticsInfo.containsKey(threadId)) break block5;
                HashMap<String, HashMap<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>>> hashMap = statisticsInfo;
                synchronized (hashMap) {
                    objReturn = statisticsInfo.remove(threadId);
                }
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return objReturn;
    }

    public static AdditionalLogInfo getAdditionalInfo() {
        String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
        AdditionalLogInfo objReturn = null;
        try {
            objReturn = additionalLogInfo.get(threadId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        block5: {
            StatisticsInfoUtils.clearHeaders();
            String threadId = Thread.currentThread().getName() + Thread.currentThread().getId();
            try {
                if (!additionalLogInfo.containsKey(threadId)) break block5;
                HashMap<String, AdditionalLogInfo> hashMap = additionalLogInfo;
                synchronized (hashMap) {
                    additionalLogInfo.remove(threadId);
                }
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public static String retriveStatics() {
        StringBuilder strReturn = new StringBuilder();
        Map<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> statistics = StatisticsInfoUtils.clearHeaders();
        if (statistics == null) {
            return strReturn.toString();
        }
        strReturn.append("[");
        long serviceTime = 0L;
        ArrayList<StatisticTimeInfo> times = statistics.remove(StatisticKeyEnum.TOTAL_TIME);
        AdditionalLogInfo addInfo = StatisticsInfoUtils.getAdditionalInfo();
        if (times != null) {
            times.get(0).end();
            serviceTime = times.get(0).getDiffInSec();
            strReturn.append(StatisticKeyEnum.TOTAL_TIME.getName() + ":" + serviceTime);
            if (addInfo != null) {
                addInfo.setTotalTime(serviceTime);
            }
        }
        for (Map.Entry<StatisticKeyEnumInt, ArrayList<StatisticTimeInfo>> entry : statistics.entrySet()) {
            String metricName = entry.getKey().getName();
            int i = 0;
            for (StatisticTimeInfo time : entry.getValue()) {
                serviceTime -= time.getDiffInSec();
                strReturn.append(";" + metricName + (i == 0 ? "" : Integer.valueOf(i)) + ":" + time.getDiffInSec());
                ++i;
            }
        }
        strReturn.append("]");
        if (addInfo != null) {
            addInfo.setMetrics(strReturn.toString());
        }
        return strReturn.toString();
    }
}

