/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public enum DigestAlgorithm {
    MD5("MD5", CMSSignedDataGenerator.DIGEST_MD5, "http://www.w3.org/2001/04/xmlenc#md5", it.actalis.ellips.capi.signature.DigestAlgorithm$a.b),
    SHA1("SHA1", CMSSignedDataGenerator.DIGEST_SHA1, "http://www.w3.org/2000/09/xmldsig#sha1", it.actalis.ellips.capi.signature.DigestAlgorithm$a.b),
    SHA224("SHA-224", CMSSignedDataGenerator.DIGEST_SHA224, "https://www.w3.org/2001/04/xmldsig-more#sha224", it.actalis.ellips.capi.signature.DigestAlgorithm$a.b),
    SHA256("SHA-256", CMSSignedDataGenerator.DIGEST_SHA256, "http://www.w3.org/2001/04/xmlenc#sha256", it.actalis.ellips.capi.signature.DigestAlgorithm$a.a),
    SHA384("SHA-384", CMSSignedDataGenerator.DIGEST_SHA384, "http://www.w3.org/2000/09/xmldsig#sh384", it.actalis.ellips.capi.signature.DigestAlgorithm$a.a),
    SHA512("SHA-512", CMSSignedDataGenerator.DIGEST_SHA512, "http://www.w3.org/2001/04/xmlenc#sha512", it.actalis.ellips.capi.signature.DigestAlgorithm$a.a),
    SHA3_224("SHA3-224", NISTObjectIdentifiers.id_sha3_224.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-224", it.actalis.ellips.capi.signature.DigestAlgorithm$a.b),
    SHA3_256("SHA3-256", NISTObjectIdentifiers.id_sha3_256.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-256", it.actalis.ellips.capi.signature.DigestAlgorithm$a.a),
    SHA3_384("SHA3-384", NISTObjectIdentifiers.id_sha3_384.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-384", it.actalis.ellips.capi.signature.DigestAlgorithm$a.a),
    SHA3_512("SHA3-512", NISTObjectIdentifiers.id_sha3_512.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-512", it.actalis.ellips.capi.signature.DigestAlgorithm$a.a),
    RIPEMD128("RIPEMD-128", CMSSignedDataGenerator.DIGEST_RIPEMD128, null, it.actalis.ellips.capi.signature.DigestAlgorithm$a.b),
    RIPEMD160("RIPEMD-160", CMSSignedDataGenerator.DIGEST_RIPEMD160, "http://www.w3.org/2001/04/xmlenc#ripemd160", it.actalis.ellips.capi.signature.DigestAlgorithm$a.b),
    RIPEMD256("RIPEMD-256", CMSSignedDataGenerator.DIGEST_RIPEMD256, null, it.actalis.ellips.capi.signature.DigestAlgorithm$a.b),
    GOST3411("GOST3411", CMSSignedDataGenerator.DIGEST_GOST3411, null, it.actalis.ellips.capi.signature.DigestAlgorithm$a.b);

    private String a = null;
    private String b = null;
    private String c = null;
    private a d = null;

    private DigestAlgorithm(String string2, String string3, String string4, a a2) {
        this.a = string2;
        this.b = string3;
        this.c = string4;
        this.d = a2;
    }

    public final String getId() {
        return this.b;
    }

    public final String toString() {
        return this.a;
    }

    public final String getXadesID() {
        return this.c;
    }

    public final boolean isRecommended() {
        return this.d != null && this.d.equals((Object)it.actalis.ellips.capi.signature.DigestAlgorithm$a.a);
    }

    public final boolean isForbidden() {
        return this.d != null && this.d.equals((Object)it.actalis.ellips.capi.signature.DigestAlgorithm$a.c);
    }

    public static DigestAlgorithm valueFromJavaName(String string) {
        int n = -1;
        switch (string.hashCode()) {
            case 76158: {
                if (!string.equals("MD5")) break;
                n = 0;
                break;
            }
            case 2543909: {
                if (!string.equals("SHA1")) break;
                n = 1;
                break;
            }
            case -1850268184: {
                if (!string.equals("SHA224")) break;
                n = 2;
                break;
            }
            case -1523887821: {
                if (!string.equals("SHA-224")) break;
                n = 3;
                break;
            }
            case -1850268089: {
                if (!string.equals("SHA256")) break;
                n = 4;
                break;
            }
            case -1523887726: {
                if (!string.equals("SHA-256")) break;
                n = 5;
                break;
            }
            case -1850267037: {
                if (!string.equals("SHA384")) break;
                n = 6;
                break;
            }
            case -1523886674: {
                if (!string.equals("SHA-384")) break;
                n = 7;
                break;
            }
            case -1850265334: {
                if (!string.equals("SHA512")) break;
                n = 8;
                break;
            }
            case -1523884971: {
                if (!string.equals("SHA-512")) break;
                n = 9;
                break;
            }
            case 9509966: {
                if (!string.equals("SHA3-224")) break;
                n = 10;
                break;
            }
            case 9510061: {
                if (!string.equals("SHA3-256")) break;
                n = 11;
                break;
            }
            case 9511113: {
                if (!string.equals("SHA3-384")) break;
                n = 12;
                break;
            }
            case 9512816: {
                if (!string.equals("SHA3-512")) break;
                n = 13;
                break;
            }
            case -961643923: {
                if (!string.equals("RIPEMD-128")) break;
                n = 14;
                break;
            }
            case -961643807: {
                if (!string.equals("RIPEMD-160")) break;
                n = 15;
                break;
            }
            case -961642871: {
                if (!string.equals("RIPEMD-256")) break;
                n = 16;
                break;
            }
            case -1260804854: {
                if (!string.equals("GOST3411")) break;
                n = 17;
            }
        }
        switch (n) {
            case 0: {
                return MD5;
            }
            case 1: {
                return SHA1;
            }
            case 2: 
            case 3: {
                return SHA224;
            }
            case 4: 
            case 5: {
                return SHA256;
            }
            case 6: 
            case 7: {
                return SHA384;
            }
            case 8: 
            case 9: {
                return SHA512;
            }
            case 10: {
                return SHA3_224;
            }
            case 11: {
                return SHA3_256;
            }
            case 12: {
                return SHA3_384;
            }
            case 13: {
                return SHA3_512;
            }
            case 14: {
                return RIPEMD128;
            }
            case 15: {
                return RIPEMD160;
            }
            case 16: {
                return RIPEMD256;
            }
            case 17: {
                return GOST3411;
            }
        }
        return null;
    }

    public static DigestAlgorithm valueFromXadesId(String string) {
        if (string.equals(DigestAlgorithm.MD5.c)) {
            return MD5;
        }
        if (string.equals(DigestAlgorithm.SHA1.c)) {
            return SHA1;
        }
        if (string.equals(DigestAlgorithm.SHA224.c)) {
            return SHA224;
        }
        if (string.equals(DigestAlgorithm.SHA256.c)) {
            return SHA256;
        }
        if (string.equals(DigestAlgorithm.SHA384.c)) {
            return SHA384;
        }
        if (string.equals(DigestAlgorithm.SHA512.c)) {
            return SHA512;
        }
        if (string.equals(DigestAlgorithm.RIPEMD160.c)) {
            return RIPEMD160;
        }
        if (string.equals(DigestAlgorithm.SHA3_224.c)) {
            return SHA3_224;
        }
        if (string.equals(DigestAlgorithm.SHA3_256.c)) {
            return SHA3_256;
        }
        if (string.equals(DigestAlgorithm.SHA3_384.c)) {
            return SHA3_384;
        }
        if (string.equals(DigestAlgorithm.SHA3_512.c)) {
            return SHA3_512;
        }
        return null;
    }

    public static DigestAlgorithm valueFromCadesId(String string) {
        if (string.equals(CMSSignedDataGenerator.DIGEST_MD5)) {
            return MD5;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_SHA1)) {
            return SHA1;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_SHA224)) {
            return SHA224;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_SHA256)) {
            return SHA256;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_SHA384)) {
            return SHA384;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_SHA512)) {
            return SHA512;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_RIPEMD128)) {
            return RIPEMD128;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_RIPEMD160)) {
            return RIPEMD160;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_RIPEMD256)) {
            return RIPEMD256;
        }
        if (string.equals(CMSSignedDataGenerator.DIGEST_GOST3411)) {
            return GOST3411;
        }
        if (string.equals(NISTObjectIdentifiers.id_sha3_224.getId())) {
            return SHA3_224;
        }
        if (string.equals(NISTObjectIdentifiers.id_sha3_256.getId())) {
            return SHA3_256;
        }
        if (string.equals(NISTObjectIdentifiers.id_sha3_384.getId())) {
            return SHA3_384;
        }
        if (string.equals(NISTObjectIdentifiers.id_sha3_512.getId())) {
            return SHA3_512;
        }
        return null;
    }

    private static enum a {
        a,
        b,
        c;

    }
}

