/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.ProxyAutenticator;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.StringTokenizer;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import org.bouncycastle.util.io.Streams;
import org.slf4j.Logger;

public class HTTP {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private UrlClient b = null;
    public static NetworkConfig defaultConfig = new NetworkConfig(a, false, "HTTPUrlConnectionProvider");
    private NetworkConfig c = null;
    private boolean d = false;
    private String e = null;
    private String f = null;
    private String g = null;
    private String h = null;
    private String i = null;
    private String j = null;
    private int k = 0;

    public HTTP() {
        this(defaultConfig);
    }

    public HTTP(NetworkConfig networkConfig) {
        this.c = networkConfig;
        this.b = new UrlClient(this.c, a);
        if (this instanceof HttpsClient) {
            try {
                if (((HttpsClient)this).getCDB() != null) {
                    this.b.setTrustStore(((HttpsClient)this).getCDB().toTrustStore());
                }
                return;
            }
            catch (CertDBException certDBException) {
                a.error(certDBException.getMessage(), (Throwable)certDBException);
                return;
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void setProxyAutenticator(ProxyAutenticator proxyAutenticator) {
        this.c.setProxyauthenticator(proxyAutenticator);
    }

    public void setProxyParams(boolean bl, String string, int n, String string2, String string3, String string4, String string5, String string6) {
        this.c.setProxy(string);
        this.c.setProxyPort("" + n);
        this.c.setUserProxy(string3);
        this.c.setPasswordProxy(string4);
        this.c.setProxynohosts(HTTP.a(string6));
    }

    public void setProxyAuthenticationOnlyBasic(boolean bl) {
        this.d = bl;
    }

    public void setBasicAuthParams(String string, String string2) {
        this.e = string;
        this.f = string2;
    }

    public void setPostTimeOut(int n) {
        this.k = n;
    }

    public void setGetContentCheck(String string) {
        this.g = string;
    }

    public void setPostAccept(String string) {
        this.h = string;
    }

    public void setGetAccept(String string) {
        this.i = string;
    }

    public String getRequestType() {
        return this.j;
    }

    public void setRequestType(String string) {
        this.j = string;
    }

    public byte[] doGet(String string, String string2) throws CapiException {
        return this.doGet(string, string2, true);
    }

    public byte[] doGet(String string, String string2, boolean bl) throws CapiException {
        int n;
        Object object;
        Object object2;
        Object object3 = null;
        if (string == null) {
            throw new CapiException("Null URL", 1001);
        }
        if (!string.toUpperCase().startsWith("HTTP")) {
            throw new CapiException("Invalid URL", 1002);
        }
        try {
            object2 = new URI(string);
        }
        catch (Exception exception) {
            throw new CapiException("Invalid URL", 1002);
        }
        a.debug("doGet from URL: " + string);
        if (this.hasProxy() && this.b(string)) {
            a.debug("Passing through proxy: " + this.c.getProxy() + ":" + this.c.getProxyPort());
            if (this.c.getUserProxy() != null && this.c.getUserProxy().length() > 0) {
                a.debug("proxyuser defined ... (" + this.c.getUserProxy() + ")");
                if (this.d) {
                    a.debug("onlyBasicAuthentProxy is TRUE ...");
                    this.c.setPreferBasic(true);
                }
            }
            try {
                object = InetAddress.getLocalHost();
                object2 = object.getHostName();
                a.debug("Local host name: " + (String)object2);
            }
            catch (Exception exception) {
                throw new CapiException("Error getting Local Host name", 91000);
            }
        }
        if (this.e != null && this.e.length() > 0) {
            a.debug("Basic authentication requested for user " + this.e);
            object3 = new URLCredentials(this.e, this.f, null, null);
            a.debug("Basic authentication activated.");
        }
        if (this.k != 0) {
            this.c.setConnectionTimeOut("" + this.k);
        }
        object2 = null;
        object = null;
        if (this.i != null) {
            object = new RequestData();
            object.setAcceptHeader(this.i);
        }
        String string3 = "";
        for (n = 0; !(n >= 3 || (object2 = this.b.downloadUrl(string, object, object3)) != null && object2.getStatus().equals("OK")); ++n) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (object2 == null || !object2.getStatus().equals("OK")) {
            if (n == 3) {
                if (this.hasProxy() && this.b(string)) {
                    throw new CapiException("Unaspected proxy error during HTTP GET", 91008);
                }
                throw new CapiException("File not found", 91004);
            }
            throw new CapiException("HTTP GET error: " + object2.getStatus(), 91007);
        }
        if (this.g != null && !string3.trim().endsWith(this.g.trim())) {
            a.debug("Content-type: " + string3 + " different from " + this.g);
            throw new CapiException("HTTP ContentTypeMismatch", 91007);
        }
        a.debug("Getting response body...");
        object3 = object2.getData();
        a.debug("Terminated doGet from URL: " + string);
        if (string2 != null) {
            a.debug("saving to:" + string2);
            Util.saveToFile((byte[])object3, string2);
        }
        return object3;
    }

    public byte[] doPost(String string, String object, InputStream inputStream, String string2) throws CapiException {
        URLCredentials uRLCredentials = null;
        RequestData requestData = new RequestData();
        if (!string.toUpperCase().startsWith("HTTP")) {
            throw new CapiException("Invalid URL", 1002);
        }
        try {
            if (inputStream != null) {
                requestData.setPostdata(Streams.readAll((InputStream)inputStream));
            }
            requestData.setContentType((String)object);
            a.debug("doPOST to URL Http:" + string);
            if (this.hasProxy() && this.b(string)) {
                a.debug("Passing through proxy: " + this.c.getProxy() + ":" + this.c.getProxyPort());
                if (this.c.getUserProxy() != null && this.c.getUserProxy().length() > 0) {
                    a.debug("proxyuser defined ...");
                    if (this.d) {
                        a.debug("onlyBasicAuthentProxy is TRUE ...");
                        this.c.setPreferBasic(true);
                    }
                }
                try {
                    object = InetAddress.getLocalHost();
                    object = ((InetAddress)object).getHostName();
                    a.debug("Local host name: " + (String)object);
                }
                catch (Exception exception) {
                    throw new CapiException("Error getting Local Host name", 91000);
                }
            }
            if (this.e != null && this.e.length() > 0) {
                a.debug("Basic authentication requested for user " + this.e);
                uRLCredentials = new URLCredentials(this.e, this.f, null, null);
                a.debug("Basic authentication activated.");
            }
            if (this.k != 0) {
                this.c.setConnectionTimeOut("" + this.k);
            }
            if (this.h != null) {
                requestData.setAcceptHeader(this.h);
            }
            if (this.j != null) {
                requestData.setType(this.j);
            }
            object = this.b.downloadUrl(string, requestData, uRLCredentials);
            a.debug("Response status code: " + object.getStatus());
            a.debug("Response status message: " + object.getStatusMessage());
            if (object == null || !object.getStatus().equals("OK")) {
                a.debug("Unexpected failure: " + object.getStatus());
                throw new CapiException("HTTP Post failure: " + object.getStatus(), 91007);
            }
            object = object.getData();
            a.debug("Terminated doPost to URL Http:" + string);
            if (string2 != null) {
                a.debug("saving to:" + string2);
                Util.saveToFile((byte[])object, string2);
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                a.debug("Failed closing postFileStream");
            }
            return object;
        }
        catch (ConnectException connectException) {
            if (this.hasProxy() && this.b(string)) {
                throw new CapiException("FailedConnect during HTTP POST through proxy", 91002);
            }
            throw new CapiException("FailedConnect during HTTP POST", 91002);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            throw new CapiException("Server not authenticated", 92001);
        }
        catch (SSLProtocolException sSLProtocolException) {
            throw new CapiException("HTTPS SSL Protocol error", 92002);
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            throw new CapiException("HTTPS Handshake error", 92000);
        }
        catch (SSLKeyException sSLKeyException) {
            throw new CapiException("HTTPS Key error", 92003);
        }
        catch (IOException iOException) {
            throw new CapiException("FailedIO during HTTP POST " + iOException.getMessage(), 91003);
        }
        catch (NullPointerException nullPointerException) {
            throw new CapiException("HttpsClient socket not trusted", 91007);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CapiException("HTTP Post: invalid address", 91007);
        }
        catch (CapiException capiException) {
            object = capiException;
            throw capiException;
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 91007);
        }
    }

    public static String getSystemProxy(Proxy.Type type) {
        a.debug("[getSystemProxy] begin ... ");
        try {
            Object object = new ProxySearch();
            if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.WIN) {
                object.addStrategy(ProxySearch.Strategy.IE);
                object.addStrategy(ProxySearch.Strategy.FIREFOX);
                object.addStrategy(ProxySearch.Strategy.JAVA);
            } else if (PlatformUtil.getCurrentPlattform() == PlatformUtil.Platform.LINUX) {
                object.addStrategy(ProxySearch.Strategy.GNOME);
                object.addStrategy(ProxySearch.Strategy.KDE);
                object.addStrategy(ProxySearch.Strategy.FIREFOX);
            }
            object.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
            object = object.getProxySelector();
            object = ((ProxySelector)object).select(new URL("http://www.yahoo.com/").toURI());
            if (object == null) {
                a.debug("[getSystemProxy] No Proxy");
                return null;
            }
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Proxy)object.next();
                a.debug("[getSystemProxy] proxy type : " + (Object)((Object)((Proxy)object2).type()));
                if (((Proxy)object2).type().equals((Object)Proxy.Type.DIRECT)) {
                    a.debug("[getSystemProxy] DIRECT Proxy");
                    continue;
                }
                if (!((Proxy)object2).type().equals((Object)type)) {
                    a.debug("[getSystemProxy] No Proxy " + type.toString());
                    continue;
                }
                if ((object2 = (InetSocketAddress)((Proxy)object2).address()) == null) {
                    a.debug("[getSystemProxy] No Proxy");
                    continue;
                }
                a.debug("[getSystemProxy] proxy hostname : " + ((InetSocketAddress)object2).getHostName());
                a.debug("[getSystemProxy] proxy port : " + ((InetSocketAddress)object2).getPort());
                return ((InetSocketAddress)object2).getHostName() + ":" + ((InetSocketAddress)object2).getPort();
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        return null;
    }

    private static String[] a(String object) {
        if (object == null) {
            return new String[0];
        }
        try {
            object = new StringTokenizer((String)object, ";");
            String[] stringArray = new String[((StringTokenizer)object).countTokens()];
            int n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringArray[n] = ((StringTokenizer)object).nextToken().trim();
                ++n;
            }
            return stringArray;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return new String[0];
        }
    }

    private boolean b(String object) {
        try {
            if (this.c.getProxynohosts() != null) {
                a.debug("isProxyHost URL: " + (String)object);
                object = new URI((String)object);
                object = ((URI)object).getHost();
                a.debug("URL host:" + (String)object);
                for (int i = 0; i < this.c.getProxynohosts().length; ++i) {
                    if (!((String)object).equalsIgnoreCase(this.c.getProxynohosts()[i])) continue;
                    a.debug("nonProxyHost:" + (String)object);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
        }
        return true;
    }

    public static void setDefaultConfig(NetworkConfig networkConfig) {
        defaultConfig = networkConfig;
    }

    public boolean hasProxy() {
        if (this.c != null) {
            return this.c.getProxy() != null && !this.c.getProxy().isEmpty();
        }
        return !defaultConfig.getProxy().isEmpty();
    }

    public NetworkConfig getConfig() {
        if (this.c != null) {
            return this.c;
        }
        return defaultConfig;
    }
}

