/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.DataHandlerUtils;
import it.actalis.ellips.capi.datahandlers.inputs.CloudInputHandler;
import java.io.IOException;

public class S3InputHandler
extends CloudInputHandler {
    protected DataHandler.S3_TYPE s3CloudType = null;
    protected String bucket = null;
    protected String filepath = null;
    protected AmazonS3 s3Client = null;
    protected S3Object s3Object = null;
    protected S3ObjectInputStream s3InputStream = null;

    public DataHandler.S3_TYPE getS3CloudType() {
        return this.s3CloudType;
    }

    protected S3InputHandler() {
    }

    protected final void initS3InputHandler(AmazonS3ClientBuilder amazonS3ClientBuilder, String string, String string2, String string3) throws IOException {
        if (amazonS3ClientBuilder == null) {
            throw new IllegalArgumentException("Please specify a non-null S3 client builder!");
        }
        this.s3Client = (AmazonS3)amazonS3ClientBuilder.build();
        this.bucket = string;
        this.filepath = string2 == null ? "" : string2;
        this.initCloudInputHandler(DataHandler.CLOUD_TYPE.S3, string3);
        this.s3CloudType = DataHandler.S3_TYPE.GENERIC;
    }

    public S3InputHandler(AmazonS3ClientBuilder amazonS3ClientBuilder, String string, String string2, String string3) throws IOException {
        this.initS3InputHandler(amazonS3ClientBuilder, string, string2, string3);
    }

    @Override
    protected CloudInputHandler.CloudReadProxyInputStream getCloudReadProxyInputStream() {
        this.s3Object = this.s3Client.getObject(new GetObjectRequest(this.bucket, DataHandlerUtils.getS3FileKey(this.filepath, this.name)));
        this.s3InputStream = this.s3Object.getObjectContent();
        return new S3ReadProxyInputStream(this);
    }

    protected class S3ReadProxyInputStream
    extends CloudInputHandler.CloudReadProxyInputStream {
        private /* synthetic */ S3InputHandler a;

        protected S3ReadProxyInputStream(S3InputHandler s3InputHandler) {
            this.a = s3InputHandler;
            super(s3InputHandler);
        }

        @Override
        public int available() throws IOException {
            return this.a.s3InputStream.available();
        }

        @Override
        public int read() throws IOException {
            return this.a.s3InputStream.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.a.s3InputStream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.a.s3InputStream.read(byArray, n, n2);
        }

        @Override
        public void reset() throws IOException {
            this.a.s3InputStream.reset();
        }

        @Override
        public void close() throws IOException {
            this.a.s3InputStream.close();
            this.a.s3Object.close();
        }

        @Override
        public long skip(long l) throws IOException {
            return this.a.s3InputStream.skip(l);
        }

        @Override
        public synchronized void mark(int n) {
            this.a.s3InputStream.mark(n);
        }

        @Override
        public boolean markSupported() {
            return this.a.s3InputStream.markSupported();
        }
    }
}

