/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.cert.CertificateEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class ValidatedDocumentUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static boolean hasMessage(ValidatedDocument validatedDocument, ValidatorMessageEnum validatorMessageEnum) {
        for (ValidatedSigner validatedBean : validatedDocument.getReferenceSigners()) {
            if (ValidatedDocumentUtils.hasMessage(validatedBean, validatorMessageEnum)) {
                return true;
            }
            for (ValidatedSigner validatedSigner : validatedBean.getCounterSigners()) {
                if (!ValidatedDocumentUtils.hasMessage(validatedSigner, validatorMessageEnum)) continue;
                return true;
            }
            for (ValidatedSigner validatedSigner : validatedBean.getTimeStamps()) {
                if (!ValidatedDocumentUtils.hasMessage(validatedSigner, validatorMessageEnum)) continue;
                return true;
            }
            ValidatedCertificate validatedCertificate = validatedBean.getCert();
            if (!ValidatedDocumentUtils.hasMessage(validatedCertificate, validatorMessageEnum)) continue;
            return true;
        }
        for (ValidatedDocument validatedDocument2 : validatedDocument.getSubResults()) {
            if (!ValidatedDocumentUtils.hasMessage(validatedDocument2, validatorMessageEnum)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMessage(ValidatedBean validatedBean, ValidatorMessageEnum validatorMessageEnum) {
        if (validatedBean.hasMessage(validatorMessageEnum)) {
            return true;
        }
        for (int i = 0; i < validatedBean.getMessages().size(); ++i) {
            if (!ValidatedDocumentUtils.a(validatedBean.getMessages().get(i), validatorMessageEnum.getCode())) continue;
            return true;
        }
        return false;
    }

    private static boolean a(ValidatorMessage validatorMessage, String string) {
        if (validatorMessage.getMessageCode().equals(string)) {
            return true;
        }
        for (int i = 0; i < validatorMessage.getNotes().size(); ++i) {
            if (!ValidatedDocumentUtils.a(validatorMessage.getNotes().get(i), string)) continue;
            return true;
        }
        return false;
    }

    public static List<ValidatorMessage> getAllMessages(ValidatedBean object) {
        LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
        for (ValidatorMessage validatorMessage : ((ValidatedBean)((Object)object)).getMessages()) {
            linkedList.add(validatorMessage);
            for (ValidatorMessage validatorMessage2 : validatorMessage.getNotes()) {
                linkedList.addAll(ValidatedDocumentUtils.getAllSubMessages(validatorMessage2));
            }
        }
        return linkedList;
    }

    public static List<ValidatorMessage> getAllSubMessages(ValidatorMessage object) {
        LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
        linkedList.add((ValidatorMessage)object);
        for (ValidatorMessage validatorMessage : ((ValidatorMessage)object).getNotes()) {
            linkedList.addAll(ValidatedDocumentUtils.getAllSubMessages(validatorMessage));
        }
        return linkedList;
    }

    public static List<ValidatorMessage> getAllMessages(ValidatedBean object, List<String> list) {
        LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
        for (ValidatorMessage validatorMessage : ((ValidatedBean)((Object)object)).getMessages()) {
            if (list.contains(validatorMessage.getMessageCode())) continue;
            linkedList.add(validatorMessage);
            for (ValidatorMessage validatorMessage2 : validatorMessage.getNotes()) {
                linkedList.addAll(ValidatedDocumentUtils.getAllSubMessages(validatorMessage2, list));
            }
        }
        return linkedList;
    }

    public static List<ValidatorMessage> getAllSubMessages(ValidatorMessage object, List<String> object22) {
        LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
        if (!object22.contains(((ValidatorMessage)((Object)object)).getMessageCode())) {
            linkedList.add((ValidatorMessage)((Object)object));
            for (ValidatorMessage validatorMessage : ((ValidatorMessage)((Object)object)).getNotes()) {
                linkedList.addAll(ValidatedDocumentUtils.getAllSubMessages(validatorMessage));
            }
        }
        return linkedList;
    }

    public static String toString(ValidatedDocument validatedDocument) {
        return ValidatedDocumentUtils.toString(validatedDocument, "");
    }

    public static String toString(ValidatedDocument validatedDocument, String string) {
        if (validatedDocument == null) {
            return "";
        }
        if (string == null) {
            string = "";
        }
        String string2 = "";
        string2 = string2 + (string2 + String.format("%s %s\n", string, validatedDocument.getShortName()));
        for (ValidatorMessage object : validatedDocument.getMessages()) {
            string2 = string2 + String.format("%s %s - %s - %s\n", new Object[]{string, object.getLevel(), object.getMessageCode(), object.getMessage()});
        }
        string = string + " ";
        for (int i = 0; i < validatedDocument.getSigners().size(); ++i) {
            string2 = string2 + ValidatedDocumentUtils.toString(validatedDocument.getSigners().get(i), string, String.format("#%02d#", i + 1));
        }
        for (ValidatedDocument validatedDocument2 : validatedDocument.getSubResults()) {
            string2 = string2 + ValidatedDocumentUtils.toString(validatedDocument2, string + "  ");
        }
        return string2;
    }

    public static String toString(ValidatedSigner validatedSigner) {
        return ValidatedDocumentUtils.toString(validatedSigner, "", null);
    }

    public static String toString(ValidatedSigner validatedSigner, String string) {
        return ValidatedDocumentUtils.toString(validatedSigner, string, null);
    }

    public static String toString(ValidatedSigner validatedSigner, String string, String string2) {
        if (validatedSigner == null) {
            return "";
        }
        String string3 = "";
        for (ValidatorMessage validatorMessage : validatedSigner.getMessages()) {
            string3 = string2 != null ? string3 + String.format("%sFirma %s - %s\n", string, string2, validatedSigner.getSignerName()) : string3 + String.format("%sFirma - %s\n", string, validatedSigner.getSignerName());
            string3 = string3 + String.format("%s %s - %s - %s\n", new Object[]{string, validatorMessage.getLevel(), validatorMessage.getMessageCode(), validatorMessage.getMessage()});
            for (ValidatorMessage validatorMessage2 : validatorMessage.getNotes()) {
                string3 = string3 + ValidatedDocumentUtils.toString(validatorMessage2, string + "  ");
            }
            string3 = string3 + ValidatedDocumentUtils.toString(validatedSigner.getCert(), string);
            if (!validatedSigner.getCounterSigners().isEmpty()) {
                string3 = string3 + String.format("%sControfirme %s\n", string, string2);
            }
            for (ValidatedSigner validatedSigner2 : validatedSigner.getCounterSigners()) {
                string3 = string3 + ValidatedDocumentUtils.toString(validatedSigner2, string + "  ", string2);
            }
            if (!validatedSigner.getTimeStamps().isEmpty()) {
                string3 = string3 + String.format("%sMarche temporali %s\n", string, string2);
            }
            for (ValidatedSigner validatedSigner3 : validatedSigner.getTimeStamps()) {
                string3 = string3 + ValidatedDocumentUtils.toString(validatedSigner3, string + "  ", string2);
            }
        }
        return string3;
    }

    public static String toString(ValidatedCertificate validatedCertificate) {
        return ValidatedDocumentUtils.toString(validatedCertificate, "");
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(ValidatedCertificate validatedCertificate, String string) {
        void var2_4;
        Object object;
        if (validatedCertificate == null) {
            return "";
        }
        String iterator2 = " [no cdb data]";
        try {
            object = validatedCertificate.getCert().getValidatedChain();
            CertDBItem certDBItem = object[0];
            String string2 = certDBItem.getSourceAsString() + " " + certDBItem.getStatus() + " " + certDBItem.getTrustAsString() + " " + certDBItem.getTypeAsString() + " " + certDBItem.getEllipsUsages().toString();
        }
        catch (CertDBException certDBException) {
            a.debug(certDBException.getMessage());
        }
        object = "";
        object = (String)object + String.format("%sCertificato - %s - %s\n", string, validatedCertificate.getCertSubject(), var2_4);
        for (ValidatorMessage validatorMessage : validatedCertificate.getMessages()) {
            object = (String)object + String.format("%s %s - %s - %s\n", new Object[]{string, validatorMessage.getLevel(), validatorMessage.getMessageCode(), validatorMessage.getMessage()});
            for (ValidatorMessage validatorMessage2 : validatorMessage.getNotes()) {
                object = (String)object + ValidatedDocumentUtils.toString(validatorMessage2, string + "  ");
            }
        }
        if (validatedCertificate.getIssuer() != null) {
            object = (String)object + ValidatedDocumentUtils.toString(validatedCertificate.getIssuer(), string + "   ");
        }
        return object;
    }

    public static String toString(ValidatorMessage object, String string) {
        if (object == null) {
            return "";
        }
        String string2 = "";
        string2 = string2 + String.format("%s %s - %s - %s\n", new Object[]{string, ((ValidatorMessage)((Object)object)).getLevel(), ((ValidatorMessage)((Object)object)).getMessageCode(), ((ValidatorMessage)((Object)object)).getMessage()});
        for (ValidatorMessage validatorMessage : ((ValidatorMessage)((Object)object)).getNotes()) {
            string2 = string2 + String.format("%s %s - %s - %s\n", new Object[]{string, validatorMessage.getLevel(), validatorMessage.getMessageCode(), validatorMessage.getMessage()});
            for (ValidatorMessage validatorMessage2 : validatorMessage.getNotes()) {
                string2 = string2 + ValidatedDocumentUtils.toString(validatorMessage2, string + "  ");
            }
        }
        return string2;
    }

    public static boolean globalStatusCheck(ValidatedDocument validatedDocument) {
        return validatedDocument.isSigned() && validatedDocument.isOverAllOk(true);
    }

    public static final HashMap<String, ValidatedSigner> getAllSigners(ValidatedDocument validatedDocument) throws CertificateEncodingException {
        Object object;
        HashMap<String, ValidatedSigner> hashMap = new HashMap<String, ValidatedSigner>();
        for (ValidatedSigner validatedSigner : validatedDocument.getReferenceSigners()) {
            Object object2 = object = validatedSigner.getSignatureInformation().getSignatureInfo() != null ? new String(validatedSigner.getSignatureInformation().getSignatureInfo()) : "NESSUNA INFO PRESENTE";
            if (!hashMap.containsKey(object)) {
                hashMap.put((String)object, validatedSigner);
            }
            for (ValidatedSigner validatedSigner2 : validatedSigner.getTimeStamps()) {
                object = validatedSigner2.getSignatureInformation().getSignatureInfo() != null ? new String(validatedSigner2.getSignatureInformation().getSignatureInfo()) : "NESSUNA INFO PRESENTE";
                if (hashMap.containsKey(object)) continue;
                hashMap.put((String)object, validatedSigner2);
            }
            for (ValidatedSigner validatedSigner3 : validatedSigner.getCounterSigners()) {
                object = ValidatedDocumentUtils.a(validatedSigner3);
                for (String string : ((HashMap)object).keySet()) {
                    if (hashMap.containsKey(string)) continue;
                    hashMap.put(string, (ValidatedSigner)((HashMap)object).get(string));
                }
            }
        }
        for (ValidatedDocument validatedDocument2 : validatedDocument.getSubResults()) {
            object = ValidatedDocumentUtils.getAllSigners(validatedDocument2);
            for (String string : ((HashMap)object).keySet()) {
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, (ValidatedSigner)((HashMap)object).get(string));
            }
        }
        return hashMap;
    }

    private static final HashMap<String, ValidatedSigner> a(ValidatedSigner object) throws CertificateEncodingException {
        HashMap<String, ValidatedSigner> hashMap = new HashMap<String, ValidatedSigner>();
        String hashMap22 = ((ValidatedSigner)((Object)object)).getSignatureInformation().getSignatureInfo() != null ? new String(((ValidatedSigner)((Object)object)).getSignatureInformation().getSignatureInfo()) : "NESSUNA INFO PRESENTE";
        hashMap.put(hashMap22, (ValidatedSigner)((Object)object));
        for (ValidatedSigner validatedSigner : ((ValidatedSigner)((Object)object)).getCounterSigners()) {
            HashMap<String, ValidatedSigner> hashMap2 = ValidatedDocumentUtils.a(validatedSigner);
            for (String string : hashMap2.keySet()) {
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, hashMap2.get(string));
            }
        }
        return hashMap;
    }
}

