/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationStep;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

public abstract class MultipleValidationStepImpl
extends ValidationStep
implements MultipleValidationStep {
    public MultipleValidationStepImpl(ValidationType validationType) {
        super(validationType);
    }

    @Override
    public List<ValidatorMessage> checks(ValidationContextParameters validationContextParameters) {
        List<Object> list = new LinkedList<ValidatorMessage>();
        try {
            LinkedList<ValidatorMessage> linkedList = this.checkSubSteps(validationContextParameters);
            list = this.checks(linkedList, validationContextParameters);
            if (list != null && list.size() > 0) {
                list.addAll(linkedList);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("MultipleValidationStepImpl \"{}\" ha generato i seguenti messaggi", (Object)this.getClass().getName());
                    for (ValidatorMessage validatorMessage : list) {
                        this.logger.debug("Messaggio codice {} livello {}:", (Object)validatorMessage.getMessageCode(), (Object)validatorMessage.getLevel());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ValidationStep \"{}\" ha generato un errore non gestito: ", (Object)this.getClass().getName(), (Object)throwable);
            }
            list.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return list;
    }

    protected abstract List<ValidatorMessage> checks(List<ValidatorMessage> var1, ValidationContextParameters var2);
}

