/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.arubasign.gui;

import com.sun.jna.Platform;
import esecurity.crypto.gui.cmdline.CmdLine;
import esecurity.crypto.gui.decrypt.DecryptFormController;
import esecurity.crypto.gui.decrypt.model.FilesToDecryptHandler;
import esecurity.crypto.gui.encrypt.EncryptFormController;
import esecurity.crypto.gui.encrypt.model.FilesToEncryptHandler;
import esecurity.crypto.gui.form.settings.SettingsController;
import esecurity.crypto.gui.infopanel.InfoPanelController;
import esecurity.crypto.gui.model.DocumentsToValidate;
import esecurity.crypto.gui.model.FileToEncrypt;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.properties.AppProperties;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.crypto.gui.signature.SignatureFormController;
import esecurity.crypto.gui.signature.models.FilesToSignHandler;
import esecurity.crypto.gui.timestamp.TimestampFormController;
import esecurity.crypto.gui.timestamp.models.FilesToMarkHandler;
import esecurity.crypto.gui.updater.AlertViewer;
import esecurity.crypto.gui.updater.ProgressIndicator;
import esecurity.crypto.gui.updater.Updater;
import esecurity.crypto.gui.utils.CGController;
import esecurity.crypto.gui.utils.GUIUtils;
import esecurity.crypto.gui.utils.Property;
import esecurity.crypto.gui.utils.files.FileSystemUtils;
import esecurity.crypto.gui.utils.guielements.CGAlert;
import esecurity.crypto.gui.utils.guielements.CGMenuBar;
import esecurity.crypto.gui.utils.rootupdater.CertDBUpdater;
import esecurity.crypto.gui.utils.swt.ImageHandler;
import esecurity.crypto.gui.validation.ValidationFormController;
import esecurity.desktop.BaseController;
import esecurity.desktop.Event;
import esecurity.desktop.Listener;
import esecurity.desktop.View;
import esecurity.desktop.annotation.JSFunction;
import esecurity.desktop.dom.Button;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.DivContainer;
import esecurity.desktop.dom.Image;
import esecurity.desktop.dom.Paragraph;
import esecurity.desktop.dom.TimedMessage;
import esecurity.desktop.observable.ObservableListener;
import esecurity.desktop.observable.ObservableObject;
import esecurity.desktop.swt.OsCheck;
import esecurity.desktop.task.Task;
import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.core.CapiException;
import it.arubapec.arubasign.ArubaSignApp;
import it.arubapec.arubasign.addsignature.SignatureAdditionAS;
import it.arubapec.arubasign.gui.DropdownEntry;
import it.arubapec.arubasign.gui.DropdownList;
import it.arubapec.arubasign.gui.Version;
import it.arubapec.arubasign.tabview.Tab;
import it.arubapec.arubasign.tabview.TabSection;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArubaSignController
extends BaseController
implements AlertViewer {
    private static final Logger logger = LoggerFactory.getLogger(ArubaSignController.class);
    private static final I18N i18n = I18N.getInstance((String)"it/arubapec/arubasign/gui/resource/lang/ArubaSign");
    private final Semaphore guiLockSemaphore = new Semaphore(1);
    private static int alertId = 0;
    private DivContainer page;
    boolean isSaved = false;
    private DivContainer pageContent;
    private DivContainer tabsDiv;
    private DivContainer logoDiv;
    private DivContainer buttonsDiv;
    private Button cifraButton;
    private Button decifraButton;
    private Button marcaButton;
    private Button showOnboardingBtn;
    private Button onLineGuide;
    private Button infoButton;
    private DivContainer updaterMessageContainer;
    private DivContainer updaterProgressContainer;
    private Paragraph updateMessage;
    private DivContainer invisibleDiv;
    private DivContainer invisibleDiv2;
    private Image arubapecLogo;
    private TabSection tabSection;
    private DivContainer stepContainer;
    boolean dontShowAgain = false;
    private TimedMessage message;
    private DivContainer downloadProgressContainer;
    private DivContainer progressBar;
    private Paragraph downloadPercentage;
    private DropdownEntry functionalityEntry;
    private DropdownEntry supportEntry;
    private final List<DropdownEntry> dropdownToHide = new ArrayList<DropdownEntry>();
    private DivContainer contactUs;
    private DivContainer starOnboardingDummy;
    private DivContainer starOnboardingBody;
    private final CmdLine cmdLine;
    private List<String> marcaJSCallbacks;
    private List<String> firmaJSCallbacks;
    private final ObservableObject<Double> currentDownloadMax = new ObservableObject((Object)1.0);
    private final ObservableObject<Double> totalDownloadMax = new ObservableObject((Object)1.0);
    private final ObservableObject<Double> currentDownloadValue = new ObservableObject((Object)0.0);
    private final ObservableObject<Double> totalDownloadValue = new ObservableObject((Object)0.0);
    private final DownloadListener updateListener = new DownloadListener();

    public ArubaSignController(List<String> javascript, CmdLine cmdLine) {
        super("/it/arubapec/arubasign/gui/form/mainPage.html", javascript, null);
        this.cmdLine = cmdLine;
    }

    protected void documentOnLoad() {
        this.view.startBuffering();
        this.page = new DivContainer("arubaSign_mainPage", this.getBodyId(false), this.view);
        this.page.addClass("arubaSign_mainPage");
        this.pageContent = new DivContainer("arubaSign_pageContent", (DOMElement)this.page, this.view);
        this.pageContent.addClass("arubaSign_pageContent");
        this.stepContainer = new DivContainer("as_stepContainer", (DOMElement)this.pageContent, this.view);
        this.stepContainer.addClass("main_stepContainer");
        this.stepContainer.setVisible(false);
        this.logoDiv = new DivContainer("arubasign_logoDiv", (DOMElement)this.pageContent, this.view);
        this.logoDiv.addClass("arubasign_logoDiv");
        this.buttonsDiv = new DivContainer("buttonsDiv", (DOMElement)this.logoDiv, this.view);
        this.buttonsDiv.addClass("as_buttonsDiv");
        this.invisibleDiv = new DivContainer("arubasign_invisibleDiv", (DOMElement)this.logoDiv, this.view);
        this.invisibleDiv2 = new DivContainer("arubasign_invisibleDiv2", (DOMElement)this.logoDiv, this.view);
        this.arubapecLogo = new Image("arubasign_arubapecLogo", (DOMElement)this.logoDiv, this.view);
        this.arubapecLogo.setSource(ImageHandler.retrieveBase64Image((String)"arubapec_logo.svg"));
        this.arubapecLogo.addClass("arubasign_arubapecLogo");
        this.cifraButton = new Button("cifraButton", (DOMElement)this.buttonsDiv, this.view, () -> i18n.get("menu_bar_encrypt", new Object[0]));
        this.cifraButton.addClass("cg-menuBarMenuEntry");
        this.decifraButton = new Button("decifraButton", (DOMElement)this.buttonsDiv, this.view, () -> i18n.get("menu_bar_decrypt", new Object[0]));
        this.decifraButton.addClass("cg-menuBarMenuEntry");
        this.marcaButton = new Button("marcaButton", (DOMElement)this.buttonsDiv, this.view, () -> i18n.get("menu_bar_mark", new Object[0]));
        this.marcaButton.addClass("cg-menuBarMenuEntry");
        this.marcaJSCallbacks = new ArrayList<String>();
        this.marcaJSCallbacks.add("timestamp_loadResizable();");
        this.marcaJSCallbacks.add("timestamp_resize();");
        LinkedHashMap<Button, Runnable> funcionalityList = new LinkedHashMap<Button, Runnable>();
        funcionalityList.put(this.cifraButton, () -> {
            Tab cifraTab = this.tabSection.getTabByName("Cifra");
            if (cifraTab == null) {
                cifraTab = new Tab("Cifra", (CGController)new EncryptFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
                this.tabSection.addTab(cifraTab, i18n.get("menu_bar_encrypt", new Object[0]).toUpperCase(), null);
            } else if (this.tabSection.getTabByName("Cifra").isVisible()) {
                if (cifraTab.isActive()) {
                    this.tabSection.getTabSectionList().get(0).setActive(true, this.dropdownToHide);
                }
                cifraTab.setVisible(false);
                FilesToEncryptHandler.getInstance().clear();
            } else {
                cifraTab.setVisible(true);
                FilesToEncryptHandler.getInstance().clear();
            }
        });
        funcionalityList.put(this.decifraButton, () -> {
            Tab decifraTab = this.tabSection.getTabByName("Decifra");
            if (decifraTab == null) {
                decifraTab = new Tab("Decifra", (CGController)new DecryptFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
                this.tabSection.addTab(decifraTab, i18n.get("menu_bar_decrypt", new Object[0]).toUpperCase(), null);
            } else if (this.tabSection.getTabByName("Decifra").isVisible()) {
                if (decifraTab.isActive()) {
                    this.tabSection.getTabSectionList().get(0).setActive(true, this.dropdownToHide);
                }
                decifraTab.setVisible(false);
                FilesToDecryptHandler.getInstance().clear();
            } else {
                decifraTab.setVisible(true);
                FilesToDecryptHandler.getInstance().clear();
            }
        });
        funcionalityList.put(this.marcaButton, () -> {
            Tab marcaTab = this.tabSection.getTabByName("Marca_temporale");
            if (marcaTab == null) {
                marcaTab = new Tab("Marca_temporale", (CGController)new TimestampFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
                this.tabSection.addTab(marcaTab, i18n.get("menu_bar_mark", new Object[0]).toUpperCase(), this.marcaJSCallbacks);
            } else if (this.tabSection.getTabByName("Marca_temporale").isVisible()) {
                if (marcaTab.isActive()) {
                    this.tabSection.getTabSectionList().get(0).setActive(true, this.dropdownToHide);
                }
                marcaTab.setVisible(false);
                FilesToMarkHandler.getInstance().clear();
            } else {
                marcaTab.setVisible(true);
            }
        });
        DropdownList functionalityDropdownList = new DropdownList(this.buttonsDiv);
        this.functionalityEntry = new DropdownEntry(functionalityDropdownList, i18n.get("menu_bar_functionality", new Object[0]), funcionalityList, this.getBodyId(false), this.view, "success.svg");
        functionalityDropdownList.addEntry(this.functionalityEntry, 126);
        DropdownEntry settingsButton = new DropdownEntry(i18n.get("menu_bar_settings", new Object[0]), functionalityDropdownList, this.view);
        functionalityDropdownList.addEntry(settingsButton, 126);
        this.showOnboardingBtn = new Button("showOnboardingBtn", (DOMElement)this.buttonsDiv, this.view, () -> i18n.get("menu_bar_showOnboarding", new Object[0]));
        this.showOnboardingBtn.addClass("cg-menuBarMenuEntry");
        this.onLineGuide = new Button("onLineGuideButton", (DOMElement)this.buttonsDiv, this.view, () -> i18n.get("menu_bar_onLineGuide", new Object[0]));
        this.onLineGuide.addClass("cg-menuBarMenuEntry");
        this.infoButton = new Button("infoButton", (DOMElement)this.buttonsDiv, this.view, () -> i18n.get("menu_bar_info", new Object[0]));
        this.infoButton.addClass("cg-menuBarMenuEntry");
        LinkedHashMap<Button, Runnable> supportList = new LinkedHashMap<Button, Runnable>();
        supportList.put(this.showOnboardingBtn, () -> {
            this.view.execute("removeOnIntroJsComplete();");
            this.showOnBoarding();
        });
        supportList.put(this.onLineGuide, () -> {
            if (!GUIUtils.openUrl((String)"https://guide.pec.it/soluzioni-firma-digitale/firma-remota/gestione-e-utilizzo-firma-remota.aspx")) {
                logger.error("impossibile aprire la guida https://guide.pec.it/soluzioni-firma-digitale/firma-remota/gestione-e-utilizzo-firma-remota.aspx");
            }
        });
        supportList.put(this.infoButton, () -> this.openInfo());
        this.supportEntry = new DropdownEntry(functionalityDropdownList, i18n.get("menu_bar_support", new Object[0]), supportList, this.getBodyId(false), this.view);
        functionalityDropdownList.addEntry(this.supportEntry, 126);
        this.contactUs = new DivContainer("menu_bar_contact_us", (DOMElement)this.logoDiv, this.view);
        this.contactUs.setInnerHTML(i18n.get("contactus.text", new Object[0]));
        this.contactUs.addClass("menu_bar_contact_us");
        this.contactUs.onClick(t -> GUIUtils.openUrl((String)this.composeUsabillaUrl()));
        this.dropdownToHide.add(this.functionalityEntry);
        this.dropdownToHide.add(this.supportEntry);
        this.updaterMessageContainer = new DivContainer("menu_bar_updaterMessage_container", (DOMElement)this.logoDiv, this.view);
        this.updaterMessageContainer.addClass("menu_bar_updaterMessage_container_beta");
        this.updaterMessageContainer.setVisible(false);
        DivContainer updaterMessageDummy = new DivContainer("menu_bar_updaterMessageDummy", (DOMElement)this.updaterMessageContainer, this.view);
        Image updateIcon = new Image("menu_bar_updaterMessage_updateIcon", (DOMElement)this.updaterMessageContainer, this.view);
        updateIcon.addClass("menu_bar_updaterMessage_updateIcon");
        this.updateMessage = new Paragraph("menu_bar_updaterMessage_updateMessage", (DOMElement)this.updaterMessageContainer, this.view);
        this.updateMessage.addClass("menu_bar_updaterMessage_updateMessage");
        this.updaterProgressContainer = new DivContainer("menu_bar_updaterProgress_container", (DOMElement)this.logoDiv, this.view);
        this.updaterProgressContainer.addClass("menu_bar_updaterMessage_container_beta");
        this.updaterProgressContainer.setVisible(false);
        this.tabsDiv = new DivContainer("tabs_container", (DOMElement)this.pageContent, this.view);
        this.tabsDiv.addClass("tabs_container");
        this.tabSection = new TabSection("tabSection", (DOMElement)this.tabsDiv, this.view, this.dropdownToHide);
        this.view.stopBuffering();
        settingsButton.getMenuEntry().onClick(evt -> this.openSettings());
        SignatureFormController sigController = new SignatureFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0));
        this.firmaJSCallbacks = new ArrayList<String>();
        this.firmaJSCallbacks.add("sign_loadResizable();");
        this.firmaJSCallbacks.add("sign_resize();");
        this.tabSection.addTab(new Tab("Firma", (CGController)sigController), i18n.get("menu_bar_sign", new Object[0]).toUpperCase(), this.firmaJSCallbacks);
        this.tabSection.show("Firma");
        ValidationFormController validationFormController = new ValidationFormController(this, this.pageContent.getId(), new ArrayList<String>(0), new SignatureAdditionAS(this.tabSection, sigController));
        validationFormController.setPdfReportLogoResource("/it/arubapec/arubasign/gui/resource/PDFReportLogo.pdf", "ArubaSign");
        this.tabSection.addTab(new Tab("Verifica", validationFormController), i18n.get("menu_bar_verify", new Object[0]).toUpperCase(), null);
        ClientProperties props = ClientProperties.getInstance();
        if (props.get((Property)UserProperties.SHOW_MARCA, "false").isEmpty() || props.get((Property)UserProperties.SHOW_MARCA, "false").equals("true")) {
            Tab timestampTab = new Tab("Marca_temporale", (CGController)new TimestampFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
            this.tabSection.addTab(timestampTab, i18n.get("menu_bar_mark", new Object[0]).toUpperCase(), this.marcaJSCallbacks);
            this.functionalityEntry.getIconsMap().get("marcaButton_image").setVisible(true);
        }
        if (props.get((Property)UserProperties.SHOW_CIFRA, "false").isEmpty() || props.get((Property)UserProperties.SHOW_CIFRA, "false").equals("true")) {
            Tab encryptTab = new Tab("Cifra", (CGController)new EncryptFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
            this.tabSection.addTab(encryptTab, i18n.get("menu_bar_encrypt", new Object[0]).toUpperCase(), null);
            this.functionalityEntry.getIconsMap().get("cifraButton_image").setVisible(true);
        }
        if (props.get((Property)UserProperties.SHOW_DECIFRA, "false").isEmpty() || props.get((Property)UserProperties.SHOW_DECIFRA, "false").equals("true")) {
            Tab decryptTab = new Tab("Decifra", (CGController)new DecryptFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
            this.tabSection.addTab(decryptTab, i18n.get("menu_bar_decrypt", new Object[0]).toUpperCase(), null);
            this.functionalityEntry.getIconsMap().get("decifraButton_image").setVisible(true);
        }
        this.setOnDragEnter(() -> {
            if ("Firma".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Firma").getController().onDragEnter();
            } else if ("Verifica".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Verifica").getController().onDragEnter();
            } else if ("Marca_temporale".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Marca_temporale").getController().onDragEnter();
            } else if ("Cifra".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Cifra").getController().onDragEnter();
            } else if ("Decifra".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Decifra").getController().onDragEnter();
            }
        });
        this.setOnDragLeave(() -> {
            if ("Firma".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Firma").getController().onDragLeave();
            } else if ("Verifica".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Verifica").getController().onDragLeave();
            } else if ("Marca_temporale".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Marca_temporale").getController().onDragLeave();
            } else if ("Cifra".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Cifra").getController().onDragLeave();
            } else if ("Decifra".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Decifra").getController().onDragLeave();
            }
        });
        this.setDropListener(evt -> {
            if ("Firma".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Firma").getController().onDropEvent(evt);
            } else if ("Verifica".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Verifica").getController().onDropEvent(evt);
            } else if ("Marca_temporale".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Marca_temporale").getController().onDropEvent(evt);
            } else if ("Cifra".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Cifra").getController().onDropEvent(evt);
            } else if ("Decifra".equalsIgnoreCase(this.tabSection.getVisibleTab())) {
                this.tabSection.getTabByName("Decifra").getController().onDropEvent(evt);
            }
        });
        if (Platform.isWindows() && props.get((Property)UserProperties.SHOW_ADMIN_START_WARNING, "false").equals("true") && System.getProperty("currentUserElevated", "false").equalsIgnoreCase("true")) {
            logger.warn("Arubasign started with admin permission");
            Listener checkboxRunnable = evt -> {
                this.dontShowAgain = !this.dontShowAgain;
            };
            Listener onAlertClose = evt -> {
                props.set((Property)UserProperties.SHOW_ADMIN_START_WARNING, this.dontShowAgain ? "false" : "true", ClientProperties.Priority.USER);
                try {
                    props.save();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                this.unlock();
            };
            this.lock();
            CGAlert.builder((View)this.view).setAlertId("adminAlert").setParent((DOMElement)this.stepContainer).setTitle(i18n.get("adminPrivilege.warning", new Object[0])).setBodyText(i18n.get("adminPrivilege.warning.message", new Object[0])).setType(CGAlert.AlertType.INFORMATION).setCheckbox(new CGAlert.CGAlertCheckbox(i18n.get("adminPrivilege.warning.showAgain", new Object[0]), checkboxRunnable)).setSecondaryButton(new CGAlert.CGAlertButton(i18n.get("arubasign__close_uppercase", new Object[0]), true, onAlertClose)).setOnClose(onAlertClose).build();
        }
        this.message = new TimedMessage("as_timedMessage", (DOMElement)this.page, this.view, null);
        this.message.setPosition(this.view.getInnerCurrentWidth() / 2 - 125, this.view.getInnerCurrentHeight() / 2 - 35);
        this.message.setDuration(3000);
        this.setOnDragError(() -> {
            if (!this.message.isDisplayed()) {
                this.view.startBuffering();
                this.message.setPosition(this.view.getInnerCurrentWidth() / 2 - 220, this.view.getInnerCurrentHeight() / 6);
                this.message.setInnerHTML(i18n.get("timedMessage__drag_error", new Object[0]));
                this.message.setClass("timedMessage_drag");
                Image messageImg = new Image("as_messageImg", (DOMElement)this.message, this.view);
                messageImg.setSource(ImageHandler.retrieveBase64Image((String)"error.svg"));
                messageImg.addClass("timedMessage_drag_img");
                this.message.show();
                this.view.redraw();
                this.view.stopBuffering();
            }
        });
        System.out.println("GUI startup time: " + (System.currentTimeMillis() - ArubaSignApp.startTime) + "ms");
        if (CertDBUpdater.needUpdate()) {
            new Task(() -> this.startRootUpdater(), () -> {
                if (!this.setupOnboard()) {
                    this.addFilesToManage(this.cmdLine);
                }
            }).start();
        } else if (!this.setupOnboard()) {
            this.addFilesToManage(this.cmdLine);
        }
    }

    private String composeUsabillaUrl() {
        OsCheck.OSInfo info = OsCheck.getOperatingSistemInfo();
        return "http://survey.usabilla.com/live/s/621c9a5c5f6a706ad810a386" + "?" + "app_ver" + "=" + this.getAppVersion() + "&" + "os" + "=" + this.encodeParameter(info.getPlatformName()) + "&" + "os_ver" + "=" + this.encodeParameter(info.getVersion());
    }

    private String encodeParameter(String param) {
        if (param == null) {
            return "";
        }
        try {
            return URLEncoder.encode(param.trim(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    private String getAppVersion() {
        String version = Version.getVersion();
        if (ClientProperties.getInstance().get((Property)AppProperties.IS_BETA, "false").equals("true")) {
            version = version + "-BETA";
        }
        return version;
    }

    private void startRootUpdater() {
        try {
            this.lock();
            this.tryLock();
            ValidatorConfig validatorConfig = GUIUtils.getValidatorConfig();
            validatorConfig.setProxyAuthenticator(ClientProperties.getInstance().getNetworkConfig().getProxyauthenticator());
            validatorConfig.setNetConfiguration(ClientProperties.getInstance().getNetworkConfig());
            try {
                CertDBUpdater.startBlockingUpdate((ValidatorConfig)validatorConfig, (DOMElement)this.stepContainer, (View)this.view);
            }
            catch (CapiException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                this.reloadCorruptedCdb(validatorConfig);
            }
        }
        finally {
            this.tryRelease();
            this.unlock();
        }
    }

    public void reloadCorruptedCdb(ValidatorConfig validatorConfig) {
        File cdb = new File(ClientProperties.getInstance().get((Property)AppProperties.CDB_FILE, ""));
        if (cdb.exists()) {
            File cdbCorrupted = new File(cdb.getParent() + File.separator + "cert_corrupted.cdb");
            try {
                Files.move(cdb.toPath(), cdbCorrupted.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            File defaultCdb = new File(ClientProperties.getInstance().get((Property)AppProperties.CDB_DEFAULT_FILE, ""));
            if (defaultCdb.exists()) {
                Files.copy(defaultCdb.toPath(), cdb.toPath(), StandardCopyOption.REPLACE_EXISTING);
                CertDBUpdater.startBlockingUpdate((ValidatorConfig)validatorConfig, (DOMElement)this.stepContainer, (View)this.view);
            }
        }
        catch (CapiException | IOException ce) {
            logger.error(ce.getMessage(), ce);
        }
    }

    private boolean setupOnboard() {
        this.initializeOnboarding();
        if ("true".equals(ClientProperties.getInstance().get((Property)AppProperties.SHOW_ONBOARDING, "false"))) {
            this.tryLock();
            this.showOnBoarding();
            ClientProperties.getInstance().set((Property)AppProperties.SHOW_ONBOARDING, "false", ClientProperties.Priority.FILE);
            try {
                ClientProperties.getInstance().save();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            return true;
        }
        return false;
    }

    private void initializeOnboarding() {
        this.starOnboardingDummy = new DivContainer("starOnboardingDummy", (DOMElement)this.stepContainer, this.view);
        this.starOnboardingDummy.addClass("cg_alert_dummy");
        this.starOnboardingBody = new DivContainer(alertId + "_alert", (DOMElement)this.stepContainer, this.view);
        this.starOnboardingBody.addClass("starOnboardingBody");
        this.starOnboardingBody.addClass("cg_alert");
        this.starOnboardingDummy.setVisible(false);
        this.starOnboardingBody.setVisible(false);
        DivContainer starOnboardingTitle = new DivContainer("starOnboardingTitle", (DOMElement)this.starOnboardingBody, this.view);
        starOnboardingTitle.setInnerHTML(i18n.get("onboarding_title_intro", new Object[0]));
        starOnboardingTitle.addClass("arubasign_starOnboardingTitle");
        Image starOnboardingImg = new Image("starOnboardingImg", (DOMElement)this.starOnboardingBody, this.view);
        starOnboardingImg.addClass("arubasign_starOnboardingImg");
        starOnboardingImg.setSource(ImageHandler.retrieveBase64Image((String)"intro.svg"));
        DivContainer starOnboardingTxt = new DivContainer("starOnboardingTxt", (DOMElement)this.starOnboardingBody, this.view);
        starOnboardingTxt.addClass("arubasign_starOnboardingTxt");
        starOnboardingTxt.setInnerHTML(i18n.get("onboarding_body_intro", new Object[0]));
        Button starOnboardingBtn = new Button("starOnboardingBtn", (DOMElement)this.starOnboardingBody, this.view, () -> i18n.get("onboarding_button_intro", new Object[0]));
        starOnboardingBtn.onClick(t -> {
            this.stepContainer.setStyle("backgroundColor", "rgba(1, 1, 1, 0.4)");
            this.unlock();
            this.starOnboardingDummy.setVisible(false);
            this.starOnboardingBody.setVisible(false);
            this.onboarding();
        });
        starOnboardingBtn.addClass("arubasign_starOnboardingBtn");
        starOnboardingBtn.addClass("cg-button");
        this.tabSection.setAttribute("data-step", "1");
        this.tabSection.setAttribute("data-intro", "<div class=\"arubasign_onboardingTitle\">" + i18n.get("onboarding_title_1", new Object[0]) + " </div><div class=\"arubasign_onboardingBody_step1\"> " + i18n.get("onboarding_body_1", new Object[0]) + " </div>");
        this.buttonsDiv.setAttribute("data-step", "2");
        this.buttonsDiv.setAttribute("data-intro", "<div class=\"arubasign_onboardingTitle_compressed\">" + i18n.get("onboarding_title_2", new Object[0]) + " </div><div class=\"arubasign_onboardingBody_compressed_intro\">" + i18n.get("onboarding_body_2_intro", new Object[0]) + "</div><div class=\"arubasign_onboardingBody_compressed\"> " + i18n.get("onboarding_body_2", new Object[0]) + " </div>");
        this.invisibleDiv2.setAttribute("data-step", "3");
        this.invisibleDiv2.setAttribute("data-intro", "<div class=\"arubasign_onboardingTitle_compressed\">" + i18n.get("onboarding_title_pdf", new Object[0]) + " </div><div class=\"arubasign_onboardingBody\"> " + i18n.get("onboarding_body_pdf", new Object[0]) + " </div><div class= \"arubasign_onboardingBody_imgContainer\"><img src = \"" + ImageHandler.retrieveBase64Image((String)"firma grafica.jpg") + "\" class=\"arubasign_onboarding_image\"/></div>");
        if (Platform.isWindows()) {
            this.invisibleDiv.setAttribute("data-step", "4");
            this.invisibleDiv.setAttribute("data-intro", "<div class=\"arubasign_onboardingTitle_compressed\">" + i18n.get("onboarding_title_windows", new Object[0]) + " </div><div class=\"arubasign_onboardingBody\"> " + i18n.get("onboarding_body_windows", new Object[0]) + " </div><div class= \"arubasign_onboardingBody_imgContainer\"><img src = \"" + ImageHandler.retrieveBase64Image((String)"tasto-destro.jpg") + "\" class=\"arubasign_onboarding_image\"/></div>");
        }
        if (ClientProperties.getInstance().get((Property)AppProperties.IS_BETA, "false").equals("true")) {
            if (Platform.isWindows()) {
                this.contactUs.setAttribute("data-step", "5");
            } else {
                this.contactUs.setAttribute("data-step", "4");
            }
            this.contactUs.setAttribute("data-intro", "<div class=\"arubasign_onboardingTitle\">" + i18n.get("onboarding_title_3", new Object[0]) + " </div><div class=\"arubasign_onboardingBody\"> " + i18n.get("onboarding_body_3", new Object[0]) + " </div>");
        }
    }

    private void showOnBoarding() {
        this.stepContainer.setStyle("backgroundColor", "rgba(1, 1, 1, 0.6)");
        this.lock();
        this.starOnboardingDummy.setVisible(true);
        this.starOnboardingBody.setVisible(true);
    }

    private void onboarding() {
        String nextLabel = i18n.get("next_onboarding", new Object[0]);
        String prevLabel = i18n.get("previous_onboarding", new Object[0]);
        String doneLabel = i18n.get("done_onboarding", new Object[0]);
        this.view.evaluate("introJs().setOptions({\n exitOnOverlayClick: false,nextLabel: \"" + nextLabel + "\",\nprevLabel: \"" + prevLabel + "\",\ndoneLabel: \"" + doneLabel + "\"\n}).start();");
        this.view.execute("setOnIntroJsComplete();");
    }

    private void openSettings() {
        this.lock();
        new Thread(() -> {
            this.isSaved = false;
            Runnable callbackSaved = () -> {
                this.isSaved = true;
            };
            SettingsController controller = new SettingsController(this.stepContainer, this.view, callbackSaved);
            try {
                controller.onClose(() -> {
                    controller.remove();
                    this.unlock();
                    if (this.isSaved) {
                        this.message.setPosition(this.view.getInnerCurrentWidth() / 2 - 180, this.view.getInnerCurrentHeight() / 6);
                        this.message.setInnerHTML(i18n.get("timedMessage.settings", new Object[0]));
                        this.message.removeCustomClass("timedMessage_drag");
                        Image messageImg = new Image("as_messageImg", (DOMElement)this.message, this.view);
                        messageImg.setSource(ImageHandler.retrieveBase64Image((String)"toast-check.svg"));
                        messageImg.addClass("timedMessage_img");
                        this.message.show();
                        this.view.redraw();
                    }
                });
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }, "OpenSettingsPanel").start();
    }

    private void openInfo() {
        this.lock();
        InfoPanelController controller = new InfoPanelController(this.pageContent, Version.getVersion(), Version.getBuild(), this.view);
        try {
            controller.onClose(() -> {
                controller.remove();
                this.unlock();
            });
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setTitle(String title) {
        this.view.setTitle(title);
    }

    public String getTitle() {
        return i18n.get("menu_bar_appname", new Object[0]);
    }

    public void requestDownloadUpdate(Updater.Update update, Listener<Event> onDownload) {
        this.view.startBuffering();
        switch (update) {
            case STANDARD: {
                String title = i18n.get("update_available", new Object[0]);
                String body = i18n.get("update_available_text", new Object[0]);
                this.showUpdateMessage(title, "menu_bar_updaterMessage_container_download_standard", (Listener<Event>)((Listener)t -> {
                    this.lock();
                    Listener onClose = e -> this.unlock();
                    Listener onAlertDownload = x -> {
                        this.unlock();
                        this.showUpdateDownloadProgress();
                        onDownload.notify(x);
                    };
                    CGAlert.builder((View)this.view).setAlertId("arubaSign_standardUpdateDownloadAlert").setParent((DOMElement)this.stepContainer).setTitle(title).setBodyText(body).setType(CGAlert.AlertType.INFORMATION).setPrimaryButton(new CGAlert.CGAlertButton(i18n.get("arubasign__download_uppercase", new Object[0]), true, onAlertDownload)).setSecondaryButton(new CGAlert.CGAlertButton(i18n.get("arubasign__close_uppercase", new Object[0]), false, onClose)).setOnClose(onClose).build();
                }));
                break;
            }
            case CRITICAL: {
                this.showUpdateMessage(i18n.get("update_available_critical", new Object[0]), "menu_bar_updaterMessage_container_critical", (Listener<Event>)((Listener)t -> {
                    Listener onClose = e -> this.unlock();
                    Listener onAlertDownload = x -> {
                        this.unlock();
                        this.showUpdateDownloadProgress();
                        onDownload.notify(x);
                    };
                    this.lock();
                    CGAlert.builder((View)this.view).setAlertId("arubaSign_criticalUpdateDownloadAlert").setParent((DOMElement)this.stepContainer).setTitle(i18n.get("update_available_critical", new Object[0])).setBodyText(i18n.get("update_available_text", new Object[0])).setType(CGAlert.AlertType.WARNING).setPrimaryButton(new CGAlert.CGAlertButton(i18n.get("arubasign__download_uppercase", new Object[0]), true, onAlertDownload)).setSecondaryButton(new CGAlert.CGAlertButton(i18n.get("arubasign__close_uppercase", new Object[0]), false, onClose)).setOnClose(onClose).build();
                }));
                break;
            }
            case FORCED: {
                this.showForcedUpdateMessage(i18n.get("update_available_forced", new Object[0]), onDownload);
            }
        }
        this.view.stopBuffering();
    }

    public void showLinkToArubaPec(String url) {
        this.updateMessage.setInnerHTML(i18n.get("update_available_stable", new Object[0]));
        this.updaterMessageContainer.onClick(obj -> GUIUtils.openUrl((String)url));
        this.contactUs.setVisible(false);
        this.updaterProgressContainer.setVisible(false);
        this.updaterMessageContainer.setVisible(true);
    }

    private void showUpdateDownloadProgress() {
        this.updaterMessageContainer.setVisible(false);
        this.updaterProgressContainer.setVisible(true);
        this.updaterProgressContainer.removeClass("menu_bar_updaterMessage_container_critical");
        this.updaterProgressContainer.removeClass("menu_bar_updaterMessage_container_standard");
        this.updaterProgressContainer.addClass("menu_bar_updaterMessage_container_downloading");
        DivContainer downloadProgressMessageContainer = new DivContainer("menu_bar_updaterMessage_downloadProgressMessageContainer", (DOMElement)this.updaterProgressContainer, this.view);
        Paragraph downloadProgressMessage = new Paragraph("menu_bar_updaterMessage_downloadProgressMessage", (DOMElement)downloadProgressMessageContainer, this.view);
        downloadProgressMessage.setInnerHTML("Scaricamento aggiornamento in corso ");
        this.downloadPercentage = new Paragraph("menu_bar_updaterMessage_downloadProgressPercentage", (DOMElement)downloadProgressMessageContainer, this.view);
        downloadProgressMessage.addClass("menu_bar_updaterMessage_downloadProgressMessage");
        this.downloadPercentage.addClass("menu_bar_updaterMessage_downloadProgressMessage");
        DivContainer progressBarContainer = new DivContainer("menu_bar_updaterMessage_progressBarContainer", (DOMElement)this.updaterProgressContainer, this.view);
        progressBarContainer.addClass("menu_bar_updaterMessage_progressBarContainer");
        this.progressBar = new DivContainer("menu_bar_updaterMessage_progressBar", (DOMElement)progressBarContainer, this.view);
        this.progressBar.addClass("menu_bar_updaterMessage_progressBar");
        this.currentDownloadValue.addListener((ObservableListener)this.updateListener);
        this.updateListener.start();
    }

    public void requestApplyUpdate(Updater.Update update, Listener<Event> onApply) {
        switch (update) {
            case STANDARD: {
                this.showUpdateMessage(i18n.get("update_ready", new Object[0]), "menu_bar_updaterMessage_container_apply_standard", (Listener<Event>)((Listener)t -> {
                    Listener onClose = e -> this.unlock();
                    this.lock();
                    CGAlert.builder((View)this.view).setAlertId("arubaSign_standardUpdateApplyAlert").setParent((DOMElement)this.stepContainer).setTitle(i18n.get("update_alert_title_ready", new Object[0])).setBodyText(i18n.get("update_alert_body", new Object[0])).setType(CGAlert.AlertType.INFORMATION).setPrimaryButton(new CGAlert.CGAlertButton(i18n.get("update_alert_confirm", new Object[0]), true, onApply)).setSecondaryButton(new CGAlert.CGAlertButton(i18n.get("update_alert_close", new Object[0]), false, onClose)).setOnClose(onClose).build();
                }));
                break;
            }
            case CRITICAL: {
                this.showUpdateMessage(i18n.get("update_critical_ready", new Object[0]), "menu_bar_updaterMessage_container_critical", (Listener<Event>)((Listener)t -> {
                    Listener onClose = e -> this.unlock();
                    this.lock();
                    CGAlert.builder((View)this.view).setAlertId("arubaSign_criticalUpdateApplyAlert").setParent((DOMElement)this.stepContainer).setTitle(i18n.get("update_alert_title_ready", new Object[0])).setBodyText(i18n.get("update_alert_body", new Object[0])).setType(CGAlert.AlertType.INFORMATION).setPrimaryButton(new CGAlert.CGAlertButton(i18n.get("update_alert_confirm", new Object[0]), true, onApply)).setSecondaryButton(new CGAlert.CGAlertButton(i18n.get("update_alert_close", new Object[0]), false, onClose)).setOnClose(onClose).build();
                }));
                break;
            }
            case FORCED: {
                this.showForcedUpdateMessage(i18n.get("update_alert_forced", new Object[0]), onApply);
            }
        }
    }

    public void showMessage(String title, String message, CGAlert.AlertType type) {
        Listener onClose = e -> this.unlock();
        this.lock();
        if (this.downloadProgressContainer != null) {
            this.downloadProgressContainer.setVisible(false);
        }
        this.view.startBuffering();
        CGAlert.builder((View)this.view).setAlertId("arubaSign_alertViewer_alert_" + alertId++).setParent((DOMElement)this.stepContainer).setTitle(title).setBodyText(message).setType(type).setSecondaryButton(new CGAlert.CGAlertButton(i18n.get("arubasign__close_uppercase", new Object[0]), true, onClose)).setOnClose(onClose).build();
        this.view.stopBuffering();
    }

    public void addFilesToManage(CmdLine cmdLine) {
        String tabToSelect = null;
        ArrayList<File> filesToAdd = new ArrayList<File>();
        String[] files = new String[]{};
        if (cmdLine.hasOption("s")) {
            files = cmdLine.getOptionValue("s").split(";");
            tabToSelect = "Firma";
        }
        if (!cmdLine.getNoOptionArgs().isEmpty()) {
            List list = cmdLine.getNoOptionArgs();
            ArrayList<String> fileToSign = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                String noQuoteParam = ((String)list.get(i)).replace("\"", "");
                File file = new File(noQuoteParam);
                if (file.exists()) {
                    fileToSign.add(file.getAbsolutePath());
                    continue;
                }
                boolean found = false;
                for (int j = i + 1; !found && list.size() > j; ++j) {
                    if (!(file = new File(file + " " + ((String)list.get(j)).replace("\"", ""))).exists()) continue;
                    fileToSign.add(file.getAbsolutePath());
                    found = true;
                    i = j;
                }
            }
            if (!fileToSign.isEmpty()) {
                files = fileToSign.toArray(new String[fileToSign.size()]);
                tabToSelect = "Firma";
            }
        }
        if (cmdLine.hasOption("v")) {
            files = cmdLine.getOptionValue("v").split(";");
            tabToSelect = "Verifica";
        }
        if (cmdLine.hasOption("e")) {
            files = cmdLine.getOptionValue("e").split(";");
            tabToSelect = "Cifra";
            Tab tab = this.tabSection.getTabByName("Cifra");
            if (tab == null) {
                this.view.startBuffering();
                Tab tab2 = new Tab("Cifra", (CGController)new EncryptFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
                this.view.stopBuffering();
                this.tabSection.addTab(tab2, "CIFRA", null);
            }
        }
        if (cmdLine.hasOption("d")) {
            files = cmdLine.getOptionValue("d").split(";");
            tabToSelect = "Decifra";
            Tab tab = this.tabSection.getTabByName("Decifra");
            if (tab == null) {
                this.view.startBuffering();
                Tab tab3 = new Tab("Decifra", (CGController)new DecryptFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
                this.view.stopBuffering();
                this.tabSection.addTab(tab3, "DECIFRA", null);
            }
        }
        if (cmdLine.hasOption("t")) {
            files = cmdLine.getOptionValue("t").split(";");
            tabToSelect = "Marca_temporale";
            Tab tab = this.tabSection.getTabByName("Marca_temporale");
            if (tab == null) {
                this.view.startBuffering();
                Tab tab4 = new Tab("Marca_temporale", (CGController)new TimestampFormController((BaseController)this, this.pageContent.getId(), new ArrayList(0)));
                this.view.stopBuffering();
                this.tabSection.addTab(tab4, "MARCA TEMPORALE", this.marcaJSCallbacks);
            }
        }
        for (String file : files) {
            File thisFile = new File(file);
            if (Files.isSymbolicLink(thisFile.toPath())) continue;
            if (thisFile.isDirectory()) {
                FileSystemUtils.listFilesForFolderSubfolder(filesToAdd, (File)thisFile);
                continue;
            }
            if (!thisFile.isFile()) continue;
            filesToAdd.add(thisFile);
        }
        if (filesToAdd.isEmpty() || tabToSelect == null) {
            return;
        }
        this.tabSection.show(tabToSelect);
        if (tabToSelect.equals("Firma")) {
            ArrayList<FileToSign> arrayList = new ArrayList<FileToSign>();
            for (File file : filesToAdd) {
                arrayList.add(new FileToSign(file));
            }
            FilesToSignHandler.getInstance().addAll(arrayList);
        }
        if (tabToSelect.equals("Verifica")) {
            DocumentsToValidate.getInstance().addAll(filesToAdd);
        }
        if (tabToSelect.equals("Cifra")) {
            ArrayList<FileToEncrypt> arrayList = new ArrayList<FileToEncrypt>();
            for (File file : filesToAdd) {
                arrayList.add(new FileToEncrypt(file));
            }
            FilesToEncryptHandler.getInstance().addAll(arrayList);
        }
        if (tabToSelect.equals("Decifra")) {
            ArrayList<FileToEncrypt> arrayList = new ArrayList<FileToEncrypt>();
            for (File file : filesToAdd) {
                arrayList.add(new FileToEncrypt(file));
            }
            FilesToDecryptHandler.getInstance().addAll(arrayList);
        }
        if (tabToSelect.equals("Marca_temporale")) {
            ArrayList<FileToSign> arrayList = new ArrayList<FileToSign>();
            for (File file : filesToAdd) {
                arrayList.add(new FileToSign(file));
            }
            FilesToMarkHandler.getInstance().addAll(arrayList);
        }
        this.view.minimize(false);
        this.view.forceActive();
        this.view.setActive();
    }

    private void showUpdateMessage(String text, String messageContainerClass, Listener<Event> onClick) {
        this.updaterMessageContainer.removeClass("menu_bar_updaterMessage_container_download_standard");
        this.updaterMessageContainer.removeClass("menu_bar_updaterMessage_container_apply_standard");
        this.updaterMessageContainer.removeClass("menu_bar_updaterMessage_container_critical");
        this.updaterMessageContainer.addClass(messageContainerClass);
        this.updateMessage.setInnerHTML(text);
        this.updaterMessageContainer.onClick(onClick);
        this.contactUs.setVisible(false);
        this.updaterProgressContainer.setVisible(false);
        this.updaterMessageContainer.setVisible(true);
    }

    private void showForcedUpdateMessage(String text, Listener<Event> onClick) {
        Listener onClose = t -> System.exit(0);
        Listener onConfirm = e -> {
            this.showDownloadProgress((DOMElement)this.stepContainer);
            onClick.notify(e);
        };
        this.lock();
        CGAlert.builder((View)this.view).setAlertId("arubaSign_forcedUpdateAlert").setParent((DOMElement)this.stepContainer).setTitle(i18n.get("update_alert_forced_title", new Object[0])).setBodyText(text).setType(CGAlert.AlertType.WARNING).setPrimaryButton(new CGAlert.CGAlertButton(i18n.get("update_alert_forced_confirm", new Object[0]), true, onConfirm)).setSecondaryButton(new CGAlert.CGAlertButton(i18n.get("update_alert_close", new Object[0]), false, onClose)).setOnClose(onClose).build();
    }

    private void showDownloadProgress(DOMElement parent) {
        this.view.startBuffering();
        DivContainer downloadProgressContainerDummy = new DivContainer("arubaSign_downloadProgress_container_dummy", parent, this.view);
        downloadProgressContainerDummy.addClass("cg_alert_dummy");
        this.downloadProgressContainer = new DivContainer("arubaSign_downloadProgress_container", parent, this.view);
        this.downloadProgressContainer.addClass("arubaSign_downloadProgress_container");
        this.downloadProgressContainer.addClass("cg_alert");
        CGMenuBar downloadProgressMenuBar = ((CGMenuBar.MinimalMenuBarBuilder)((CGMenuBar.MinimalMenuBarBuilder)((CGMenuBar.MinimalMenuBarBuilder)((CGMenuBar.MinimalMenuBarBuilder)((CGMenuBar.MinimalMenuBarBuilder)((CGMenuBar.MinimalMenuBarBuilder)CGMenuBar.getMinimalMenuBarBuilder().setAppTitle(i18n.get("update_download_progress", new Object[0]))).setIsMaximizable(false)).setIsMinimizable(false)).setParent((DOMElement)this.downloadProgressContainer)).setView(this.view)).setOnExitClick(t -> {})).build();
        Paragraph downloadProgressLabel = new Paragraph("arubaSign_downloadProgress_label", (DOMElement)this.downloadProgressContainer, this.view, () -> i18n.get("update_download_progress_label", new Object[0]));
        downloadProgressLabel.addClass("arubaSign_downloadProgress_label");
        DivContainer progressBarContainer = new DivContainer("arubaSign_progressBar_container", (DOMElement)this.downloadProgressContainer, this.view);
        progressBarContainer.addClass("arubaSign_progressBar_container");
        this.progressBar = new DivContainer("arubaSign_progressBar", (DOMElement)progressBarContainer, this.view);
        this.progressBar.addClass("arubaSign_progressBar");
        this.downloadPercentage = new Paragraph("arubaSign_downloadPercentage", (DOMElement)this.progressBar, this.view);
        this.downloadPercentage.addClass("arubaSign_downloadPercentage");
        this.view.stopBuffering();
        this.currentDownloadValue.addListener((ObservableListener)this.updateListener);
        this.updateListener.start();
    }

    public void stopDownloadListener() {
        if (this.updateListener != null) {
            this.updateListener.stop();
        }
    }

    public CurrentDownloadProgress getCurrentDownloadProgress() {
        return new CurrentDownloadProgress();
    }

    public TotalDownloadProgress getTotalDownloadProgress() {
        return new TotalDownloadProgress();
    }

    private void lock() {
        this.view.setDragAndDropEnabled(false);
        this.stepContainer.setVisible(true);
    }

    private void unlock() {
        this.view.setDragAndDropEnabled(true);
        this.stepContainer.setVisible(false);
    }

    public void tryLock() {
        try {
            this.guiLockSemaphore.acquire();
        }
        catch (InterruptedException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void tryRelease() {
        this.guiLockSemaphore.release();
    }

    @JSFunction
    public void onIntroJsComplete() {
        this.tryRelease();
        this.addFilesToManage(this.cmdLine);
    }

    public class TotalDownloadProgress
    implements ProgressIndicator {
        double max;
        double min;
        double value;

        public void setMaximum(double max) {
            this.max = max;
            ArubaSignController.this.totalDownloadMax.setValue((Object)max);
        }

        public void setMinimum(double min) {
            this.min = min;
        }

        public void setValue(double val) {
            this.value = val;
            ArubaSignController.this.totalDownloadValue.setValue((Object)this.value);
        }

        public double getValue() {
            return this.value;
        }
    }

    public class CurrentDownloadProgress
    implements ProgressIndicator {
        double max;
        double min;
        double value;

        public void setMaximum(double max) {
            this.max = max;
            ArubaSignController.this.currentDownloadMax.setValue((Object)max);
        }

        public void setMinimum(double min) {
            this.min = min;
        }

        public void setValue(double val) {
            this.value = val;
            ArubaSignController.this.currentDownloadValue.setValue((Object)this.value);
        }

        public double getValue() {
            return this.value;
        }
    }

    private class DownloadListener
    extends ObservableListener<Double> {
        private final Object DOWNLOAD_PROGRESS = new Object();
        private double downloadProgress = 0.0;
        private boolean running = true;

        private DownloadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(Double value) {
            Object object = this.DOWNLOAD_PROGRESS;
            synchronized (object) {
                if (value > this.downloadProgress) {
                    this.downloadProgress = value;
                }
            }
        }

        public void stop() {
            this.running = false;
        }

        public void start() {
            this.running = true;
            Thread downloadListenereThread = new Thread(() -> {
                while (this.running) {
                    if (ArubaSignController.this.downloadPercentage != null && ArubaSignController.this.progressBar != null) {
                        double val = 0.0;
                        Object object = this.DOWNLOAD_PROGRESS;
                        synchronized (object) {
                            val = Math.max(0.0, this.downloadProgress);
                        }
                        int perc = (int)(val * 100.0 / ((Double)ArubaSignController.this.totalDownloadMax.getValue() * (Double)ArubaSignController.this.currentDownloadMax.getValue()) + 100.0 * ((Double)ArubaSignController.this.totalDownloadValue.getValue() - 1.0) / (Double)ArubaSignController.this.totalDownloadMax.getValue());
                        if (perc >= 100) {
                            this.stop();
                            perc = 100;
                        }
                        ArubaSignController.this.view.startBuffering();
                        ArubaSignController.this.progressBar.setStyle("width", perc + "%");
                        ArubaSignController.this.downloadPercentage.setInnerHTML(perc + "%");
                        ArubaSignController.this.view.stopBuffering();
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        logger.info(ex.getMessage(), (Throwable)ex);
                    }
                }
            }, "DownloadListener");
            downloadListenereThread.setDaemon(true);
            downloadListenereThread.start();
        }

        protected void run(Double value) {
        }
    }
}

