/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.functionality;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.functionality.DecryptFacade$DecryptFacade;
import esecurity.crypto.gui.functionality.EncryptFacade$ValidationFacade;
import esecurity.crypto.gui.functionality.ValidationFacade$DecryptFacade;
import esecurity.crypto.gui.functionality.jnjtysbc;
import esecurity.crypto.gui.model.FileToSign;
import esecurity.crypto.gui.model.OperationResult;
import esecurity.crypto.gui.model.SignatureRequest;
import esecurity.crypto.gui.model.Status;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.asic.ASiCFormat;
import it.actalis.ellips.capi.asic.MutableASiCOptions;
import it.actalis.ellips.capi.asic.generator.ASiCGenerator;
import it.actalis.ellips.capi.asic.generator.ASiCGeneratorOptions;
import it.actalis.ellips.capi.cms.CadesSignatureGenerator;
import it.actalis.ellips.capi.cms.CadesSignatureOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.pades.PadesSignatureGenerator;
import it.actalis.ellips.capi.pades.PadesSignatureOptions;
import it.actalis.ellips.capi.pdf.CapiPDFApparence;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureMode;
import it.actalis.ellips.capi.signature.SignatureOperation;
import it.actalis.ellips.capi.signature.SignatureOptions;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.ArubaDTSClient;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.xades.XadesSignatureGenerator;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import it.actalis.ellips.capi.xades.exception.XadesModeException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;

public class SignatureFacade {
    private static final EllipsLogger logger = SignatureFacade.UB("-3qma2b", Constants.CAPI_LOGGER_NAME);
    private static final I18N i18n;
    private static Status signatureStatus;

    private static void validate(SignatureRequest request) throws CapiException {
        if (SignatureFacade.UB("30vm33", request) == null) {
            char[] cArray = "\u595d\uc7fb\uc7a4\u9031\u4591\ue22d\udfee\u6c17\u36fb\u8315\ua8b8\ufb04\u8adb\u154e\u6fe4\u5b6d\ueab3\u2aa9\u80a4\u5d11\u1419\uc0b3\uec36\u9eab\u40c5\u275d".toCharArray();
            cArray[4] = (char)(cArray[4] ^ 0x2FB1);
            throw new CapiException(EncryptFacade$ValidationFacade.h(cArray, (short)17413, true, (short)0), 1001);
        }
        if (SignatureFacade.UB("n2vm36", request) == null) {
            char[] cArray = "\uecb7\u12e2\ub2da\u0b21\ud269\u8c33\u3a0c\u0715\uca2c\ue84c\uf596\u8492\ub957\u76dd\u6fc5\uf6c5\uc93e\u0221\u2e6d\u2a45\u1b87".toCharArray();
            cArray[9] = (char)(cArray[9] ^ 0x4B85);
            throw new CapiException(EncryptFacade$ValidationFacade.h(cArray, (short)17299, true, (short)2), 1001);
        }
        if (SignatureFacade.UB("-1aki9sr", request) == null) {
            char[] cArray = "\u778e\ufced\ucef2\u2992\ud62d\u2e63\u455d\ufeeb\uf1cc\u77c2\ufb3f\u9abe\ud4db\u8f88\ue1e9\u37db\u63cdJ".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0xA0F);
            throw new CapiException(EncryptFacade$ValidationFacade.h(cArray, (short)16333, true, (short)3), 1001);
        }
        if (SignatureFacade.UB("lefm38", request) == null) {
            char[] cArray = "\u8b6f\u227c\ub4f4\ub636\ud781\u54eb\u5a27\uc0a9\uda05\ubbe0\ufe62\u1e4c\ue260\u55e2\u769d\udeb3\u9aa9\ud880\ub3f0\udd68\u64dc\uec2f\ucdce\u93f3\u68b4\uf3bd\uaa2c\ueb21\u7368".toCharArray();
            cArray[24] = (char)(cArray[24] ^ 0x7CCF);
            throw new CapiException(EncryptFacade$ValidationFacade.h(cArray, (short)32443, false, (short)3), 1001);
        }
        if (SignatureFacade.UB("1blrm37", request).isEmpty()) {
            char[] cArray = "\u1d34\u2509\u442f\ue51e\u2a5a\u8f8f\u9a91\ud653\u29bc\ud3da\ub4c9\uef1d\ube73\u758e\ubb8e\u19d5\u8cf3\u8948\ua10e\udc23\uf39b\u8339\ud375\u6485".toCharArray();
            cArray[18] = (char)(cArray[18] ^ 0x678E);
            throw new CapiException(EncryptFacade$ValidationFacade.h(cArray, (short)3669, true, (short)1), 1001);
        }
        if (SignatureFacade.UB("8rhm3a", request) == null && SignatureFacade.UB("-p5k9sn", (Object)SignatureType.ASICE, SignatureFacade.UB("30vm33", request)) != false) {
            char[] cArray = "\u0dcd\uc902\uf95f\ubf56\uc42f\u3228\u0d52\u5e95\ufa26\ubb9c\uc677\uf755\uc759\u0715\u68cd\u6479\u723c\ua5e4\u0f63\ue2d7\uaafe\ub4c6\u73f8\u4bbb\u202f\u69fb\uf7a4\u2ad4\uc8d0\ue3b4\u27d6\u4123\u7ec5\u69a7\uff35\u16a7\uf7fe\ufa1f\u1238\u4011\uf6cd\u2544\ud5d7\ucd7f\u725d\u8beb\ua8dd\u4505\u68e0\u5157\u2b59\ub8eb\uf688\u91f8\u5260".toCharArray();
            cArray[13] = (char)(cArray[13] ^ 0x5C63);
            throw new CapiException(EncryptFacade$ValidationFacade.h(cArray, (short)24672, false, (short)5), 1001);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationResult sign(SignatureRequest request) {
        try {
            SignatureFacade.validate(request);
            if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.LT) != false && SignatureFacade.UB("-1l6i9si", request) == null) {
                char[] cArray = "\u2c40\u5150\uc3a9\u814e\ua32d\u10bc\ube05\u5a86\u400d\uf588\uc3e6\u0d7e\uc246\u0345\u1208\u7a27\uca74\uf183\u4c67\u9c2a\ufdd8\uc382\u2b2f\u9d97\ud595\u0ba2\ufd60\ud9ff\u4c6b\ua822\u6838\ufcd8\u175a\uf71b\u7716\u717a\u556f\u30e0\ue47b\ue4c1\ubd78\u7504".toCharArray();
                cArray[7] = (char)(cArray[7] ^ 0x6547);
                OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, ValidationFacade$DecryptFacade.U(cArray, (short)29674, false, (short)1)), SignatureFacade.UB("1blrm37", request), (File)SignatureFacade.UB("-1drg9sj", request));
                return operationResult;
            }
            signatureStatus = null;
            boolean withError = false;
            block4 : switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.UB("-ade9ss", SignatureFacade.UB("30vm33", request))]) {
                case 1: 
                case 2: 
                case 3: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.UB("1blrm37", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.UB("l7lm3i", (Object)StatusLevel.ERROR, SignatureFacade.UB("v59m3f", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 4: {
                    FileToSign file;
                    SignatureOptions signatureOptions = SignatureFacade.getAdesSignatureOptions(request);
                    SignatureGenerator signatureGenerator = SignatureFacade.getAdesSignatureGenerator(request);
                    Iterator iterator = SignatureFacade.UB("1blrm37", request).iterator();
                    while (iterator.hasNext()) {
                        file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signPAdESDocument(file, request, signatureOptions, signatureGenerator);
                        if (signatureStatus == null || SignatureFacade.UB("l7lm3i", (Object)StatusLevel.ERROR, SignatureFacade.UB("v59m3f", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 5: {
                    ASiCGenerator asicGenerator = new ASiCGenerator();
                    MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
                    ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
                    TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
                    Iterator iterator = SignatureFacade.UB("1blrm37", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        withError |= SignatureFacade.signAsicS(file, request, tstOpts, aSiCGeneratorOptions, mutableASiCOptions, asicGenerator);
                        if (signatureStatus == null || SignatureFacade.UB("l7lm3i", (Object)StatusLevel.ERROR, SignatureFacade.UB("v59m3f", signatureStatus)) == false) continue;
                        break block4;
                    }
                    break;
                }
                case 6: {
                    withError |= SignatureFacade.signAsicE(request);
                    break;
                }
                default: {
                    char[] cArray = "\u0851\ub7da\u3e19\u8e1b\u0efd\u00cc\u5651\u0df3\udd2a\u197e\u8762\ude7d\ua85f\ue731\uc835\u9e98\udb1b\u53f8\u644e\u76df\ua68b\ufb6a\u92b1\u48f7\uecb8\u5d13\ub97c\u71c6".toCharArray();
                    cArray[25] = (char)(cArray[25] ^ 0x814);
                    OperationResult operationResult = new OperationResult(new Status(StatusLevel.ERROR, ValidationFacade$DecryptFacade.U(cArray, (short)24955, false, (short)0)), SignatureFacade.UB("1blrm37", request), (File)SignatureFacade.UB("-1drg9sj", request));
                    return operationResult;
                }
            }
            if (withError && signatureStatus == null) {
                boolean allError = true;
                Iterator ftsIt = SignatureFacade.UB("1blrm37", request).iterator();
                while (ftsIt.hasNext() && allError) {
                    allError = SignatureFacade.UB("l7lm3i", (Object)StatusLevel.SUCCESS, SignatureFacade.UB("v59m3f", SignatureFacade.UB("1rbnm3h", (FileToSign)ftsIt.next()))) == false;
                }
                signatureStatus = allError ? new Status(StatusLevel.ERROR, "") : new Status(StatusLevel.WARNING, "");
            } else if (signatureStatus == null) {
                signatureStatus = new Status(StatusLevel.SUCCESS, "");
            }
        }
        catch (Throwable ex) {
            SignatureFacade.UB("-kc0a2f", logger, SignatureFacade.UB("-hiua1n", ex), (Object)ex);
            signatureStatus = new Status(StatusLevel.ERROR, ex);
        }
        finally {
            SignatureFacade.UB("-11kk9sg");
        }
        return new OperationResult(signatureStatus, SignatureFacade.UB("1blrm37", request), (File)SignatureFacade.UB("-1drg9sj", request));
    }

    private static SignatureGenerator getAdesSignatureGenerator(SignatureRequest request) {
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.UB("-ade9ss", SignatureFacade.UB("30vm33", request))]) {
            case 1: 
            case 3: {
                return new CadesSignatureGenerator();
            }
            case 4: {
                return new PadesSignatureGenerator();
            }
            case 2: {
                return new XadesSignatureGenerator();
            }
        }
        return null;
    }

    private static TimeStampOptions getAsicTstOptions(SignatureRequest request) throws IllegalParamException {
        if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.BES) != false) {
            return null;
        }
        TimeStampOptions tstOpts = new TimeStampOptions();
        SignatureFacade.UB("1gmtm3k", tstOpts, true);
        SignatureFacade.UB("-1rcg9sa", tstOpts, new ArubaDTSClient((TSAData)SignatureFacade.UB("-5e69sd", request), (NetworkConfig)SignatureFacade.UB("1pnflu1", SignatureFacade.UB("-1rmua29"))));
        SignatureFacade.UB("1dl3m3l", tstOpts, DigestAlgorithm.SHA256);
        SignatureFacade.UB("-29s8", tstOpts, "");
        return tstOpts;
    }

    private static SignatureOptions getAdesSignatureOptions(SignatureRequest request) throws IllegalParamException {
        CadesSignatureOptions signatureOptions = null;
        switch (1.$SwitchMap$esecurity$crypto$gui$functionality$SignatureFacade$SignatureType[SignatureFacade.UB("-ade9ss", SignatureFacade.UB("30vm33", request))]) {
            case 1: 
            case 3: {
                signatureOptions = new CadesSignatureOptions();
                SignatureFacade.UB("-n2o9s6", signatureOptions, SignatureFacade.UB("8qjm3n", request));
                break;
            }
            case 4: {
                signatureOptions = new PadesSignatureOptions();
                SignatureFacade.UB("gatm3s", (PadesSignatureOptions)signatureOptions, SignatureFacade.UB("-1vru9s7", request));
                break;
            }
            case 2: {
                signatureOptions = new XadesSignatureOptions();
                SignatureFacade.UB("-n2o9s6", signatureOptions, SignatureFacade.UB("8qjm3n", request));
            }
        }
        if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.BES) == false) {
            TimeStampOptions timeStampOptions = new TimeStampOptions();
            SignatureFacade.UB("1gmtm3k", timeStampOptions, true);
            SignatureFacade.UB("-1rcg9sa", timeStampOptions, new ArubaDTSClient((TSAData)SignatureFacade.UB("-5e69sd", request), (NetworkConfig)SignatureFacade.UB("1pnflu1", SignatureFacade.UB("-1rmua29"))));
            SignatureFacade.UB("1dl3m3l", timeStampOptions, DigestAlgorithm.SHA256);
            SignatureFacade.UB("-29s8", timeStampOptions, "");
            SignatureFacade.UB("162rm3r", signatureOptions, timeStampOptions);
            SignatureFacade.UB("1i5fm3u", signatureOptions, SignatureFacade.UB("-oj69sk", request));
            if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.LT) != false) {
                SignatureFacade.UB("-j789s3", signatureOptions, SignatureFacade.UB("-1l6i9si", request));
            }
        }
        SignatureFacade.UB("i85m40", signatureOptions, SignatureFacade.UB("1pnflu1", SignatureFacade.UB("-1rmua29")));
        SignatureFacade.UB("-qdu9s1", signatureOptions, SignatureFacade.UB("n2vm36", request));
        SignatureFacade.UB("-1q5a9ru", signatureOptions, SignatureFacade.UB("-1aki9sr", request));
        SignatureFacade.UB("1hppm41", signatureOptions, SignatureFacade.UB("lefm38", request));
        return signatureOptions;
    }

    private static boolean signPAdESDocument(FileToSign file, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        boolean withAppearance;
        boolean withError = false;
        int appearancesCount = 0;
        int i = 0;
        boolean bl = withAppearance = SignatureFacade.UB("17hnm44", file) != null && !SignatureFacade.UB("17hnm44", file).isEmpty();
        if (withAppearance) {
            appearancesCount = SignatureFacade.UB("17hnm44", file).size();
        }
        File destFile = SignatureFacade.createDestinationFile(file, request);
        FileToSign convert = file;
        if (SignatureFacade.UB("-1qri9rt", file) != false) {
            Object c = SignatureFacade.UB("-tp29rq", file);
            convert = new FileToSign((File)c);
            SignatureFacade.UB("-144k9ro", convert, SignatureFacade.UB("-1dqg9rr", file));
            SignatureFacade.UB("-1skg9rp", convert, SignatureFacade.UB("-1glca25", file));
            SignatureFacade.UB("4d1m4a", convert, SignatureFacade.UB("-9l0a22", file));
        }
        ArrayDeque toDelete = new ArrayDeque();
        Object fileName = SignatureFacade.UB("-4uia1r", convert);
        do {
            File toDel;
            File tmp;
            block41: {
                if (withAppearance) {
                    SignatureFacade.setUpAppearance((PadesSignatureOptions)signatureOptions, (CapiPDFApparence)SignatureFacade.UB("17hnm44", file).get(i));
                }
                tmp = SignatureFacade.UB("1eo7m49", fileName, SignatureFacade.UB("-9l0a22", convert), (FileAttribute[])new FileAttribute[0]).toFile();
                SignatureFacade.UB("1h5hm4c", toDelete, tmp);
                try {
                    Object ih = SignatureFacade.UB("-d4q9r7", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), convert));
                    Throwable throwable = null;
                    try {
                        Object oh = SignatureFacade.UB("-16d29r5", SignatureFacade.UB("-1fre9r4", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), tmp), true));
                        Throwable throwable2 = null;
                        try {
                            SignatureFacade.UB("-8289rl", signatureOptions, ih);
                            SignatureFacade.UB("-1ouc9ri", signatureOptions, oh);
                            char[] cArray = "\u3a8a\u6f6c".toCharArray();
                            cArray[0] = (char)(cArray[0] ^ 0x3955);
                            SignatureFacade.UB("-1skg9rp", convert, SignatureFacade.UB("-1cuga2h", SignatureFacade.UB("-6s9rj", destFile), 0, (int)SignatureFacade.UB("1t8hm4g", SignatureFacade.UB("-6s9rj", destFile), ValidationFacade$DecryptFacade.U(cArray, (short)10090, true, (short)4))));
                            try {
                                if (SignatureFacade.UB("-100g9rh", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.UB("ao7m4i", signatureGenerator, signatureOptions);
                                    if (SignatureFacade.UB("-p5k9sn", SignatureFacade.UB("30vm33", request), (Object)SignatureType.TSD) != false) {
                                        SignatureFacade.UB("-1t5ca2u", SignatureFacade.UB("-12009rf", signatureOptions));
                                        char[] cArray2 = "\uf94e\ub30f\ua595\u4a6b\u352c\u2aa7\u97d7\u6ddd\uef12\u525a\u01c8\u9674\uf876\u9d2f\u4dd3\ua940\u9763\u6f56\u65b5\u2a04\uca45\ue37c\u2fbf".toCharArray();
                                        cArray2[19] = (char)(cArray2[19] ^ 0x677B);
                                        SignatureFacade.UB("1mpnlu7", SignatureFacade.UB("-d4q9r7", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), tmp)), SignatureFacade.UB("-16d29r5", SignatureFacade.UB("-1fre9r4", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), tmp), true)), (Object)SignatureFacade.UB("-5e69sd", request), (Object)SignatureFacade.UB("-4uia1r", file), (Object)ValidationFacade$DecryptFacade.U(cArray2, (short)16175, false, (short)4), (Object)SignatureFacade.UB("oddlu8"), (boolean)false);
                                    }
                                    break block41;
                                }
                                if (SignatureFacade.UB("-100g9rh", request) == SignatureOperation.COUNTER_SIGN) {
                                    SignatureFacade.UB("19rjm4j", signatureOptions, SignatureFacade.UB("e5fm4k", request));
                                }
                                SignatureFacade.UB("-1bhm9ra", signatureGenerator, signatureOptions);
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.UB("-1e9o9rb", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.UB("-n2o9s6", signatureOptions, SignatureFacade.UB("-1e9o9rb", (Object)e));
                                if (SignatureFacade.UB("-100g9rh", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.UB("ao7m4i", signatureGenerator, signatureOptions);
                                    break block41;
                                }
                                SignatureFacade.UB("-1bhm9ra", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (oh != null) {
                                if (throwable2 != null) {
                                    try {
                                        SignatureFacade.UB("-1t5ca2u", oh);
                                    }
                                    catch (Throwable throwable4) {
                                        SignatureFacade.UB("smhlt1", throwable2, throwable4);
                                    }
                                } else {
                                    SignatureFacade.UB("-1t5ca2u", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ih != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.UB("1l3dlt4", ih);
                                }
                                catch (Throwable throwable6) {
                                    SignatureFacade.UB("smhlt1", throwable, throwable6);
                                }
                            } else {
                                SignatureFacade.UB("1l3dlt4", ih);
                            }
                        }
                    }
                }
                catch (Throwable ex) {
                    withError = true;
                    SignatureFacade.UB("-kc0a2f", logger, SignatureFacade.UB("-hiua1n", ex), (Object)ex);
                    if (SignatureFacade.isTokenException(ex)) {
                        signatureStatus = new Status(StatusLevel.ERROR, ex);
                    }
                    SignatureFacade.UB("59hlua", file, new Status(StatusLevel.ERROR, ex));
                }
            }
            if (SignatureFacade.UB("1rbnm3h", file) == null) {
                char[] cArray = "\u1a58\u7fbb\u4989".toCharArray();
                cArray[1] = (char)(cArray[1] ^ 0x1036);
                SignatureFacade.UB("59hlua", file, new Status(StatusLevel.SUCCESS, ValidationFacade$DecryptFacade.U(cArray, (short)8773, false, (short)0)));
            }
            convert = new FileToSign(tmp);
            SignatureFacade.UB("-144k9ro", convert, SignatureFacade.UB("-1dqg9rr", file));
            SignatureFacade.UB("4d1m4a", convert, SignatureFacade.UB("-9l0a22", file));
            ++i;
            if (SignatureFacade.UB("-u7a9r8", toDelete) <= 2 || (toDel = (File)SignatureFacade.UB("1lmhm4n", toDelete)) == null) continue;
            SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", toDel));
        } while (i < appearancesCount && !withError);
        if (!withError) {
            SignatureFacade.UB("fq3lt5", SignatureFacade.UB("1c39m8p", convert), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        Object object = SignatureFacade.UB("125fm8s", toDelete);
        while (object.hasNext()) {
            File del = (File)object.next();
            SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", del));
        }
        return withError;
    }

    private static void setUpAppearance(PadesSignatureOptions signatureOptions, CapiPDFApparence appearance) {
        if (appearance == null) {
            return;
        }
        SignatureFacade.UB("1rubm8r", signatureOptions, appearance);
        SignatureFacade.UB("-1oei9n3", signatureOptions, SignatureFacade.UB("1n0nm8u", appearance));
        SignatureFacade.UB("-h5k9n1", signatureOptions, SignatureFacade.UB("-1n7c9n0", appearance));
        SignatureFacade.UB("14s7m11", signatureOptions, SignatureFacade.UB("-1isa9uu", appearance));
        SignatureFacade.UB("-1big9ut", signatureOptions, (boolean)SignatureFacade.UB("-h7c9us", appearance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean signAdESDocument(FileToSign fileToSign, SignatureRequest request, SignatureOptions signatureOptions, SignatureGenerator signatureGenerator) throws IOException {
        block45: {
            docError = false;
            withError = false;
            destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            outTmpFile = SignatureFacade.UB("1eo7m49", SignatureFacade.UB("-4uia1r", fileToSign), SignatureFacade.UB("-9l0a22", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            tsdIntTmp = null;
            defOut = SignatureFacade.UB("-gfa9uq", request) != false ? (tsdIntTmp = SignatureFacade.UB("1eo7m49", SignatureFacade.UB("-4uia1r", fileToSign), SignatureFacade.UB("-9l0a22", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile()) : outTmpFile;
            try {
                block44: {
                    ih = SignatureFacade.UB("-d4q9r7", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), fileToSign));
                    var11_12 = null;
                    try {
                        oh = SignatureFacade.UB("-16d29r5", SignatureFacade.UB("-1fre9r4", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), defOut), true));
                        var13_16 = null;
                        try {
                            SignatureFacade.UB("-8289rl", signatureOptions, ih);
                            SignatureFacade.UB("-1ouc9ri", signatureOptions, oh);
                            v0 = "\u2e9e\u30b6".toCharArray();
                            v0[0] = (char)(v0[0] ^ 6185);
                            SignatureFacade.UB("-1skg9rp", fileToSign, SignatureFacade.UB("-1cuga2h", SignatureFacade.UB("-6s9rj", destFile), 0, (int)SignatureFacade.UB("1t8hm4g", SignatureFacade.UB("-6s9rj", destFile), EncryptFacade$ValidationFacade.h(v0, (short)6799, false, (short)1))));
                            try {
                                switch (1.$SwitchMap$it$actalis$ellips$capi$signature$SignatureOperation[SignatureFacade.UB("1hmjm32", SignatureFacade.UB("-100g9rh", request))]) {
                                    case 1: {
                                        SignatureFacade.UB("ao7m4i", signatureGenerator, signatureOptions);
                                        if (SignatureFacade.UB("-gfa9uq", request) == false) break;
                                        SignatureFacade.applyTsd(signatureOptions, tsdIntTmp, outTmpFile, (String)SignatureFacade.UB("-4uia1r", fileToSign));
                                        break;
                                    }
                                    case 2: {
                                        SignatureFacade.UB("19rjm4j", signatureOptions, SignatureFacade.UB("e5fm4k", request));
                                    }
                                    case 3: {
                                        SignatureFacade.UB("-1bhm9ra", signatureGenerator, signatureOptions);
                                    }
                                }
                            }
                            catch (XadesModeException e) {
                                if (SignatureFacade.UB("-1e9o9rb", (Object)e) == null) {
                                    throw e;
                                }
                                SignatureFacade.UB("-n2o9s6", signatureOptions, SignatureFacade.UB("-1e9o9rb", (Object)e));
                                if (SignatureFacade.UB("-100g9rh", request) == SignatureOperation.NEW_SIGN) {
                                    SignatureFacade.UB("ao7m4i", signatureGenerator, signatureOptions);
                                    break block44;
                                }
                                SignatureFacade.UB("-1bhm9ra", signatureGenerator, signatureOptions);
                            }
                        }
                        catch (Throwable var14_19) {
                            var13_16 = var14_19;
                            throw var14_19;
                        }
                        finally {
                            if (oh != null) {
                                if (var13_16 != null) {
                                    try {
                                        SignatureFacade.UB("-1t5ca2u", oh);
                                    }
                                    catch (Throwable var14_18) {
                                        SignatureFacade.UB("smhlt1", var13_16, var14_18);
                                    }
                                } else {
                                    SignatureFacade.UB("-1t5ca2u", oh);
                                }
                            }
                        }
                    }
                    catch (Throwable var12_15) {
                        var11_12 = var12_15;
                        throw var12_15;
                    }
                    finally {
                        if (ih != null) {
                            if (var11_12 != null) {
                                try {
                                    SignatureFacade.UB("1l3dlt4", ih);
                                }
                                catch (Throwable var12_14) {
                                    SignatureFacade.UB("smhlt1", var11_12, var12_14);
                                }
                            } else {
                                SignatureFacade.UB("1l3dlt4", ih);
                            }
                        }
                    }
                }
                if (docError) break block45;
            }
            catch (Throwable ex) {
                block46: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.UB("-kc0a2f", SignatureFacade.logger, SignatureFacade.UB("-hiua1n", ex), (Object)ex);
                        if (SignatureFacade.isTokenException(ex)) {
                            SignatureFacade.signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.UB("59hlua", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block46;
                    }
                    catch (Throwable var19_24) {
                        if (!docError) {
                            SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", outTmpFile), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", outTmpFile));
                        if (tsdIntTmp != null) {
                            SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tsdIntTmp));
                        }
                        throw var19_24;
                    }
                    SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", outTmpFile), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", outTmpFile));
                if (tsdIntTmp != null) {
                    SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tsdIntTmp));
                } else {
                    ** GOTO lbl108
                }
            }
            SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", outTmpFile), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", outTmpFile));
        if (tsdIntTmp != null) {
            SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tsdIntTmp));
        }
        if (SignatureFacade.UB("1rbnm3h", fileToSign) == null) {
            v1 = "\u82f5\u66bc\u2635".toCharArray();
            v1[1] = (char)(v1[1] ^ 27359);
            SignatureFacade.UB("59hlua", fileToSign, new Status(StatusLevel.SUCCESS, EncryptFacade$ValidationFacade.h(v1, (short)15166, true, (short)5)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean signAsicS(FileToSign fileToSign, SignatureRequest request, TimeStampOptions tstOpts, ASiCGeneratorOptions aSiCGeneratorOptions, MutableASiCOptions mutableASiCOptions, ASiCGenerator asicGenerator) throws IOException {
        File tmp;
        boolean withError;
        block35: {
            boolean docError = false;
            withError = false;
            File destFile = SignatureFacade.createDestinationFile(fileToSign, request);
            tmp = SignatureFacade.UB("1eo7m49", SignatureFacade.UB("-4uia1r", fileToSign), SignatureFacade.UB("-9l0a22", fileToSign), (FileAttribute[])new FileAttribute[0]).toFile();
            try {
                Object inDoc = SignatureFacade.UB("-d4q9r7", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), fileToSign));
                Throwable throwable = null;
                try {
                    Object outH = SignatureFacade.UB("-16d29r5", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("-1fre9r4", SignatureFacade.UB("1vb5n0n"), true), tmp));
                    Throwable throwable2 = null;
                    try {
                        SignatureOptions entry = new SignatureOptions();
                        SignatureFacade.UB("-8289rl", entry, inDoc);
                        SignatureFacade.UB("-l3m9ur", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.UB("-n2o9s6", entry, SignatureMode.DETACHED);
                        SignatureFacade.UB("-qdu9s1", entry, SignatureFacade.UB("n2vm36", request));
                        SignatureFacade.UB("1hppm41", entry, SignatureFacade.UB("lefm38", request));
                        SignatureFacade.UB("-1q5a9ru", entry, SignatureFacade.UB("-1aki9sr", request));
                        SignatureFacade.UB("i85m40", entry, SignatureFacade.UB("1pnflu1", SignatureFacade.UB("-1rmua29")));
                        if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.BES) == false) {
                            SignatureFacade.UB("162rm3r", entry, tstOpts);
                            SignatureFacade.UB("1i5fm3u", entry, SignatureFacade.UB("-oj69sk", request));
                            if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.LT) != false) {
                                SignatureFacade.UB("-j789s3", entry, SignatureFacade.UB("-1l6i9si", request));
                            }
                        }
                        ArrayList<SignatureOptions> signEntries = new ArrayList<SignatureOptions>();
                        signEntries.add(entry);
                        SignatureFacade.UB("-1dmq9uo", mutableASiCOptions, ASiCFormat.SIMPLE);
                        SignatureFacade.UB("-1n549um", mutableASiCOptions, SignatureFacade.UB("djnm17", request));
                        SignatureFacade.UB("-1uf89un", aSiCGeneratorOptions, mutableASiCOptions);
                        SignatureFacade.UB("-10u49uk", aSiCGeneratorOptions, signEntries);
                        SignatureFacade.UB("9nrm1b", aSiCGeneratorOptions, outH);
                        char[] cArray = "\u4e65\u45ad".toCharArray();
                        cArray[0] = (char)(cArray[0] ^ 0x300E);
                        SignatureFacade.UB("-1skg9rp", fileToSign, SignatureFacade.UB("-1cuga2h", SignatureFacade.UB("-6s9rj", destFile), 0, (int)SignatureFacade.UB("1t8hm4g", SignatureFacade.UB("-6s9rj", destFile), DecryptFacade$DecryptFacade.k(cArray, (short)18976, (short)3, (short)1))));
                        SignatureFacade.UB("blpm1e", asicGenerator, aSiCGeneratorOptions);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (outH != null) {
                            if (throwable2 != null) {
                                try {
                                    SignatureFacade.UB("-1t5ca2u", outH);
                                }
                                catch (Throwable throwable4) {
                                    SignatureFacade.UB("smhlt1", throwable2, throwable4);
                                }
                            } else {
                                SignatureFacade.UB("-1t5ca2u", outH);
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inDoc != null) {
                        if (throwable != null) {
                            try {
                                SignatureFacade.UB("1l3dlt4", inDoc);
                            }
                            catch (Throwable throwable6) {
                                SignatureFacade.UB("smhlt1", throwable, throwable6);
                            }
                        } else {
                            SignatureFacade.UB("1l3dlt4", inDoc);
                        }
                    }
                }
                if (docError) break block35;
            }
            catch (Throwable ex) {
                block36: {
                    try {
                        withError = true;
                        docError = true;
                        SignatureFacade.UB("10rfn0i", logger, SignatureFacade.UB("-hiua1n", ex));
                        if (SignatureFacade.isTokenException(ex)) {
                            signatureStatus = new Status(StatusLevel.ERROR, ex);
                        } else {
                            SignatureFacade.UB("59hlua", fileToSign, new Status(StatusLevel.ERROR, ex));
                        }
                        if (docError) break block36;
                    }
                    catch (Throwable throwable) {
                        if (!docError) {
                            SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", tmp), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                        }
                        SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tmp));
                        throw throwable;
                    }
                    SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", tmp), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tmp));
            }
            SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", tmp), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tmp));
        if (SignatureFacade.UB("1rbnm3h", fileToSign) == null) {
            char[] cArray = "\uf60e\uba65\u4f1b".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x356);
            SignatureFacade.UB("59hlua", fileToSign, new Status(StatusLevel.SUCCESS, DecryptFacade$DecryptFacade.k(cArray, (short)9543, (short)5, (short)3)));
        }
        return withError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean signAsicE(SignatureRequest request) throws IOException, IllegalParamException {
        File tmp;
        File destFile;
        ArrayList<SignatureOptions> signEntries;
        boolean withError;
        boolean docError;
        block24: {
            docError = false;
            withError = false;
            signEntries = new ArrayList<SignatureOptions>();
            destFile = SignatureFacade.createDestinationFile((FileToSign)SignatureFacade.UB("8rhm3a", request), request);
            char[] cArray = "\u44a6\ud0fa\u98d1\u8eac\uba14\ub43d\u53a3".toCharArray();
            cArray[3] = (char)(cArray[3] ^ 0x1335);
            tmp = SignatureFacade.UB("1eo7m49", SignatureFacade.UB("-6s9rj", destFile), ValidationFacade$DecryptFacade.U(cArray, (short)19162, false, (short)0), (FileAttribute[])new FileAttribute[0]).toFile();
            ASiCGenerator asicGenerator = new ASiCGenerator();
            MutableASiCOptions mutableASiCOptions = new MutableASiCOptions();
            ASiCGeneratorOptions aSiCGeneratorOptions = new ASiCGeneratorOptions();
            TimeStampOptions tstOpts = SignatureFacade.getAsicTstOptions(request);
            try {
                Throwable throwable;
                Iterator oh;
                block25: {
                    oh = SignatureFacade.UB("-16d29r5", SignatureFacade.UB("-1fre9r4", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), tmp), true));
                    throwable = null;
                    Iterator iterator = SignatureFacade.UB("1blrm37", request).iterator();
                    while (iterator.hasNext()) {
                        FileToSign file = (FileToSign)iterator.next();
                        SignatureOptions entry = new SignatureOptions();
                        Object inDoc = SignatureFacade.UB("-d4q9r7", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), file));
                        SignatureFacade.UB("-8289rl", entry, inDoc);
                        SignatureFacade.UB("-l3m9ur", entry, DigestAlgorithm.SHA256);
                        SignatureFacade.UB("-n2o9s6", entry, SignatureMode.DETACHED);
                        SignatureFacade.UB("-qdu9s1", entry, SignatureFacade.UB("n2vm36", request));
                        SignatureFacade.UB("1hppm41", entry, SignatureFacade.UB("lefm38", request));
                        SignatureFacade.UB("-1q5a9ru", entry, SignatureFacade.UB("-1aki9sr", request));
                        if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.BES) == false) {
                            SignatureFacade.UB("162rm3r", entry, tstOpts);
                            SignatureFacade.UB("1i5fm3u", entry, SignatureFacade.UB("-oj69sk", request));
                            if (SignatureFacade.UB("-19cu9sl", SignatureFacade.UB("-oj69sk", request), SignatureLevel.LT) != false) {
                                SignatureFacade.UB("-j789s3", entry, SignatureFacade.UB("-1l6i9si", request));
                            }
                        }
                        signEntries.add(entry);
                    }
                    SignatureFacade.UB("-1dmq9uo", mutableASiCOptions, ASiCFormat.EXTENDED);
                    SignatureFacade.UB("-1n549um", mutableASiCOptions, SignatureFacade.UB("djnm17", request));
                    SignatureFacade.UB("-1uf89un", aSiCGeneratorOptions, mutableASiCOptions);
                    SignatureFacade.UB("-10u49uk", aSiCGeneratorOptions, signEntries);
                    SignatureFacade.UB("9nrm1b", aSiCGeneratorOptions, oh);
                    SignatureFacade.UB("blpm1e", asicGenerator, aSiCGeneratorOptions);
                    if (oh == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        SignatureFacade.UB("-1t5ca2u", oh);
                    }
                    catch (Throwable throwable2) {
                        SignatureFacade.UB("smhlt1", throwable, throwable2);
                    }
                    break block24;
                }
                SignatureFacade.UB("-1t5ca2u", oh);
                break block24;
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (oh != null) {
                            if (throwable != null) {
                                try {
                                    SignatureFacade.UB("-1t5ca2u", oh);
                                }
                                catch (Throwable throwable5) {
                                    SignatureFacade.UB("smhlt1", throwable, throwable5);
                                }
                            } else {
                                SignatureFacade.UB("-1t5ca2u", oh);
                            }
                        }
                        throw throwable4;
                    }
                }
            }
            catch (Throwable ex) {
                try {
                    withError = true;
                    docError = true;
                    SignatureFacade.UB("10rfn0i", logger, SignatureFacade.UB("-hiua1n", ex));
                    signatureStatus = new Status(StatusLevel.ERROR, ex);
                }
                catch (Throwable throwable) {
                    for (SignatureOptions entry : signEntries) {
                        if (SignatureFacade.UB("-1hsm9uj", entry) == null) continue;
                        SignatureFacade.UB("1l3dlt4", SignatureFacade.UB("-1hsm9uj", entry));
                    }
                    if (!docError) {
                        SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", tmp), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tmp));
                    throw throwable;
                }
                for (SignatureOptions entry : signEntries) {
                    if (SignatureFacade.UB("-1hsm9uj", entry) == null) continue;
                    SignatureFacade.UB("1l3dlt4", SignatureFacade.UB("-1hsm9uj", entry));
                }
                if (!docError) {
                    SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", tmp), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                }
                SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tmp));
            }
        }
        for (SignatureOptions entry : signEntries) {
            if (SignatureFacade.UB("-1hsm9uj", entry) == null) continue;
            SignatureFacade.UB("1l3dlt4", SignatureFacade.UB("-1hsm9uj", entry));
        }
        if (!docError) {
            SignatureFacade.UB("fq3lt5", SignatureFacade.UB("do5lt6", tmp), SignatureFacade.UB("do5lt6", destFile), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
        }
        SignatureFacade.UB("-76k9n6", SignatureFacade.UB("do5lt6", tmp));
        return withError;
    }

    private static void applyTsd(SignatureOptions signatureOptions, File inputFile, File outputFile, String outFileName) throws Exception {
        TSAData tsaData = new TSAData();
        Object prop = SignatureFacade.UB("-1rmua29");
        SignatureFacade.UB("-5cg9uh", tsaData, SignatureFacade.UB("m85m1g", prop, ServerProperties.TSA_ACCOUNT, (Object)""));
        SignatureFacade.UB("-9fk9ue", tsaData, SignatureFacade.UB("m85m1g", prop, ServerProperties.TSA_SERVER_ADDRESS, (Object)""));
        SignatureFacade.UB("1dv1m1h", tsaData, SignatureFacade.UB("m85m1g", prop, ServerProperties.TSA_POLICY, (Object)""));
        SignatureFacade.UB("kenm1k", tsaData, SignatureFacade.UB("m85m1g", prop, ServerProperties.TSA_PASSWORD, (Object)""));
        Object inputHandlerFile = SignatureFacade.UB("-d4q9r7", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), inputFile));
        Throwable throwable = null;
        try {
            Object outputHandlerFile = SignatureFacade.UB("-16d29r5", SignatureFacade.UB("-1fre9r4", SignatureFacade.UB("-1uui9r6", SignatureFacade.UB("1vb5n0n"), outputFile), true));
            Throwable throwable2 = null;
            try {
                SignatureFacade.UB("-1t5ca2u", SignatureFacade.UB("-12009rf", signatureOptions));
                char[] cArray = "\uad92\ufb63\u877c\u9683\ud457\ucda4\u2db6\u8c3e\u29e7\u227f\u3518\u7eb7\ub3f2\uae92\ub4af\ub6ea\u67b2\ud048\ud375\u069e\u7e8b\u863f\u1a4e".toCharArray();
                cArray[7] = (char)(cArray[7] ^ 0x85F);
                SignatureFacade.UB("1mpnlu7", inputHandlerFile, outputHandlerFile, (Object)tsaData, (Object)outFileName, (Object)ValidationFacade$DecryptFacade.U(cArray, (short)30713, false, (short)3), (Object)SignatureFacade.UB("oddlu8"), (boolean)false);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (outputHandlerFile != null) {
                    if (throwable2 != null) {
                        try {
                            SignatureFacade.UB("-1t5ca2u", outputHandlerFile);
                        }
                        catch (Throwable throwable4) {
                            SignatureFacade.UB("smhlt1", throwable2, throwable4);
                        }
                    } else {
                        SignatureFacade.UB("-1t5ca2u", outputHandlerFile);
                    }
                }
            }
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        finally {
            if (inputHandlerFile != null) {
                if (throwable != null) {
                    try {
                        SignatureFacade.UB("1l3dlt4", inputHandlerFile);
                    }
                    catch (Throwable throwable6) {
                        SignatureFacade.UB("smhlt1", throwable, throwable6);
                    }
                } else {
                    SignatureFacade.UB("1l3dlt4", inputHandlerFile);
                }
            }
        }
    }

    private static File createDestinationFile(FileToSign src, SignatureRequest request) throws IOException {
        Object destinationFolder = SignatureFacade.UB("-1drg9sj", request);
        if (destinationFolder == null) {
            destinationFolder = SignatureFacade.UB("1j27lts", src);
        }
        if (SignatureFacade.UB("-100g9rh", request) == SignatureOperation.NEW_SIGN) {
            return SignatureFacade.UB("-i6c8vb", destinationFolder, SignatureFacade.UB("-1glca25", src), (Object)SignatureFacade.UB("-9l0a22", src));
        }
        if (SignatureFacade.UB("-p5k9sn", (Object)SignatureType.ASICE, SignatureFacade.UB("30vm33", request)) != false) {
            return new File((String)SignatureFacade.UB("1aspm4v", SignatureFacade.UB("-hb29r3", SignatureFacade.UB("-hb29r3", SignatureFacade.UB("-hb29r3", SignatureFacade.UB("-183g9ud", new StringBuilder(), destinationFolder), File.separator), SignatureFacade.UB("-1glca25", src)), SignatureFacade.UB("-9l0a22", src))));
        }
        return new File((String)SignatureFacade.UB("1aspm4v", SignatureFacade.UB("-hb29r3", SignatureFacade.UB("-hb29r3", SignatureFacade.UB("-hb29r3", SignatureFacade.UB("-hb29r3", new StringBuilder(), SignatureFacade.UB("-13ss9ua", src)), File.separator), SignatureFacade.UB("-1glca25", src)), SignatureFacade.UB("-9l0a22", src))));
    }

    private static boolean isTokenException(Throwable ex) {
        if (!(ex instanceof CapiException)) {
            return false;
        }
        CapiException capiException = (CapiException)ex;
        return SignatureFacade.UB("-1j2u9ub", (Object)capiException) == 2014 || SignatureFacade.UB("-1j2u9ub", (Object)capiException) == 2001 || SignatureFacade.UB("-1j2u9ub", (Object)capiException) == 10013;
    }

    static /* synthetic */ I18N access$000() {
        return i18n;
    }

    static {
        char[] cArray = "\ue868\u190b\u534a\u7cb5\u66d1\ud401\u5595\u9143\uc5f5\u05fb\ua778\ud308\u8d29\u6abe\u9411\u5927\u9655\uc581\u99d1\u3fad\u8c19\u3d20\ud05f\ue450\u2ac5\u80c0\ufb78\ud3d9\u334a\ud8f0\uda65\u0f84\u7c7b\u3e8b\ue6eb\u7c5b\u6358".toCharArray();
        cArray[33] = (char)(cArray[33] ^ 0x7471);
        i18n = SignatureFacade.UB("11dtm1o", DecryptFacade$DecryptFacade.k(cArray, (short)18358, (short)0, (short)0));
        signatureStatus = null;
    }

    private static Object UB(Object object, Object object2, Object object3) {
        try {
            return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(jnjtysbc.n(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
        }
        catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
            throw new BootstrapMethodError(reflectiveOperationException);
        }
    }

    public static final class SignatureFormat
    extends Enum<SignatureFormat> {
        public static final /* enum */ SignatureFormat T;
        public static final /* enum */ SignatureFormat LT;
        public static final /* enum */ SignatureFormat TSD;
        private final SignatureLevel signatureLevel;
        private static final /* synthetic */ SignatureFormat[] $VALUES;

        public static SignatureFormat[] values() {
            return (SignatureFormat[])$VALUES.clone();
        }

        public static SignatureFormat valueOf(String name) {
            return (SignatureFormat)((Object)SignatureFormat.So("-2psa28", SignatureFormat.class, name));
        }

        private SignatureFormat(SignatureLevel signatureLevel) {
            this.signatureLevel = signatureLevel;
        }

        public SignatureLevel getSignatureLevel() {
            return this.signatureLevel;
        }

        static {
            char[] cArray = "\u0e23\u52e8".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0x7ECC);
            T = new SignatureFormat(SignatureLevel.T);
            char[] cArray2 = "\u3df2\u3261\u705e".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x28BE);
            LT = new SignatureFormat(SignatureLevel.LT);
            char[] cArray3 = "\u3f0e\uf659\u6930\u1d8c".toCharArray();
            cArray3[2] = (char)(cArray3[2] ^ 0x2F15);
            TSD = new SignatureFormat(SignatureLevel.BES);
            $VALUES = new SignatureFormat[]{T, LT, TSD};
        }

        private static Object So(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(jnjtysbc.n(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }

    public static final class SignatureType
    extends Enum<SignatureType> {
        public static final /* enum */ SignatureType CADES;
        public static final /* enum */ SignatureType PADES;
        public static final /* enum */ SignatureType XADES;
        public static final /* enum */ SignatureType ASICS;
        public static final /* enum */ SignatureType ASICE;
        public static final /* enum */ SignatureType TSD;
        private final String extension;
        private final String name;
        private final String fullName;
        private final String description;
        private static final /* synthetic */ SignatureType[] $VALUES;

        public static SignatureType[] values() {
            return (SignatureType[])$VALUES.clone();
        }

        public static SignatureType valueOf(String name) {
            return (SignatureType)((Object)SignatureType.VB("-2psa28", SignatureType.class, name));
        }

        private SignatureType(String name, String ext, String fullName, String description) {
            this.name = name;
            this.extension = ext;
            this.fullName = fullName;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getFullName() {
            Object temp = SignatureType.VB("lfvm30", SignatureType.VB("4sjm2t"), this.fullName, (Object[])new Object[0]);
            char[] cArray = "\u730e\u52d8\u0a86".toCharArray();
            cArray[1] = (char)(cArray[1] ^ 0x9B8);
            char[] cArray2 = "\u5459\ua024\u2efb".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x578);
            if (SignatureType.VB("3pplte", temp, SignatureType.VB("1aspm4v", SignatureType.VB("-hb29r3", SignatureType.VB("-hb29r3", SignatureType.VB("-hb29r3", new StringBuilder(), DecryptFacade$DecryptFacade.k(cArray, (short)8591, (short)5, (short)1)), this.fullName), DecryptFacade$DecryptFacade.k(cArray2, (short)10702, (short)5, (short)4)))) != false) {
                return this.fullName;
            }
            return temp;
        }

        public String getDescription() {
            Object temp = SignatureType.VB("lfvm30", SignatureType.VB("4sjm2t"), this.description, (Object[])new Object[0]);
            char[] cArray = "\ucf7a\ubaa1\u3de4".toCharArray();
            cArray[0] = (char)(cArray[0] ^ 0xDC1);
            char[] cArray2 = "\uf026\ub20d\u70ba".toCharArray();
            cArray2[1] = (char)(cArray2[1] ^ 0x626);
            if (SignatureType.VB("3pplte", temp, SignatureType.VB("1aspm4v", SignatureType.VB("-hb29r3", SignatureType.VB("-hb29r3", SignatureType.VB("-hb29r3", new StringBuilder(), ValidationFacade$DecryptFacade.U(cArray, (short)27228, false, (short)4)), this.description), ValidationFacade$DecryptFacade.U(cArray2, (short)14263, true, (short)4)))) != false) {
                return this.description;
            }
            return temp;
        }

        static {
            char[] cArray = "\u6b91\uef3e\u258e\u4ca4\u7415\u0c5b".toCharArray();
            cArray[2] = (char)(cArray[2] ^ 0x571A);
            char[] cArray2 = "\u3b3f\u8086\u3f85\uc141\u3acd\u25af".toCharArray();
            cArray2[3] = (char)(cArray2[3] ^ 0x63EA);
            char[] cArray3 = "\u5b74\u6704\u26fe\ub843\u1f5f".toCharArray();
            cArray3[3] = (char)(cArray3[3] ^ 0x697E);
            char[] cArray4 = "\ue5ce\u337f\uf24a\u7fcd\ua54d\u844f\u61ea\ue3b4\u824c\u25a8\ube2c\u76d2\u062e\u9726\u0bdc\u9e37\u195a\u60f0\u4580\uf91b\uffc7\ubf11\u1f69\uac1c\uca97\ud3ff\ud9f1\u1872\uca48\uc9f9\u46a8\ucbda\ued38\u6c9f\u9c25\u9115\u4de9".toCharArray();
            cArray4[34] = (char)(cArray4[34] ^ 0x20CB);
            char[] cArray5 = "\ua0b9\ufc7b\u3ca4\u530c\u14c2\u1655\uf8ea\u928b\u7fca\u4cad\ubd61\ufa20\u96e1\ue6d4\u801d\uc841\u1beb\udc7f\uaa8e\u385d\u789b\u816f\u4f78\u95ff\ud1fa\u9253\u00eb\u9deb\u3104\u42ff\u0436\u124a\u984b\u08ee\u95ec\u0273\uac27\u1028\u1682\u2209".toCharArray();
            cArray5[9] = (char)(cArray5[9] ^ 0x1FEB);
            CADES = new SignatureType(DecryptFacade$DecryptFacade.k(cArray2, (short)12882, (short)3, (short)3), DecryptFacade$DecryptFacade.k(cArray3, (short)2397, (short)2, (short)0), DecryptFacade$DecryptFacade.k(cArray4, (short)19737, (short)1, (short)5), DecryptFacade$DecryptFacade.k(cArray5, (short)24613, (short)4, (short)3));
            char[] cArray6 = "\ue587\u35e0\u9b81\ua094\u9e68\u61ed".toCharArray();
            cArray6[3] = (char)(cArray6[3] ^ 0x7F2B);
            char[] cArray7 = "\u22b8\u0d99\u06bf\u7003\u9a38\u15d8".toCharArray();
            cArray7[2] = (char)(cArray7[2] ^ 0x3E2B);
            char[] cArray8 = "\uad86\u480b\u3b53\ud983\u7575".toCharArray();
            cArray8[3] = (char)(cArray8[3] ^ 0x6CF9);
            char[] cArray9 = "\ubb27\u6170\u11e5\u8535\u749c\ua299\ue6e3\u65ae\ufdc4\ud109\u1f1f\uafd3\uf4ed\uf5a0\u3c22\ua20d\u0dc7\u3c2b\ub44e\ub79c\ud116\u7b98\uf02f\u5380\u2065\u49ac\ud14b\u119f\ud53a\u5f53\u2cf6\ua9b9\ub973\uca51\uf331\u3fed\u7eb5".toCharArray();
            cArray9[33] = (char)(cArray9[33] ^ 0x66B9);
            char[] cArray10 = "\u5809\ua836\ud8c0\u1f1e\ufcce\uc663\ufff2\u67d1\u9fc2\u38b7\u0cff\u6573\ue554\u6f6b\u865a\uc464\u9cfc\uf827\u893a\u49f5\u70e8\uf39e\u1d74\uc717\u2f1e\u7c38\ucc12\ue38b\u0596\u111e\uf735\ud3b1\u8829\uebd4\ud44d\uccd5\u8e06\ubb77\uada7\u6d77".toCharArray();
            cArray10[18] = (char)(cArray10[18] ^ 0x2198);
            PADES = new SignatureType(DecryptFacade$DecryptFacade.k(cArray7, (short)21845, (short)3, (short)2), DecryptFacade$DecryptFacade.k(cArray8, (short)20283, (short)3, (short)1), DecryptFacade$DecryptFacade.k(cArray9, (short)24061, (short)1, (short)1), DecryptFacade$DecryptFacade.k(cArray10, (short)14880, (short)4, (short)1));
            char[] cArray11 = "\uf64e\ud6f5\ucb64\u28d9\u5456\u50a8".toCharArray();
            cArray11[4] = (char)(cArray11[4] ^ 0x59C1);
            char[] cArray12 = "\ube2b\u5b7a\u2ecf\ua80e\u097b\u2da4".toCharArray();
            cArray12[2] = (char)(cArray12[2] ^ 0x4EEA);
            char[] cArray13 = "\ua427\u49b1\uef67\u29cd\u1d65".toCharArray();
            cArray13[3] = (char)(cArray13[3] ^ 0x7E36);
            char[] cArray14 = "\u9bea\u001c\ub27f\u12be\uba5c\u4811\u8405\ud9a3\ubd84\uaacc\ue2e0\ub7a7\u2cd8\uc8fa\u6940\u69c5\uc5b7\u4eb9\ubf44\udcde\u1b4f\ub5d9\uafde\u3a33\uecb7\u2f89\ud3f6\u7282\u40fd\u1cd2\u70a4\u6fd3\udc32\ub943\ud42c\uc429\u0222".toCharArray();
            cArray14[1] = (char)(cArray14[1] ^ 0x799);
            char[] cArray15 = "\u268d\u6288\u7c1c\u3eee\u7c2f\u560c\u8a93\u4e95\u0266\uc0f0\u883d\uc0d7\u7fa0\u7176\ude85\ufb12\ub2c2\u2ae1\ud26e\u92b6\ufe3d\u6cd6\u724d\ub8bb\u3cd6\u08e6\ue699\u9403\u744a\u1f83\u9425\ucbc4\u80d5\u0ff4\u60fd\uca99\ud316\u785c\u4d4f\u1c3f".toCharArray();
            cArray15[8] = (char)(cArray15[8] ^ 0x6835);
            XADES = new SignatureType(DecryptFacade$DecryptFacade.k(cArray12, (short)23143, (short)1, (short)5), DecryptFacade$DecryptFacade.k(cArray13, (short)13852, (short)5, (short)0), DecryptFacade$DecryptFacade.k(cArray14, (short)29071, (short)3, (short)5), DecryptFacade$DecryptFacade.k(cArray15, (short)5939, (short)0, (short)3));
            char[] cArray16 = "\u3ed9\u6176\uc4f4\uc392\ub326\u3c34".toCharArray();
            cArray16[2] = (char)(cArray16[2] ^ 0xABB);
            char[] cArray17 = "\u17f9\u0735\u24ee\ua943\u677c\u4076\u7926".toCharArray();
            cArray17[1] = (char)(cArray17[1] ^ 0x7D7B);
            char[] cArray18 = "\u7d13\u07c8\u3428\u7035\u9507\ua078\u10ab".toCharArray();
            cArray18[2] = (char)(cArray18[2] ^ 0x4AE7);
            char[] cArray19 = "\u8090\u5613\u3574\u837c\uf13c\u1e2c\u453c".toCharArray();
            cArray19[5] = (char)(cArray19[5] ^ 0x23E5);
            char[] cArray20 = "\uc13f\ua109\ufb01\u4b6e\udd47\uece9\uc62b\udaca\uca46\u03a3\uc20f\u7946\ue48a\u9b03\u5ed0\u6ac2\u56a2\uef53\u6ef1\uaf6b\u56b9\uc9d3\ud477\u1d8e\u73c9\u0903\u8e67\ue622\ueb58\ud4f4\uac5c\ua59a\u4ca2\ud6a8\u553d\u0201\ucc4b\u0ead\u24e2".toCharArray();
            cArray20[33] = (char)(cArray20[33] ^ 0x6653);
            ASICS = new SignatureType(DecryptFacade$DecryptFacade.k(cArray17, (short)13851, (short)3, (short)2), DecryptFacade$DecryptFacade.k(cArray18, (short)24911, (short)4, (short)5), DecryptFacade$DecryptFacade.k(cArray19, (short)3700, (short)4, (short)2), DecryptFacade$DecryptFacade.k(cArray20, (short)27996, (short)3, (short)2));
            char[] cArray21 = "\u835e\u8e1a\u94d0\u533c\ud315\u56e3".toCharArray();
            cArray21[0] = (char)(cArray21[0] ^ 0x2C13);
            char[] cArray22 = "\u538c\u1d6e\ufa2d\u5429\u766c\u34e6\u7d24".toCharArray();
            cArray22[0] = (char)(cArray22[0] ^ 0x662F);
            char[] cArray23 = "\u78e7\u4f28\uf9a5\u2b6a\u9a02\u5861\u6b5c".toCharArray();
            cArray23[5] = (char)(cArray23[5] ^ 0x209C);
            char[] cArray24 = "\u8a4b\u4732\uf459\u564b\u8563\u8c96\u1c99".toCharArray();
            cArray24[4] = (char)(cArray24[4] ^ 0x778A);
            char[] cArray25 = "\u41fb\u21da\uc63f\u619c\ua4d4\u14ec\u7ddc\u8215\uccc7\u7db2\u817c\u68a8\u0afb\ue5ec\uad40\u30e2\u01a4\ud5ee\u50a0\u09f9\uc975\u23bf\uc1c8\uacc8\u974a\ue793\ufd7b\u44ce\ud0cc\u19eb\u4902\ud7dd\ua8aa\u7cab\u2e1b\ue0d8\u4354\uc407\u4392".toCharArray();
            cArray25[27] = (char)(cArray25[27] ^ 0x5AC);
            ASICE = new SignatureType(DecryptFacade$DecryptFacade.k(cArray22, (short)1613, (short)1, (short)0), DecryptFacade$DecryptFacade.k(cArray23, (short)32306, (short)4, (short)5), DecryptFacade$DecryptFacade.k(cArray24, (short)26399, (short)4, (short)4), DecryptFacade$DecryptFacade.k(cArray25, (short)25775, (short)3, (short)1));
            char[] cArray26 = "\uf9c3\u7d90\u56aa\u7a92".toCharArray();
            cArray26[0] = (char)(cArray26[0] ^ 0x2B6A);
            char[] cArray27 = "\ud40c\ud6a6\u9126\u7f56".toCharArray();
            cArray27[0] = (char)(cArray27[0] ^ 0x4609);
            char[] cArray28 = "\udb8b\u6c44\u94ec\u60e8\u7524".toCharArray();
            cArray28[2] = (char)(cArray28[2] ^ 0x4A79);
            char[] cArray29 = "\u7bb2\uc3fe\u0ca1\u34aa".toCharArray();
            cArray29[1] = (char)(cArray29[1] ^ 0x450E);
            TSD = new SignatureType(DecryptFacade$DecryptFacade.k(cArray27, (short)23046, (short)3, (short)1), DecryptFacade$DecryptFacade.k(cArray28, (short)18066, (short)4, (short)5), DecryptFacade$DecryptFacade.k(cArray29, (short)20744, (short)4, (short)0), "");
            $VALUES = new SignatureType[]{CADES, PADES, XADES, ASICS, ASICE, TSD};
        }

        private static Object VB(Object object, Object object2, Object object3) {
            try {
                return new ConstantCallSite(((MethodHandles.Lookup)object).unreflect(jnjtysbc.n(Integer.valueOf((String)object2, 32))).asType((MethodType)object3));
            }
            catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                throw new BootstrapMethodError(reflectiveOperationException);
            }
        }
    }
}

