/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging;

import java.io.File;
import java.util.LinkedList;

public class LoggerConfig {
    public static final String OUT_FORMAT_TEXT = "TEXT";
    public static final String OUT_FORMAT_JSON = "JSON";
    protected File fileAppender = null;
    protected boolean bConsoleAppenderEnabled = false;
    protected long timeRolling = 0L;
    protected String timeRollingPattern = "yyyy-MM-dd_HHmmss";
    protected long spaceRolling = 0L;
    protected String zipExt = ".zip";
    protected String charset = "UTF-8";
    protected boolean dailyRollingEnable;
    protected String dailyRollingPattern = "yyyy-MM-dd";
    protected LinkedList<String> debugPackages = null;
    protected LinkedList<String> ignoredInStackTrace = null;
    protected int baseSpaceRollingIndex = 0;
    protected boolean rollingCompressed = true;
    protected String outputFormat = "TEXT";

    public void setFileAppender(File appender) {
        this.fileAppender = appender;
    }

    public boolean isFileAppenderSet() {
        return this.fileAppender != null;
    }

    public File getFileAppender() {
        return this.fileAppender;
    }

    public void setConsoleAppender(boolean bEnabled) {
        this.bConsoleAppenderEnabled = bEnabled;
    }

    public boolean isConsoleAppenderSet() {
        return this.bConsoleAppenderEnabled;
    }

    public boolean isTimeRollingEnabled() {
        return this.timeRolling > 0L;
    }

    public long getTimeRolling() {
        return this.timeRolling;
    }

    public void setTimeRolling(long timeRollingMillisec) {
        this.timeRolling = timeRollingMillisec;
    }

    public String getTimeRollingPattern() {
        return this.timeRollingPattern;
    }

    public void setTimeRollingPattern(String timeRollingPattern) {
        if (timeRollingPattern != null && !timeRollingPattern.isEmpty()) {
            this.timeRollingPattern = timeRollingPattern;
        }
    }

    public boolean isSpaceRollingEnabled() {
        return this.spaceRolling > 0L;
    }

    public long getSpaceRolling() {
        return this.spaceRolling;
    }

    public void setSpaceRolling(long spaceRollingMegaByte) {
        this.spaceRolling = spaceRollingMegaByte;
    }

    public int getBaseSpaceRollingIndex() {
        return this.baseSpaceRollingIndex;
    }

    public void setBaseSpaceRollingIndex(int baseSpaceRollingIndex) {
        this.baseSpaceRollingIndex = Math.max(baseSpaceRollingIndex, 0);
    }

    public String getZipExt() {
        return this.zipExt;
    }

    public void setZipExt(String zipExt) {
        this.zipExt = zipExt;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isDailyRollingEnable() {
        return this.dailyRollingEnable;
    }

    public void setDailyRollingEnable(boolean dailyRollingEnable) {
        this.dailyRollingEnable = dailyRollingEnable;
    }

    public LinkedList<String> getDebugPackages() {
        return this.debugPackages;
    }

    public void setDebugPackages(String packages) {
        if (packages == null || packages.isEmpty()) {
            return;
        }
        this.debugPackages = new LinkedList();
        String[] packPath = packages.split(";");
        for (int i = 0; i < packPath.length; ++i) {
            this.debugPackages.add(packPath[i]);
        }
    }

    public LinkedList<String> getIgnoredInStackTrace() {
        return this.ignoredInStackTrace;
    }

    public void setIgnoredInStackTrace(String packages) {
        if (packages == null || packages.isEmpty()) {
            return;
        }
        this.ignoredInStackTrace = new LinkedList();
        String[] packPath = packages.split(";");
        for (int i = 0; i < packPath.length; ++i) {
            this.ignoredInStackTrace.add(packPath[i]);
        }
    }

    public String getDailyRollingPattern() {
        return this.dailyRollingPattern;
    }

    public void setDailyRollingPattern(String dailyRollingPattern) {
        if (dailyRollingPattern != null && !dailyRollingPattern.isEmpty()) {
            this.dailyRollingPattern = dailyRollingPattern;
        }
    }

    public boolean isRollingCompressed() {
        return this.rollingCompressed;
    }

    public void setRollingCompressed(boolean rollingCompressed) {
        this.rollingCompressed = rollingCompressed;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }
}

