/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.logging;

import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.FileAppender;
import it.actalis.ellips.capi.logging.LoggerConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.actalis.ellips.capi.logging.MasterLoggerMode;
import it.actalis.ellips.capi.logging.StreamFileAppender;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;

public final class EllipsLoggerFactory {
    private static HashMap<String, EllipsLogger> hmapLogger = new HashMap();
    private static HashMap<String, FileAppender> hmapFileAppender = new HashMap();
    private static EllipsLogger masterLogger = null;

    private EllipsLoggerFactory() {
    }

    public static EllipsLogger createLogger(String name, String pattern, LoggerLevel level, LoggerConfig config) {
        boolean mustResetMasterLogger = false;
        try {
            EllipsLogger logger = hmapLogger.get(name);
            if (logger != null) {
                if (masterLogger != null && masterLogger.getName().equals(logger.getName())) {
                    mustResetMasterLogger = true;
                }
                EllipsLoggerFactory.removeLogger(logger);
            }
            if (config != null && config.isFileAppenderSet()) {
                boolean bValidFileAppender = true;
                try {
                    EllipsLoggerFactory.addFileAppender(config.getFileAppender().getAbsolutePath());
                }
                catch (FileNotFoundException ex) {
                    bValidFileAppender = false;
                    System.err.println(ex.getMessage());
                }
                catch (IOException ex) {
                    bValidFileAppender = false;
                    System.err.println(ex.getMessage());
                }
                if (!bValidFileAppender) {
                    System.err.println("Try to use the console appender instead");
                    config.setConsoleAppender(true);
                    config.setFileAppender(null);
                }
            }
            logger = new EllipsLogger(name, pattern, level, config);
            hmapLogger.put(logger.getName(), logger);
            if (mustResetMasterLogger) {
                EllipsLoggerFactory.setMasterLogger(logger);
            }
            return logger;
        }
        catch (Exception ex) {
            System.err.println("Unable to update logger setup");
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public static EllipsLogger getLogger(String name) {
        EllipsLogger logger = hmapLogger.get(name);
        if (logger == null) {
            String pattern = null;
            LoggerLevel level = null;
            LoggerConfig config = null;
            if (masterLogger != null) {
                pattern = masterLogger.getMessagePattern();
                level = masterLogger.getLevel();
                config = masterLogger.getConfig();
            }
            logger = EllipsLoggerFactory.createLogger(name, pattern, level, config);
        }
        return logger;
    }

    public static EllipsLogger getMasterLogger() {
        return masterLogger;
    }

    public static void setMasterLogger(EllipsLogger logger) throws InterruptedException {
        EllipsLoggerFactory.setMasterLogger(logger.getName(), MasterLoggerMode.DefaultConfig);
    }

    public static void setMasterLogger(String name) throws InterruptedException {
        EllipsLoggerFactory.setMasterLogger(name, MasterLoggerMode.DefaultConfig);
    }

    public static void setMasterLogger(EllipsLogger logger, MasterLoggerMode mode) throws InterruptedException {
        EllipsLoggerFactory.setMasterLogger(logger.getName(), mode);
    }

    public static void setMasterLogger(String name, MasterLoggerMode mode) throws InterruptedException {
        EllipsLogger logger;
        masterLogger = logger = hmapLogger.get(name);
        EllipsLoggerFactory.updateLoggersByMaster(mode);
    }

    private static void updateLoggersByMaster(MasterLoggerMode mode) throws InterruptedException {
        if (mode.equals((Object)MasterLoggerMode.NewOnly)) {
            return;
        }
        for (EllipsLogger value : hmapLogger.values()) {
            EllipsLogger curLogger = value;
            if (curLogger.getName() == masterLogger.getName()) continue;
            if (mode.equals((Object)MasterLoggerMode.All)) {
                curLogger.update(masterLogger.getConfig(), masterLogger.getLevel());
                continue;
            }
            if (!curLogger.isDefaultConfig()) continue;
            curLogger.update(masterLogger.getConfig(), masterLogger.getLevel());
        }
    }

    public static String[] getLoggerNames() {
        if (hmapLogger == null || hmapLogger.size() == 0) {
            return null;
        }
        String[] names = new String[hmapLogger.size()];
        int i = 0;
        for (EllipsLogger value : hmapLogger.values()) {
            names[i++] = value.getName();
        }
        return names;
    }

    public static int getLoggerCount() {
        return hmapLogger.size();
    }

    public static void removeLogger(EllipsLogger logger) {
        if (logger.getConfig().isFileAppenderSet()) {
            try {
                EllipsLoggerFactory.releaseFileAppender(logger.getConfig().getFileAppender().getAbsolutePath());
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
            }
        }
        hmapLogger.remove(logger.getName());
        if (masterLogger != null && masterLogger.getName().equals(logger.getName())) {
            masterLogger = null;
        }
    }

    public static void reset() {
        if (EllipsLoggerFactory.getLoggerCount() == 0) {
            return;
        }
        String[] loggersToClose = EllipsLoggerFactory.getLoggerNames();
        for (int iLog = 0; iLog < loggersToClose.length; ++iLog) {
            EllipsLoggerFactory.removeLogger(EllipsLoggerFactory.getLogger(loggersToClose[iLog]));
        }
    }

    protected void finalize() throws Throwable {
        try {
            EllipsLoggerFactory.reset();
        }
        finally {
            super.finalize();
        }
    }

    private static synchronized void addFileAppender(String logFilePath) throws IOException {
        FileAppender fAppender = hmapFileAppender.get(logFilePath);
        if (fAppender == null) {
            fAppender = new StreamFileAppender(logFilePath);
            hmapFileAppender.put(logFilePath, fAppender);
        } else {
            fAppender.addReference();
        }
    }

    private static synchronized void releaseFileAppender(String logFilePath) throws IOException {
        FileAppender fAppender = hmapFileAppender.get(logFilePath);
        if (fAppender == null) {
            return;
        }
        fAppender.release();
        if (fAppender.getReferences() == 0) {
            hmapFileAppender.remove(logFilePath);
        }
    }

    public static synchronized void writeToFileAppender(String logFilePath, String message, Charset charset) throws IOException {
        FileAppender fAppender = hmapFileAppender.get(logFilePath);
        if (fAppender == null) {
            return;
        }
        fAppender.writeTo(message, charset);
    }

    public static int countFileAppenderReferences(String logFilePath) {
        FileAppender fAppender = hmapFileAppender.get(logFilePath);
        if (fAppender == null) {
            return 0;
        }
        return fAppender.getReferences();
    }

    public static void backupFileAppender(String logFilePath, String backupFilePath, String backupFileExtension, boolean compress) throws IOException {
        FileAppender fAppender = hmapFileAppender.get(logFilePath);
        if (fAppender == null) {
            return;
        }
        fAppender.backup(backupFilePath, backupFileExtension, compress);
    }

    public static void backupFileAppender(LoggerConfig logConf, String backupFilePath, String backupFileExtension, boolean compress) throws IOException {
        FileAppender fAppender = hmapFileAppender.get(logConf.getFileAppender().getAbsolutePath());
        if (fAppender == null) {
            return;
        }
        fAppender.backup(backupFilePath, backupFileExtension, logConf.getBaseSpaceRollingIndex(), logConf.isRollingCompressed());
    }
}

