/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class ReflectedClass {
    private Object obj;
    private Class clss;

    ReflectedClass(Class clss) throws IllegalArgumentException {
        if (clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        this.clss = clss;
    }

    ReflectedClass(Object obj) throws IllegalArgumentException {
        this(obj.getClass());
        this.obj = obj;
    }

    ReflectedClass init(Object ... params) throws IllegalArgumentException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        Constructor method = (Constructor)this.retrieveExecutableFromType(this.clss, null, false, params);
        if (method == null) {
            throw new NoSuchMethodException("Constructor " + this.clss.getName());
        }
        this.obj = method.newInstance(params);
        return this;
    }

    public Object callMethod(String methodName, Object ... params) throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        Method method = (Method)this.retrieveExecutableFromType(this.clss, methodName, false, params);
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method.invoke(this.obj, params);
    }

    public int getInt(String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        Field f = this.clss.getField(fieldName);
        f.setAccessible(true);
        return f.getInt(this.obj);
    }

    public long getLong(String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        Field f = this.clss.getField(fieldName);
        f.setAccessible(true);
        return f.getLong(this.obj);
    }

    public Object getObject(String fieldName) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        Field f = this.clss.getField(fieldName);
        f.setAccessible(true);
        return f.get(this.obj);
    }

    public void setBoolean(String fieldName, boolean value) throws IllegalAccessException, IllegalArgumentException, NoSuchFieldException, SecurityException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        Field f = this.clss.getField(fieldName);
        f.setAccessible(true);
        f.setBoolean(this.obj, value);
    }

    public String callMethodAsString(String methodName, Object ... params) throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object ret = this.callMethod(methodName, params);
        if (ret != null) {
            return ret.toString();
        }
        return null;
    }

    public Boolean callMethodAsBoolean(String methodName, Object ... params) throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object ret = this.callMethod(methodName, params);
        if (ret != null) {
            return (Boolean)ret;
        }
        throw new NoSuchMethodException(methodName);
    }

    public ReflectedClass callMethodAsRef(String methodName, Object ... params) throws IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return new ReflectedClass(this.callMethod(methodName, params));
    }

    public Object callStaticMethod(String methodName, Object ... params) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        Method method = (Method)this.retrieveExecutableFromType(this.clss, methodName, true, params);
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method.invoke(null, params);
    }

    private Object retrieveExecutableFromType(Class cls, String methodName, boolean isStatic, Object ... params) {
        if (methodName == null) {
            return this.retrieveCostructorFromType(cls, isStatic, params);
        }
        return this.retrieveMethodFromType(cls, methodName, isStatic, params);
    }

    private Constructor retrieveCostructorFromType(Class cls, boolean isStatic, Object ... params) {
        Constructor<?>[] arrayExe = null;
        for (Constructor<?> method : arrayExe = cls.getConstructors()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || isStatic || Modifier.isStatic(modifiers) || !this.checkParams(method.getParameterTypes(), params)) continue;
            return method;
        }
        return null;
    }

    private Method retrieveMethodFromType(Class cls, String methodName, boolean isStatic, Object ... params) {
        Method[] arrayExe = null;
        for (Method method : arrayExe = cls.getMethods()) {
            if (!method.getName().equals(methodName) && methodName != null || !Modifier.isPublic(method.getModifiers()) || (!isStatic ? Modifier.isStatic(method.getModifiers()) : !Modifier.isStatic(method.getModifiers())) || !this.checkParams(method.getParameterTypes(), params)) continue;
            return method;
        }
        return null;
    }

    public Class getClss() {
        return this.clss;
    }

    public Object getObj() {
        return this.obj;
    }

    public Object getEnumValue(String name) throws IllegalArgumentException {
        if (this.clss == null) {
            throw new IllegalArgumentException("Class is null");
        }
        return Enum.valueOf(this.clss, name);
    }

    private boolean checkParams(Class<?>[] paramsType, Object ... params) {
        boolean paramsAreMatching = true;
        int i = 0;
        if (paramsType.length == params.length) {
            for (i = 0; i < paramsType.length; ++i) {
                if (paramsType[i].isPrimitive()) {
                    if (params[i] != null) {
                        if (paramsType[i].equals(Byte.TYPE)) {
                            if (params[i].getClass().equals(Byte.class)) continue;
                            paramsAreMatching = false;
                            continue;
                        }
                        if (paramsType[i].equals(Integer.TYPE)) {
                            if (params[i].getClass().equals(Integer.class)) continue;
                            paramsAreMatching = false;
                            continue;
                        }
                        if (paramsType[i].equals(Long.TYPE)) {
                            if (params[i].getClass().equals(Long.class)) continue;
                            paramsAreMatching = false;
                            continue;
                        }
                        if (paramsType[i].equals(Double.TYPE)) {
                            if (params[i].getClass().equals(Double.class)) continue;
                            paramsAreMatching = false;
                            continue;
                        }
                        if (paramsType[i].equals(Boolean.TYPE)) {
                            if (params[i].getClass().equals(Boolean.class)) continue;
                            paramsAreMatching = false;
                            continue;
                        }
                        if (paramsType[i].equals(Float.TYPE)) {
                            if (params[i].getClass().equals(Float.class)) continue;
                            paramsAreMatching = false;
                            continue;
                        }
                        paramsAreMatching = false;
                        continue;
                    }
                    paramsAreMatching = false;
                    continue;
                }
                if (params[i] == null || paramsType[i].isAssignableFrom(params[i].getClass())) continue;
                paramsAreMatching = false;
            }
        } else {
            paramsAreMatching = false;
        }
        return paramsAreMatching;
    }
}

