/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;

public class Image
extends DOMElement {
    public Image(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("img", id, parentId);
    }

    public Image(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("img", id, parent.getId());
    }

    public Image(String id, View view, boolean create) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        if (create) {
            Image.createElementWithID("img", id, view);
        }
    }

    public void setSource(String src) {
        this.setAttribute("src", src);
    }

    public static Image retrieveImage(String id, View currentView) {
        return Image.getElementById(id, currentView);
    }

    public static Image getElementById(String id, View currentView) {
        if (Image.exist(id, currentView)) {
            return new Image(id, currentView, false);
        }
        return null;
    }
}

