/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.client;

import com.beust.jcommander.JCommander;
import esecurity.dsd.client.cache.CacheProvider;
import esecurity.dsd.client.cmd.Command;
import esecurity.dsd.client.cmd.CommandLineExecutor;
import esecurity.dsd.core.DomainProvider;
import esecurity.dsd.core.LocalConfigurationProvider;
import esecurity.dsd.core.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class DomainServiceDiscovery
implements Closeable {
    private ScheduledExecutorService scheduler = null;

    public DomainProvider bootstrap(Observer observer, List<String> defaultDomains, LocalConfigurationProvider ... providers) throws SecurityException, Exception {
        CacheProvider cacheProvider = new CacheProvider(defaultDomains, providers);
        if (observer != null) {
            cacheProvider.addObserver(observer);
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        cacheProvider.installCacheUpdaterJob(this.scheduler);
        return cacheProvider;
    }

    public DomainProvider bootstrap(LocalConfigurationProvider ... providers) throws SecurityException, Exception {
        return this.bootstrap(null, new ArrayList<String>(), providers);
    }

    public static void main(String[] args) {
        Log.logger().info("Starts DSD.");
        System.setProperty("org.slf4j.simpleLogger.showThreadName", Boolean.FALSE.toString());
        System.setProperty("org.slf4j.simpleLogger.showLogName ", Boolean.FALSE.toString());
        System.out.println("Domain Service Discovery");
        if (args.length == 0) {
            args = new String[]{"--help"};
        }
        CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
        JCommander.Builder builder = JCommander.newBuilder().addObject((Object)commandLineExecutor);
        for (Command c : commandLineExecutor.getCommands()) {
            builder.addCommand(c.getCommand(), (Object)c, new String[0]);
        }
        JCommander commander = builder.build();
        commander.setProgramName("DSD");
        commander.parse(args);
        commandLineExecutor.execute(commander);
    }

    @Override
    public void close() throws IOException {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SecurityException e1) {
                Log.logger().error("Impossibile effettuare lo shutdown dello scheduler", (Throwable)e1);
            }
            finally {
                this.scheduler = null;
            }
        }
    }
}

