/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.UnknownResponseException;
import iaik.xml.crypto.xades.EncapsulatedOCSPValue;
import iaik.xml.crypto.xades.impl.dom.properties.EncapsulatedPKIDataType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Node;

public class EncapsulatedOCSPValueImpl
extends EncapsulatedPKIDataType
implements EncapsulatedOCSPValue {
    private OCSPResponse a;

    protected void setEncodedPKIValue(InputStream inputStream, String string) throws MarshalException {
        if (string == null || string.equals("http://uri.etsi.org/01903/v1.2.2#DER") || string.equals("http://uri.etsi.org/01903/v1.2.2#BER")) {
            try {
                this.a = new OCSPResponse(inputStream);
            }
            catch (UnknownResponseException unknownResponseException) {
                throw new MarshalException("Failed to decode OCSP response, " + unknownResponseException.getMessage(), unknownResponseException);
            }
            catch (IOException iOException) {
                throw new MarshalException("Failed to decode OCSP response, " + iOException.getMessage(), iOException);
            }
        } else {
            throw new MarshalException("Failed to decode OCSP response, encoding mechanism '" + string + "' is not supported");
        }
    }

    public byte[] getOCSPResponse() {
        return this.a.getEncoded();
    }

    public String getLocalName() {
        return "EncapsulatedOCSPValue";
    }

    protected InputStream getEncodedPKIValue(String string) throws MarshalException {
        if (string == null || string.equals("http://uri.etsi.org/01903/v1.2.2#DER")) {
            try {
                return new ByteArrayInputStream(this.a.getEncoded());
            }
            catch (Exception exception) {
                throw new MarshalException("Failed to encode OCSP response, " + exception.getMessage(), exception);
            }
        }
        throw new MarshalException("Failed to encode OCSP response, encoding mechanism '" + string + "' is not supported");
    }

    public EncapsulatedOCSPValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.a == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public EncapsulatedOCSPValueImpl(OCSPResponse oCSPResponse, String string, String string2) {
        super(string, string2);
        if (oCSPResponse == null) {
            throw new NullPointerException("Argument 'response' must not be null");
        }
        this.a = oCSPResponse;
    }
}

