/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.resources;

import finanze.IDTE.generale2021.BaseTelem;
import finanze.IDTE.generale2021.CheckedBufferedReader;
import finanze.IDTE.generale2021.CheckedBufferedReaderOld;
import finanze.IDTE.generale2021.CheckedBufferedReaderUTF8;
import finanze.IDTE.generale2021.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ResourceLoader
implements Serializable {
    private static final long serialVersionUID = 2668943476743445832L;
    public static final String RES_EXT = ".res";
    protected boolean isKeyRequired;
    protected int numControlliRes = 0;
    protected Object resourceData;

    protected ResourceLoader(Object resourceData) {
        if (resourceData instanceof Hashtable) {
            this.isKeyRequired = true;
        } else if (resourceData instanceof Vector) {
            this.isKeyRequired = false;
        } else {
            throw new IllegalArgumentException("Errore nel costruttore della classe '" + this.getClass().getName() + "': il tipo '" + resourceData.getClass().getName() + "' non \u00e8 un argomento valido");
        }
        this.resourceData = resourceData;
    }

    protected abstract Object createValue(String var1);

    public Enumeration elements() {
        return this.isKeyRequired ? ((Hashtable)this.resourceData).elements() : ((Vector)this.resourceData).elements();
    }

    protected Object getValue(String key) {
        return this.isKeyRequired ? ((Hashtable)this.resourceData).get(key) : null;
    }

    protected Object getValueAt(int dataIndex) {
        return this.isKeyRequired ? null : ((Vector)this.resourceData).elementAt(dataIndex);
    }

    public Enumeration keys() {
        return this.isKeyRequired ? ((Hashtable)this.resourceData).keys() : null;
    }

    public synchronized void load(String fileName) throws IOException, RuntimeException {
        boolean firstLine = false;
        this.numControlliRes = 0;
        int i = 0;
        InputStream fileStream = ResourceLoader.class.getResourceAsStream(fileName);
        byte[] bbuf = new byte[fileStream.available()];
        fileStream.read(bbuf);
        fileStream.close();
        BufferedReader ckReader = Util.isUTF8(bbuf) ? new CheckedBufferedReaderUTF8(ResourceLoader.class.getResourceAsStream(fileName)) : new CheckedBufferedReaderOld(ResourceLoader.class.getResourceAsStream(fileName));
        try {
            String line;
            long resCode = 0L;
            if (BaseTelem.currentContext == 0) {
                resCode = this.readResourceCheckCode((CheckedBufferedReader)((Object)ckReader));
            }
            while ((line = ckReader.readLine()) != null) {
                if (ckReader.isCommentLine(line)) continue;
                if (!firstLine) {
                    this.numControlliRes = Util.contaCaratteri(line, '*', line.indexOf("=")) + 1;
                    firstLine = true;
                }
                this.loadData(line);
                ++i;
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Errore nella struttura del file " + fileName + ":\n" + e.getMessage() + " " + i);
        }
    }

    protected void loadData(String line) {
        int pos = line.indexOf(61);
        if (pos > 0) {
            ((Hashtable)this.resourceData).put(line.substring(0, pos).trim(), this.createValue(line.substring(pos + 1).trim()));
        } else {
            ((Vector)this.resourceData).addElement(this.createValue(line.trim()));
        }
    }

    private long readResourceCheckCode(CheckedBufferedReader ckReader) throws IOException {
        String line = ckReader.readLine();
        if (ckReader.isCommentLine(line)) {
            return Long.parseLong(line.substring(1).trim());
        }
        throw new RuntimeException("marchio di controllo assente o errato");
    }

    public int size() {
        return this.isKeyRequired ? ((Hashtable)this.resourceData).size() : ((Vector)this.resourceData).size();
    }

    public synchronized Vector getRecDim(String fileName) throws IOException, RuntimeException {
        Vector<Integer> v = new Vector<Integer>();
        boolean firstLine = false;
        this.numControlliRes = 0;
        int i = 0;
        InputStream fileStream = ResourceLoader.class.getResourceAsStream(fileName);
        byte[] bbuf = new byte[fileStream.available()];
        fileStream.read(bbuf);
        fileStream.close();
        BufferedReader ckReader = Util.isUTF8(bbuf) ? new CheckedBufferedReaderUTF8(ResourceLoader.class.getResourceAsStream(fileName)) : new CheckedBufferedReaderOld(ResourceLoader.class.getResourceAsStream(fileName));
        try {
            String line;
            long resCode = 0L;
            if (BaseTelem.currentContext == 0) {
                resCode = this.readResourceCheckCode((CheckedBufferedReader)((Object)ckReader));
            }
            while ((line = ckReader.readLine()) != null) {
                if (ckReader.isCommentLine(line)) continue;
                if (!firstLine) {
                    this.numControlliRes = Util.contaCaratteri(line, '*', line.indexOf("=")) + 1;
                    firstLine = true;
                }
                v.add(new Integer(line));
                ++i;
            }
            if (!System.getProperty("os.name").startsWith("Linux") && BaseTelem.currentContext == 0 && resCode != ckReader.getCheckValue()) {
                System.out.println("Codice sul file:" + fileName + "->" + resCode + " - Codice calcolato->" + ckReader.getCheckValue());
                String debug = System.getProperty("eclipse");
                if (debug == null) {
                    throw new RuntimeException("caratteri di controllo errati");
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Errore nella struttura del file " + fileName + ":\n" + e.getMessage() + " " + i);
        }
        return v;
    }
}

