/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2008;

import java.math.BigInteger;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class IBAN {
    static /* synthetic */ Class class$0;

    public static boolean isCheckDigitValid(String iban) {
        if (iban == null) {
            return false;
        }
        int validIBANLength = IBAN.getValidIBANLength(iban);
        if (validIBANLength < 4) {
            return false;
        }
        if (iban.length() != validIBANLength) {
            return false;
        }
        BigInteger numericIBAN = IBAN.getNumericIBAN(iban, false);
        int checkDigit = numericIBAN.mod(new BigInteger("97")).intValue();
        return checkDigit == 1;
    }

    public static int getValidIBANLength(String countryCode) {
        int lunghezza;
        String length;
        block7: {
            String code = countryCode.substring(0, 2).toUpperCase();
            length = "";
            lunghezza = 0;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("finanze.IDTE.generale2008.IBAN");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((length = ResourceBundle.getBundle(clazz.getName()).getString("length." + code)) != null) break block7;
            return -1;
        }
        try {
            lunghezza = Integer.valueOf(length);
        }
        catch (MissingResourceException e) {
            System.out.println("Errore - Codice Nazione non valido");
        }
        return lunghezza;
    }

    private static BigInteger getNumericIBAN(String iban, boolean isCheckDigitAtEnd) {
        String endCheckDigitIBAN = iban;
        if (!isCheckDigitAtEnd) {
            endCheckDigitIBAN = String.valueOf(iban.substring(4)) + iban.substring(0, 4);
        }
        StringBuffer numericIBAN = new StringBuffer();
        int i = 0;
        while (i < endCheckDigitIBAN.length()) {
            if (Character.isDigit(endCheckDigitIBAN.charAt(i))) {
                numericIBAN.append(endCheckDigitIBAN.charAt(i));
            } else {
                numericIBAN.append(10 + IBAN.getAlphabetPosition(endCheckDigitIBAN.charAt(i)));
            }
            ++i;
        }
        return new BigInteger(numericIBAN.toString());
    }

    private static int getAlphabetPosition(char letter) {
        return new Character(Character.toUpperCase(letter)).compareTo(new Character('A'));
    }
}

