/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import iaik.xml.crypto.alg.cipher.RSAProxyCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.enc.spec.RSAOAEPParameterSpec;

public class RSAOAEPProxyCipher
extends RSAProxyCipher {
    protected String getCipherName() {
        return "RSA/ECB/OAEP";
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (algorithmParameterSpec instanceof RSAOAEPParameterSpec) {
            try {
                super.engineInit(n, key, (AlgorithmParameterSpec)RSAOAEPProxyCipher.XML2PKCS1Spec((RSAOAEPParameterSpec)algorithmParameterSpec), secureRandom);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
            }
        } else {
            super.engineInit(n, key, algorithmParameterSpec, secureRandom);
        }
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        super.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        super.engineInit(n, key, algorithmParameters, secureRandom);
    }

    protected static final RSAOaepParameterSpec XML2PKCS1Spec(RSAOAEPParameterSpec rSAOAEPParameterSpec) throws InvalidParameterSpecException {
        AlgorithmID algorithmID;
        DigestMethod digestMethod = rSAOAEPParameterSpec.getDigestMethod();
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(digestMethod.getAlgorithm())) {
            algorithmID = (AlgorithmID)AlgorithmID.sha1.clone();
        } else if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(digestMethod.getAlgorithm())) {
            algorithmID = (AlgorithmID)AlgorithmID.sha256.clone();
        } else if ("http://www.w3.org/2001/04/xmlenc#sha384".equals(digestMethod.getAlgorithm())) {
            algorithmID = (AlgorithmID)AlgorithmID.sha384.clone();
        } else if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(digestMethod.getAlgorithm())) {
            algorithmID = (AlgorithmID)AlgorithmID.sha512.clone();
        } else if ("http://www.w3.org/2001/04/xmlenc#ripemd160".equals(digestMethod.getAlgorithm())) {
            algorithmID = (AlgorithmID)AlgorithmID.ripeMd160.clone();
        } else if ("http://www.w3.org/2001/04/xmlenc#md5".equals(digestMethod.getAlgorithm())) {
            algorithmID = (AlgorithmID)AlgorithmID.md5.clone();
        } else {
            throw new InvalidParameterSpecException("Illegal DigestMethod '" + digestMethod + "' specified in RSAOAEPParameterSpec.");
        }
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.pSpecified.clone();
        byte[] byArray = rSAOAEPParameterSpec.getOAEPParams();
        if (byArray != null) {
            algorithmID2.setParameter((ASN1Object)new OCTET_STRING(byArray));
        }
        return new RSAOaepParameterSpec(algorithmID, RSAOaepParameterSpec.DEFAULT_MASK_GEN_ALGORITHM, algorithmID2);
    }
}

