/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.ETypeInfo;
import sun.security.krb5.internal.ETypeInfo2;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAData {
    private int pADataType;
    private byte[] pADataValue = null;
    private static final byte TAG_PATYPE = 1;
    private static final byte TAG_PAVALUE = 2;

    private PAData() {
    }

    public PAData(int n, byte[] byArray) {
        this.pADataType = n;
        if (byArray != null) {
            this.pADataValue = (byte[])byArray.clone();
        }
    }

    public Object clone() {
        PAData pAData = new PAData();
        pAData.pADataType = this.pADataType;
        if (this.pADataValue != null) {
            pAData.pADataValue = new byte[this.pADataValue.length];
            System.arraycopy(this.pADataValue, 0, pAData.pADataValue, 0, this.pADataValue.length);
        }
        return pAData;
    }

    public PAData(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.pADataType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 2) {
            this.pADataValue = derValue2.getData().getOctetString();
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.pADataType);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.pADataValue);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public int getType() {
        return this.pADataType;
    }

    public byte[] getValue() {
        return this.pADataValue == null ? null : (byte[])this.pADataValue.clone();
    }

    public static SaltAndParams getSaltAndParams(int n, PAData[] pADataArray) throws Asn1Exception, KrbException {
        if (pADataArray == null || pADataArray.length == 0) {
            return new SaltAndParams(null, null);
        }
        String string = null;
        Object object = null;
        Object object2 = null;
        for (PAData pAData : pADataArray) {
            if (pAData.getValue() == null) continue;
            try {
                switch (pAData.getType()) {
                    case 3: {
                        string = new String(pAData.getValue(), KerberosString.MSNAME ? "UTF8" : "8859_1");
                        break;
                    }
                    case 11: {
                        Object object3;
                        DerValue derValue;
                        DerValue derValue2 = new DerValue(pAData.getValue());
                        while (derValue2.data.available() > 0) {
                            derValue = derValue2.data.getDerValue();
                            object3 = new ETypeInfo(derValue);
                            if (((ETypeInfo)object3).getEType() != n) continue;
                            object2 = object3;
                        }
                        break;
                    }
                    case 19: {
                        Object object3;
                        DerValue derValue;
                        DerValue derValue2 = new DerValue(pAData.getValue());
                        while (derValue2.data.available() > 0) {
                            derValue = derValue2.data.getDerValue();
                            object3 = new ETypeInfo2(derValue);
                            if (((ETypeInfo2)object3).getEType() != n) continue;
                            object = object3;
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (object != null) {
            return new SaltAndParams(((ETypeInfo2)object).getSalt(), ((ETypeInfo2)object).getParams());
        }
        if (object2 != null) {
            return new SaltAndParams(((ETypeInfo)object2).getSalt(), null);
        }
        return new SaltAndParams(string, null);
    }

    public static class SaltAndParams {
        public final String salt;
        public final byte[] params;

        public SaltAndParams(String string, byte[] byArray) {
            if (string != null && string.isEmpty()) {
                string = null;
            }
            this.salt = string;
            this.params = byArray;
        }
    }
}

