/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ClassLoaderObjectOutputStream
extends ObjectOutputStream {
    private final Map<Set<String>, ClassLoader> map = new HashMap<Set<String>, ClassLoader>();

    public ClassLoaderObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    @Override
    protected void annotateClass(final Class<?> clazz) throws IOException {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(clazz.getName());
        this.map.put(hashSet, classLoader);
    }

    @Override
    protected void annotateProxyClass(final Class<?> clazz) throws IOException {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
        Class<?>[] classArray = clazz.getInterfaces();
        HashSet<String> hashSet = new HashSet<String>(classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            hashSet.add(classArray[i].getName());
        }
        this.map.put(hashSet, classLoader);
    }

    public Map<Set<String>, ClassLoader> getClassLoaderMap() {
        return new HashMap<Set<String>, ClassLoader>(this.map);
    }
}

