/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;

class AncestorNotifier
implements ComponentListener,
PropertyChangeListener,
Serializable {
    Component firstInvisibleAncestor;
    EventListenerList listenerList = new EventListenerList();
    JComponent root;

    AncestorNotifier(JComponent jComponent) {
        this.root = jComponent;
        this.addListeners(jComponent, true);
    }

    void addAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.add(AncestorListener.class, ancestorListener);
    }

    void removeAncestorListener(AncestorListener ancestorListener) {
        this.listenerList.remove(AncestorListener.class, ancestorListener);
    }

    AncestorListener[] getAncestorListeners() {
        return (AncestorListener[])this.listenerList.getListeners(AncestorListener.class);
    }

    protected void fireAncestorAdded(JComponent jComponent, int n, Container container, Container container2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AncestorListener.class) continue;
            AncestorEvent ancestorEvent = new AncestorEvent(jComponent, n, container, container2);
            ((AncestorListener)objectArray[i + 1]).ancestorAdded(ancestorEvent);
        }
    }

    protected void fireAncestorRemoved(JComponent jComponent, int n, Container container, Container container2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AncestorListener.class) continue;
            AncestorEvent ancestorEvent = new AncestorEvent(jComponent, n, container, container2);
            ((AncestorListener)objectArray[i + 1]).ancestorRemoved(ancestorEvent);
        }
    }

    protected void fireAncestorMoved(JComponent jComponent, int n, Container container, Container container2) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != AncestorListener.class) continue;
            AncestorEvent ancestorEvent = new AncestorEvent(jComponent, n, container, container2);
            ((AncestorListener)objectArray[i + 1]).ancestorMoved(ancestorEvent);
        }
    }

    void removeAllListeners() {
        this.removeListeners(this.root);
    }

    void addListeners(Component component, boolean bl) {
        this.firstInvisibleAncestor = null;
        Component component2 = component;
        while (this.firstInvisibleAncestor == null) {
            if (bl || component2 != component) {
                component2.addComponentListener(this);
                if (component2 instanceof JComponent) {
                    JComponent jComponent = (JComponent)component2;
                    jComponent.addPropertyChangeListener(this);
                }
            }
            if (!component2.isVisible() || component2.getParent() == null || component2 instanceof Window) {
                this.firstInvisibleAncestor = component2;
            }
            component2 = component2.getParent();
        }
        if (this.firstInvisibleAncestor instanceof Window && this.firstInvisibleAncestor.isVisible()) {
            this.firstInvisibleAncestor = null;
        }
    }

    void removeListeners(Component component) {
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            component2.removeComponentListener(this);
            if (component2 instanceof JComponent) {
                JComponent jComponent = (JComponent)component2;
                jComponent.removePropertyChangeListener(this);
            }
            if (component2 == this.firstInvisibleAncestor || component2 instanceof Window) break;
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.fireAncestorMoved(this.root, 3, (Container)component, component.getParent());
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        if (component == this.firstInvisibleAncestor) {
            this.addListeners(component, false);
            if (this.firstInvisibleAncestor == null) {
                this.fireAncestorAdded(this.root, 1, (Container)component, component.getParent());
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        boolean bl;
        Component component = componentEvent.getComponent();
        boolean bl2 = bl = this.firstInvisibleAncestor == null;
        if (!(component instanceof Window)) {
            this.removeListeners(component.getParent());
        }
        this.firstInvisibleAncestor = component;
        if (bl) {
            this.fireAncestorRemoved(this.root, 2, (Container)component, component.getParent());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null && (string.equals("parent") || string.equals("ancestor"))) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getNewValue() != null) {
                if (jComponent == this.firstInvisibleAncestor) {
                    this.addListeners(jComponent, false);
                    if (this.firstInvisibleAncestor == null) {
                        this.fireAncestorAdded(this.root, 1, jComponent, jComponent.getParent());
                    }
                }
            } else {
                boolean bl = this.firstInvisibleAncestor == null;
                Container container = (Container)propertyChangeEvent.getOldValue();
                this.removeListeners(container);
                this.firstInvisibleAncestor = jComponent;
                if (bl) {
                    this.fireAncestorRemoved(this.root, 2, jComponent, container);
                }
            }
        }
    }
}

