/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.glassfish.external.statistics.impl;

import com.sun.org.glassfish.external.statistics.CountStatistic;
import com.sun.org.glassfish.external.statistics.impl.StatisticImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

public final class CountStatisticImpl
extends StatisticImpl
implements CountStatistic,
InvocationHandler {
    private long count = 0L;
    private final long initCount;
    private final CountStatistic cs = (CountStatistic)Proxy.newProxyInstance(CountStatistic.class.getClassLoader(), new Class[]{CountStatistic.class}, this);

    public CountStatisticImpl(long l, String string, String string2, String string3, long l2, long l3) {
        super(string, string2, string3, l3, l2);
        this.count = l;
        this.initCount = l;
    }

    public CountStatisticImpl(String string, String string2, String string3) {
        this(0L, string, string2, string3, -1L, System.currentTimeMillis());
    }

    public synchronized CountStatistic getStatistic() {
        return this.cs;
    }

    @Override
    public synchronized Map getStaticAsMap() {
        Map map = super.getStaticAsMap();
        map.put("count", this.getCount());
        return map;
    }

    @Override
    public synchronized String toString() {
        return super.toString() + NEWLINE + "Count: " + this.getCount();
    }

    @Override
    public synchronized long getCount() {
        return this.count;
    }

    public synchronized void setCount(long l) {
        this.count = l;
        this.sampleTime = System.currentTimeMillis();
    }

    public synchronized void increment() {
        ++this.count;
        this.sampleTime = System.currentTimeMillis();
    }

    public synchronized void increment(long l) {
        this.count += l;
        this.sampleTime = System.currentTimeMillis();
    }

    public synchronized void decrement() {
        --this.count;
        this.sampleTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.count = this.initCount;
        this.sampleTime = -1L;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        try {
            object2 = method.invoke(this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        catch (Exception exception) {
            throw new RuntimeException("unexpected invocation exception: " + exception.getMessage());
        }
        return object2;
    }
}

