/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.ObjectInputStreamWithLoader;
import com.sun.jmx.mbeanserver.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import sun.reflect.misc.ReflectUtil;

public class MBeanInstantiator {
    private final ModifiableClassLoaderRepository clr;
    private static final Map<String, Class<?>> primitiveClasses = Util.newMap();

    MBeanInstantiator(ModifiableClassLoaderRepository modifiableClassLoaderRepository) {
        this.clr = modifiableClassLoaderRepository;
    }

    public void testCreation(Class<?> clazz) throws NotCompliantMBeanException {
        Introspector.testCreation(clazz);
    }

    public Class<?> findClassWithDefaultLoaderRepository(String string) throws ReflectionException {
        Class<?> clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occurred during object instantiation");
        }
        try {
            if (this.clr == null) {
                throw new ClassNotFoundException(string);
            }
            clazz = this.clr.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the default loader repository");
        }
        return clazz;
    }

    public Class<?> findClass(String string, ClassLoader classLoader) throws ReflectionException {
        return MBeanInstantiator.loadClass(string, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findClass(String string, ObjectName objectName) throws ReflectionException, InstanceNotFoundException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null loader passed in parameter");
        }
        ClassLoader classLoader = null;
        MBeanInstantiator mBeanInstantiator = this;
        synchronized (mBeanInstantiator) {
            if (this.clr != null) {
                classLoader = this.clr.getClassLoader(objectName);
            }
        }
        if (classLoader == null) {
            throw new InstanceNotFoundException("The loader named " + objectName + " is not registered in the MBeanServer");
        }
        return this.findClass(string, classLoader);
    }

    public Class<?>[] findSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
        if (stringArray == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader;
        int n = stringArray.length;
        Class[] classArray = new Class[n];
        if (n == 0) {
            return classArray;
        }
        try {
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = primitiveClasses.get(stringArray[i]);
                classArray[i] = clazz != null ? clazz : (classLoader2 != null ? Class.forName(stringArray[i], false, classLoader2) : this.findClass(stringArray[i], this.getClass().getClassLoader()));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "The parameter class could not be found", classNotFoundException);
            }
            throw new ReflectionException(classNotFoundException, "The parameter class could not be found");
        }
        catch (RuntimeException runtimeException) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "Unexpected exception", runtimeException);
            }
            throw runtimeException;
        }
        return classArray;
    }

    public Object instantiate(Class<?> clazz) throws ReflectionException, MBeanException {
        Object obj;
        Constructor<?> constructor = this.findConstructor(clazz, null);
        if (constructor == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            ReflectUtil.checkPackageAccess(clazz);
            obj = constructor.newInstance(new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the MBean's empty constructor");
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's empty constructor");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's empty constructor");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new ReflectionException(new NoSuchMethodException("No constructor"), "No such constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        return obj;
    }

    public Object instantiate(Class<?> clazz, Object[] objectArray, String[] stringArray, ClassLoader classLoader) throws ReflectionException, MBeanException {
        Object t;
        Class<?>[] classArray;
        Object object;
        try {
            object = clazz.getClassLoader();
            classArray = stringArray == null ? null : this.findSignatureClasses(stringArray, (ClassLoader)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "The constructor parameter classes could not be loaded");
        }
        object = this.findConstructor(clazz, classArray);
        if (object == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            ReflectUtil.checkPackageAccess(clazz);
            t = ((Constructor)object).newInstance(objectArray);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor found"), "No such constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the MBean's constructor");
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's constructor");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's constructor");
        }
        return t;
    }

    public ObjectInputStream deserialize(ClassLoader classLoader, byte[] byArray) throws OperationsException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader;
        if (byArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (byArray.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            objectInputStreamWithLoader = new ObjectInputStreamWithLoader(byteArrayInputStream, classLoader);
        }
        catch (IOException iOException) {
            throw new OperationsException("An IOException occurred trying to de-serialize the data");
        }
        return objectInputStreamWithLoader;
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray, ClassLoader classLoader) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader;
        Object object;
        Class<?> clazz;
        if (byArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (byArray.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        if (objectName == null) {
            clazz = this.findClass(string, classLoader);
        } else {
            try {
                object = null;
                if (this.clr != null) {
                    object = this.clr.getClassLoader(objectName);
                }
                if (object == null) {
                    throw new ClassNotFoundException(string);
                }
                clazz = Class.forName(string, false, (ClassLoader)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the " + objectName.toString() + " class loader");
            }
        }
        object = new ByteArrayInputStream(byArray);
        try {
            objectInputStreamWithLoader = new ObjectInputStreamWithLoader((InputStream)object, clazz.getClassLoader());
        }
        catch (IOException iOException) {
            throw new OperationsException("An IOException occurred trying to de-serialize the data");
        }
        return objectInputStreamWithLoader;
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        return this.instantiate(string, (Object[])null, (String[])null, null);
    }

    public Object instantiate(String string, ObjectName objectName, ClassLoader classLoader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(string, objectName, null, null, classLoader);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray, ClassLoader classLoader) throws ReflectionException, MBeanException {
        Class<?> clazz = this.findClassWithDefaultLoaderRepository(string);
        return this.instantiate(clazz, objectArray, stringArray, classLoader);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray, ClassLoader classLoader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Class<?> clazz = objectName == null ? this.findClass(string, classLoader) : this.findClass(string, objectName);
        return this.instantiate(clazz, objectArray, stringArray, classLoader);
    }

    public ModifiableClassLoaderRepository getClassLoaderRepository() {
        return this.clr;
    }

    static Class<?> loadClass(String string, ClassLoader classLoader) throws ReflectionException {
        Class<?> clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occurred during object instantiation");
        }
        try {
            if (classLoader == null) {
                classLoader = MBeanInstantiator.class.getClassLoader();
            }
            clazz = classLoader != null ? Class.forName(string, false, classLoader) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded");
        }
        return clazz;
    }

    static Class<?>[] loadSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
        if (stringArray == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader == null ? MBeanInstantiator.class.getClassLoader() : classLoader;
        int n = stringArray.length;
        Class[] classArray = new Class[n];
        if (n == 0) {
            return classArray;
        }
        try {
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = primitiveClasses.get(stringArray[i]);
                classArray[i] = clazz != null ? clazz : Class.forName(stringArray[i], false, classLoader2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "The parameter class could not be found", classNotFoundException);
            }
            throw new ReflectionException(classNotFoundException, "The parameter class could not be found");
        }
        catch (RuntimeException runtimeException) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanInstantiator.class.getName(), "findSignatureClasses", "Unexpected exception", runtimeException);
            }
            throw runtimeException;
        }
        return classArray;
    }

    private Constructor<?> findConstructor(Class<?> clazz, Class<?>[] classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        for (Class clazz : new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE}) {
            primitiveClasses.put(clazz.getName(), clazz);
        }
    }
}

