/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    private String a;
    protected byte[] encodedParams;
    private String c;
    private byte[] b;

    public final Object getObject(Cipher cipher) throws BadPaddingException, IllegalBlockSizeException, ClassNotFoundException, IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cipher.doFinal(this.b));
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    public final Object getObject(Key key, String string) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, ClassNotFoundException, IOException {
        AlgorithmParameters algorithmParameters = null;
        if (this.encodedParams != null) {
            algorithmParameters = string == null ? AlgorithmParameters.getInstance(this.a) : AlgorithmParameters.getInstance(this.a, string);
            algorithmParameters.init(this.encodedParams);
        }
        try {
            Cipher cipher = string == null ? Cipher.getInstance(this.c) : Cipher.getInstance(this.c, string);
            if (algorithmParameters == null) {
                cipher.init(2, key);
            } else {
                cipher.init(2, key, algorithmParameters);
            }
            return this.getObject(cipher);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new InvalidKeyException(noSuchPaddingException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public final Object getObject(Key key) throws InvalidKeyException, NoSuchAlgorithmException, ClassNotFoundException, IOException {
        try {
            return this.getObject(key, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("Algorithm not found");
        }
    }

    public final String getAlgorithm() {
        return this.c;
    }

    protected SealedObject(SealedObject sealedObject) {
        this.b = sealedObject.b;
        this.c = sealedObject.c;
        this.encodedParams = sealedObject.encodedParams;
        this.a = sealedObject.a;
    }

    public SealedObject(Serializable serializable, Cipher cipher) throws IllegalBlockSizeException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        ((OutputStream)byteArrayOutputStream).close();
        try {
            this.b = cipher.doFinal(byteArrayOutputStream.toByteArray());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException(badPaddingException.toString());
        }
        this.c = cipher.getAlgorithm();
        AlgorithmParameters algorithmParameters = cipher.getParameters();
        if (algorithmParameters != null) {
            this.encodedParams = algorithmParameters.getEncoded();
            this.a = algorithmParameters.getAlgorithm();
        }
    }
}

