/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;

class DateTimeParser {
    private String str;
    private String trimmedString;
    private int len;
    private int fieldStart;
    private char currentSeparator;

    DateTimeParser(String string) {
        this.str = string;
        this.len = string.length();
    }

    int parseInt(int n, boolean bl, char[] cArray, boolean bl2) throws StandardException {
        int n2;
        char c;
        int n3 = 0;
        int n4 = 0;
        while (this.fieldStart < this.len && Character.isDigit(c = this.str.charAt(this.fieldStart))) {
            if (n4 >= n) {
                throw StandardException.newException("22007.S.181");
            }
            ++n4;
            n3 = n3 * 10 + Character.digit(c, 10);
            ++this.fieldStart;
        }
        if (bl ? n4 == 0 && !bl2 : n4 != n) {
            throw StandardException.newException("22007.S.181");
        }
        this.updateCurrentSeparator();
        if (cArray == null) {
            if (this.fieldStart < this.len) {
                ++this.fieldStart;
            }
        } else {
            for (n2 = 0; n2 < cArray.length; ++n2) {
                int n5;
                if (cArray[n2] != '\u0000') {
                    if (this.currentSeparator != cArray[n2]) continue;
                    ++this.fieldStart;
                    break;
                }
                for (n5 = this.fieldStart; n5 < this.len && this.str.charAt(n5) == ' '; ++n5) {
                }
                if (n5 != this.len) continue;
                this.fieldStart = n5;
                break;
            }
            if (n2 >= cArray.length) {
                throw StandardException.newException("22007.S.181");
            }
        }
        if (bl2) {
            for (n2 = n4; n2 < n; ++n2) {
                n3 *= 10;
            }
        }
        return n3;
    }

    int parseChoice(String[] stringArray) throws StandardException {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            int n2 = string.length();
            if (this.fieldStart + n2 > this.len) continue;
            for (n = 0; n < n2 && string.charAt(n) == this.str.charAt(this.fieldStart + n); ++n) {
            }
            if (n != n2) continue;
            this.fieldStart += n2;
            this.updateCurrentSeparator();
            return i;
        }
        throw StandardException.newException("22007.S.181");
    }

    private void updateCurrentSeparator() {
        if (this.fieldStart >= this.len) {
            this.currentSeparator = '\u0000';
        } else {
            this.currentSeparator = this.str.charAt(this.fieldStart);
            if (this.currentSeparator == ' ') {
                for (int i = this.fieldStart + 1; i < this.len; ++i) {
                    if (this.str.charAt(i) == ' ') continue;
                    return;
                }
                this.currentSeparator = '\u0000';
                this.fieldStart = this.len;
            }
        }
    }

    String checkEnd() throws StandardException {
        int n = this.fieldStart;
        while (this.fieldStart < this.len) {
            if (this.str.charAt(this.fieldStart) != ' ') {
                throw StandardException.newException("22007.S.181");
            }
            ++this.fieldStart;
        }
        this.currentSeparator = '\u0000';
        while (n > 0 && this.str.charAt(n - 1) == ' ') {
            --n;
        }
        this.trimmedString = n == this.len ? this.str : this.str.substring(0, n);
        return this.trimmedString;
    }

    String getTrimmedString() {
        return this.trimmedString;
    }

    char nextSeparator() {
        for (int i = this.fieldStart + 1; i < this.len; ++i) {
            char c = this.str.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            return c;
        }
        return '\u0000';
    }

    char getCurrentSeparator() {
        return this.currentSeparator;
    }
}

