/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.workspace.util;

import it.sogei.rcp.jobs.boundary.IJobCommand;
import it.sogei.rcp.jobs.boundary.RcpMonitorDialog;
import it.sogei.rcp.jobs.util.JobUtil;
import it.sogei.rcp.workspace.exception.WorkspaceException;
import it.sogei.rcp.workspace.util.IWorkspaceManager;
import it.sogei.rcp.workspace.util.internal.ImportWsJobCommand;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import org.eclipse.core.runtime.IStatus;

public class WorkspaceManager
implements IWorkspaceManager {
    @Override
    public boolean verificaWorkspace(String wsRoot) throws WorkspaceException {
        try {
            File metadataDir = new File(String.valueOf(wsRoot) + File.separator + ".metadata");
            return metadataDir.exists();
        }
        catch (Exception e) {
            LogUtil.log((String)"verifica Workspace", (int)4, (String)("errore nella verifica del workspace " + e.getMessage()));
            throw new WorkspaceException(e.getMessage());
        }
    }

    @Override
    public IStatus importaWorkspaceJob(String wsToImport) throws WorkspaceException {
        ImportWsJobCommand copyWsJob = new ImportWsJobCommand(wsToImport);
        try {
            if (!this.verificaWorkspace(wsToImport)) {
                LogUtil.log((String)"Workspace Manager - importa ws", (int)2, (String)"Il workspace non contiene la cartella .metadata");
                throw new WorkspaceException("Cartella .metadata non presente - ws non valido");
            }
            RcpMonitorDialog copyMonitorDialog = JobUtil.createDialogMonitorJob((IJobCommand)copyWsJob);
            copyMonitorDialog.show();
        }
        catch (Exception e) {
            LogUtil.log((String)"Workspace Manager - importa ws", (int)4, (String)("Errore nell'importazione del workspace " + e.getMessage()));
            throw new WorkspaceException(e.getMessage());
        }
        return copyWsJob.getJobState();
    }
}

