/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long groupHandle;
    int accelerator;
    int userId;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        int count = parent.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        this.createWidget(index);
    }

    void addAccelerator(long accelGroup) {
        this.updateAccelerator(accelGroup, true);
    }

    void addAccelerators(long accelGroup) {
        this.addAccelerator(accelGroup);
        if (this.menu != null) {
            this.menu.addAccelerators(accelGroup);
        }
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        long parentHandle;
        boolean enabled;
        this.state |= 8;
        byte[] buffer = new byte[1];
        int bits = 58;
        switch (this.style & bits) {
            case 2: {
                this.handle = OS.gtk_separator_menu_item_new();
                break;
            }
            case 16: {
                this.groupHandle = OS.gtk_radio_menu_item_new(0L);
                if (this.groupHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref(this.groupHandle);
                this.g_object_ref_sink(this.groupHandle);
                long group = OS.gtk_radio_menu_item_get_group(this.groupHandle);
                this.handle = OS.gtk_radio_menu_item_new_with_label(group, buffer);
                break;
            }
            case 32: {
                this.handle = OS.gtk_check_menu_item_new_with_label(buffer);
                break;
            }
            default: {
                this.handle = OS.gtk_image_menu_item_new_with_label(buffer);
            }
        }
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 2) == 0) {
            long label = OS.gtk_bin_get_child(this.handle);
            OS.gtk_accel_label_set_accel_widget(label, 0L);
        }
        if (!(enabled = this.gtk_widget_get_sensitive(parentHandle = this.parent.handle))) {
            OS.gtk_widget_set_sensitive(parentHandle, true);
        }
        OS.gtk_menu_shell_insert(parentHandle, this.handle, index);
        if (!enabled) {
            OS.gtk_widget_set_sensitive(parentHandle, false);
        }
        OS.gtk_widget_show(this.handle);
    }

    void fixMenus(Decorations newParent) {
        if (this.menu != null) {
            this.menu.fixMenus(newParent);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    long getAccelGroup() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return 0L;
        }
        Decorations shell = menu.parent;
        if (shell == null) {
            return 0L;
        }
        return shell.menuBar == menu ? shell.accelGroup : 0L;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!this.gtk_widget_get_mapped(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        GtkAllocation allocation = new GtkAllocation();
        this.gtk_widget_get_allocation(this.handle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = allocation.width;
        int height = allocation.height;
        return new Rectangle(x, y, width, height);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.gtk_widget_get_sensitive(this.handle);
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_check_menu_item_get_active(this.handle);
    }

    long gtk_activate(long widget) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0L;
        }
        if (!this.isEnabled()) {
            return 0L;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    long gtk_select(long item) {
        this.parent.selectedItem = this;
        this.sendEvent(30);
        return 0L;
    }

    long gtk_show_help(long widget, long helpType) {
        boolean handled = this.hooks(28);
        if (handled) {
            this.postEvent(28);
        } else {
            handled = this.parent.sendHelpEvent(helpType);
        }
        if (handled) {
            OS.gtk_menu_shell_deactivate(this.parent.handle);
            return 1L;
        }
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
        OS.g_signal_connect_closure(this.handle, OS.select, this.display.closures[44], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.closures[46], false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChildren(boolean destroy) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            if (this.menu.selectedItem == this) {
                this.menu.selectedItem = null;
            }
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        long accelGroup = this.getAccelGroup();
        if (accelGroup != 0L) {
            this.removeAccelerator(accelGroup);
        }
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        this.accelerator = 0;
        this.parent = null;
    }

    void removeAccelerator(long accelGroup) {
        this.updateAccelerator(accelGroup, false);
    }

    void removeAccelerators(long accelGroup) {
        this.removeAccelerator(accelGroup);
        if (this.menu != null) {
            this.menu.removeAccelerators(accelGroup);
        }
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    void selectRadio() {
        int index = 0;
        MenuItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        long accelGroup = this.getAccelGroup();
        if (accelGroup != 0L) {
            this.removeAccelerator(accelGroup);
        }
        this.accelerator = accelerator;
        if (accelGroup != 0L) {
            this.addAccelerator(accelGroup);
        }
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (this.gtk_widget_get_sensitive(this.handle) == enabled) {
            return;
        }
        long accelGroup = this.getAccelGroup();
        if (accelGroup != 0L) {
            this.removeAccelerator(accelGroup);
        }
        OS.gtk_widget_set_sensitive(this.handle, enabled);
        if (accelGroup != 0L) {
            this.addAccelerator(accelGroup);
        }
    }

    public void setID(int id) {
        this.checkWidget();
        if (id < 0) {
            this.error(5);
        }
        this.userId = id;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (!OS.GTK_IS_IMAGE_MENU_ITEM(this.handle)) {
            return;
        }
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
            long pixbuf = imageList.getPixbuf(imageIndex);
            long imageHandle = OS.gtk_image_new_from_pixbuf(pixbuf);
            OS.gtk_image_menu_item_set_image(this.handle, imageHandle);
            OS.gtk_widget_show(imageHandle);
        } else {
            OS.gtk_image_menu_item_set_image(this.handle, 0L);
        }
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        long accelGroup = this.getAccelGroup();
        if (accelGroup != 0L) {
            this.removeAccelerators(accelGroup);
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
            OS.g_object_ref(oldMenu.handle);
            if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
                OS.gtk_menu_item_set_submenu(this.handle, 0L);
            } else {
                OS.gtk_menu_item_remove_submenu(this.handle);
            }
        }
        if ((this.menu = menu) != null) {
            menu.cascade = this;
            OS.gtk_menu_item_set_submenu(this.handle, menu.handle);
        }
        if (accelGroup != 0L) {
            this.addAccelerators(accelGroup);
        }
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        if ((this.parent.style & 0x4000000) != 0 || !create) {
            int dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.handle, dir);
            OS.gtk_container_forall(this.handle, this.display.setDirectionProc, dir);
            if (this.menu != null) {
                this.menu._setOrientation(this.parent.style & 0x6000000);
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
        OS.gtk_check_menu_item_set_active(this.handle, selected);
        if ((this.style & 0x10) != 0) {
            OS.gtk_check_menu_item_set_active(this.groupHandle, !selected);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        String accelString = "";
        int index = string.indexOf(9);
        if (index != -1) {
            boolean isRTL = (this.parent.style & 0x4000000) != 0;
            accelString = String.valueOf(isRTL ? "" : "  ") + string.substring(index + 1, string.length()) + (isRTL ? "  " : "");
            string = string.substring(0, index);
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        long label = OS.gtk_bin_get_child(this.handle);
        if (label != 0L && OS.GTK_IS_LABEL(label)) {
            OS.gtk_label_set_text_with_mnemonic(label, buffer);
            if (!OS.GTK3 && OS.GTK_IS_ACCEL_LABEL(label)) {
                buffer = Converter.wcsToMbcs(null, accelString, true);
                long ptr = OS.g_malloc(buffer.length);
                C.memmove(ptr, buffer, (long)buffer.length);
                long oldPtr = OS.GTK_ACCEL_LABEL_GET_ACCEL_STRING(label);
                OS.GTK_ACCEL_LABEL_SET_ACCEL_STRING(label, ptr);
                if (oldPtr != 0L) {
                    OS.g_free(oldPtr);
                }
            }
        }
    }

    void updateAccelerator(long accelGroup, boolean add) {
        int keysym;
        int newKey;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        int mask = 0;
        if ((this.accelerator & 0x10000) != 0) {
            mask |= 8;
        }
        if ((this.accelerator & 0x20000) != 0) {
            mask |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            mask |= 4;
        }
        if ((newKey = Display.untranslateKey(keysym = this.accelerator & 0x100FFFF)) != 0) {
            keysym = newKey;
        } else {
            switch (keysym) {
                case 13: {
                    keysym = 65293;
                    break;
                }
                default: {
                    keysym = Display.wcsToMbcs((char)keysym);
                }
            }
        }
        if (keysym != 0) {
            if (add) {
                OS.gtk_widget_add_accelerator(this.handle, OS.activate, accelGroup, keysym, mask, 1);
            } else {
                OS.gtk_widget_remove_accelerator(this.handle, accelGroup, keysym, mask);
            }
        }
    }

    boolean updateAcceleratorText(boolean show) {
        if (this.accelerator != 0) {
            return false;
        }
        int mask = 0;
        int keysym = 0;
        if (show) {
            int accelIndex = this.text.indexOf(9);
            if (accelIndex == -1) {
                return true;
            }
            int start = accelIndex + 1;
            int plusIndex = this.text.indexOf(43, start);
            while (plusIndex != -1) {
                String maskStr = this.text.substring(start, plusIndex);
                if (maskStr.equals("Ctrl")) {
                    mask |= 4;
                }
                if (maskStr.equals("Shift")) {
                    mask |= 1;
                }
                if (maskStr.equals("Alt")) {
                    mask |= 8;
                }
                start = plusIndex + 1;
                plusIndex = this.text.indexOf(43, start);
            }
            block0 : switch (this.text.length() - start) {
                case 1: {
                    keysym = this.text.charAt(start);
                    keysym = Display.wcsToMbcs((char)keysym);
                    break;
                }
                case 2: {
                    if (this.text.charAt(start) != 'F') break;
                    switch (this.text.charAt(start + 1)) {
                        case '1': {
                            keysym = 65470;
                            break;
                        }
                        case '2': {
                            keysym = 65471;
                            break;
                        }
                        case '3': {
                            keysym = 65472;
                            break;
                        }
                        case '4': {
                            keysym = 65473;
                            break;
                        }
                        case '5': {
                            keysym = 65474;
                            break;
                        }
                        case '6': {
                            keysym = 65475;
                            break;
                        }
                        case '7': {
                            keysym = 65476;
                            break;
                        }
                        case '8': {
                            keysym = 65477;
                            break;
                        }
                        case '9': {
                            keysym = 65478;
                        }
                    }
                    break;
                }
                case 3: {
                    if (this.text.charAt(start) != 'F' || this.text.charAt(start + 1) != '1') break;
                    switch (this.text.charAt(start + 2)) {
                        case '0': {
                            keysym = 65479;
                            break block0;
                        }
                        case '1': {
                            keysym = 65480;
                            break block0;
                        }
                        case '2': {
                            keysym = 65481;
                            break block0;
                        }
                        case '3': {
                            keysym = 65482;
                            break block0;
                        }
                        case '4': {
                            keysym = 65483;
                            break block0;
                        }
                        case '5': {
                            keysym = 65484;
                        }
                    }
                }
            }
        }
        if (keysym != 0) {
            long accelGroup = this.getAccelGroup();
            if (show) {
                OS.gtk_widget_add_accelerator(this.handle, OS.activate, accelGroup, keysym, mask, 1);
            } else {
                OS.gtk_widget_remove_accelerator(this.handle, accelGroup, keysym, mask);
            }
        }
        return keysym != 0;
    }
}

