/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateFactory;
import java.util.Date;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CachedCertificatesHelper {
    CertPath path = null;
    Date tm = null;
    boolean signedJNLP = false;
    public static boolean ENABLED = false;

    public CachedCertificatesHelper(Date date, CertPath certPath) {
        this.tm = date;
        this.path = certPath;
    }

    public CachedCertificatesHelper(Date date, String string, boolean bl) {
        try {
            if (string != null) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byte[] byArray = bASE64Decoder.decodeBuffer(string);
                this.path = certificateFactory.generateCertPath(new ByteArrayInputStream(byArray));
                this.tm = date;
                this.signedJNLP = bl;
            }
        }
        catch (Exception exception) {
            Trace.println("Failed to init CodeSignerHelper", TraceLevel.SECURITY);
            Trace.ignored(exception);
        }
    }

    public boolean isSignedJNLP() {
        return this.signedJNLP;
    }

    public CertPath getCertPath() {
        return this.path;
    }

    public String exportCertificatesToBase64() {
        if (this.path != null) {
            try {
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                return bASE64Encoder.encode(this.path.getEncoded());
            }
            catch (Exception exception) {
                Trace.println("Failed to export certificats in BASE64 form", TraceLevel.SECURITY);
            }
        }
        return null;
    }

    public Date getTimestamp() {
        return this.tm;
    }
}

