/*
 * Decompiled with CFR 0.152.
 */
package demo.smime.ess;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SignerInfo;
import iaik.smime.CryptoContent;
import iaik.smime.SMimeSignerInfo;
import iaik.smime.SignedContent;
import iaik.smime.ess.ContentIdentifier;
import iaik.smime.ess.ESSException;
import iaik.smime.ess.EntityIdentifier;
import iaik.smime.ess.MLData;
import iaik.smime.ess.MLExpansionHistory;
import iaik.smime.ess.MLReceiptPolicy;
import iaik.smime.ess.Receipt;
import iaik.smime.ess.ReceiptContent;
import iaik.smime.ess.ReceiptRequest;
import iaik.smime.ess.ReceiptsFrom;
import iaik.smime.ess.utils.SenderAndReceiptContentDigest;
import iaik.smime.ess.utils.SignedReceipt;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SignedReceiptDemo {
    PrivateKey signerPrivateKeyOfMLA_;
    X509Certificate[] signerCertificatesOfMLA_;
    PrivateKey recipientPrivateKey_;
    X509Certificate encryptionCertOfRecipient_;
    X509Certificate recipientCertificate_;
    X509Certificate[] recipientCertificates_;
    PrivateKey signerPrivateKey_;
    X509Certificate encryptionCertOfSigner_;
    X509Certificate signerCertificate_;
    X509Certificate[] signerCertificates_;
    String host_ = "mailhost";
    String mlaAddress_;
    String recipientAddress_;
    String senderAddress_ = "\"" + this.senderName_ + "\" <smimetest@iaik.at>";
    String mlaName_ = "IAIK Demo ML Agent";
    String recipientName_ = "IAIK Demo Recipient";
    String senderName_ = "IAIK Demo Sender";
    static final boolean a = false;

    public void verifyReceiptContent(Message message) throws Exception {
        ReceiptContent receiptContent = (ReceiptContent)message.getContent();
        Receipt receipt = (Receipt)receiptContent.getContent();
        System.out.println("\nReceipt received:");
        System.out.println(receipt);
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = receiptContent.verify();
            System.out.println("This receipt content is signed from: " + x509Certificate.getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.err.println("Signature verification error!");
            throw signatureException;
        }
        try {
            SenderAndReceiptContentDigest senderAndReceiptContentDigest = SenderAndReceiptContentDigest.validateReceiptContent((ReceiptContent)receiptContent);
            SenderAndReceiptContentDigest.removeEntry((SenderAndReceiptContentDigest)senderAndReceiptContentDigest);
        }
        catch (ESSException eSSException) {
            System.err.println("Signed Receipt validation error!");
            throw eSSException;
        }
        System.out.println("ReceiptContent successful validated!");
    }

    public void test(boolean bl, boolean bl2) {
        try {
            SignedContent signedContent;
            Session session = DemoUtil.getSession();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            System.out.println("Creating implicit signed message with receipt request.");
            Message message = this.createSignedMessageWithReceiptRequest(session, bl, byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            byteArrayOutputStream.reset();
            if (bl2) {
                System.out.println("MLA: parsing received original message.");
                signedContent = (SignedContent)message.getContent();
                System.out.println("MLA: Verifying signature.");
                X509Certificate x509Certificate = signedContent.verify();
                System.out.println("MLA: This message is signed from: " + x509Certificate.getSubjectDN());
                System.out.println("MLA: Creating new signed message with MLExpansionHistory attribute.");
                SignedContent signedContent2 = new SignedContent((CryptoContent)signedContent, bl);
                signedContent2.setCertificates((Certificate[])this.signerCertificatesOfMLA_);
                try {
                    SMimeSignerInfo sMimeSignerInfo = new SMimeSignerInfo(this.signerCertificatesOfMLA_[0], AlgorithmID.sha1, AlgorithmID.dsaWithSHA1, this.signerPrivateKeyOfMLA_);
                    MLExpansionHistory mLExpansionHistory = SignedReceiptDemo.createMLExpansionHistory(this.signerCertificatesOfMLA_[0], new Date(), this.mlaAddress_);
                    sMimeSignerInfo.addSignedAttribute(new Attribute((AttributeValue)mLExpansionHistory));
                    signedContent2.addSigner((SignerInfo)sMimeSignerInfo);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new MessagingException("Algorithm not supported: " + noSuchAlgorithmException.getMessage(), (Exception)noSuchAlgorithmException);
                }
                message = this.createMessage(session, this.mlaAddress_, this.recipientAddress_, "IAIK-S/MIME: MLA with ReceiptRequest");
                message.setContent((Object)signedContent2, signedContent2.getContentType());
                signedContent2.setHeaders((Part)message);
                message.saveChanges();
                message.writeTo((OutputStream)byteArrayOutputStream);
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            }
            byteArrayOutputStream.reset();
            signedContent = this.createMessageWithSignedReceipt(session, message);
            signedContent.saveChanges();
            signedContent.writeTo((OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            message = new MimeMessage(null, (InputStream)byteArrayInputStream);
            System.out.println("\nNow getting and verifying signed receipt:");
            this.verifyReceiptContent(message);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void storeDigestValues(SignedContent signedContent) throws ESSException {
        SignerInfo signerInfo = signedContent.getSignerInfos()[0];
        SenderAndReceiptContentDigest.storeEntry((SenderAndReceiptContentDigest)new SenderAndReceiptContentDigest(signerInfo));
    }

    public void start() {
        boolean bl = true;
        boolean bl2 = false;
        System.out.println("Testing receipt request - signed receipt (all implicit)");
        this.test(bl, bl2);
        bl2 = true;
        System.out.println("Testing receipt request - MLA - signed receipt (all implicit)");
        this.test(bl, bl2);
        bl = false;
        bl2 = false;
        System.out.println("Testing receipt request - signed receipt (all explicit)");
        this.test(bl, bl2);
        bl2 = true;
        System.out.println("Testing receipt request - MLA - signed receipt (all explicit)");
        this.test(bl, bl2);
        System.out.println("Ready!");
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            DemoUtil.initSMimeDemos();
            new SignedReceiptDemo().start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Util.waitKey();
    }

    private static void a(Message message) throws Exception {
        System.out.println("******************************************************************");
        System.out.println("Message dump: \n");
        message.writeTo((OutputStream)System.out);
        System.out.println("******************************************************************");
    }

    public Message createSignedMessageWithReceiptRequest(Session session, boolean bl, OutputStream outputStream) throws Exception {
        Message message = this.createMessage(session, this.senderAddress_, this.recipientAddress_, "IAIK-S/MIME: ReceiptRequest");
        SignedContent signedContent = new SignedContent(bl, bl ? "signed-data" : null);
        signedContent.setText("This is a signed message with a ReceiptRequest.");
        signedContent.setCertificates((Certificate[])this.signerCertificates_);
        SMimeSignerInfo sMimeSignerInfo = new SMimeSignerInfo(this.signerCertificate_, AlgorithmID.sha1, AlgorithmID.rsaEncryption, this.signerPrivateKey_, this.encryptionCertOfSigner_, true);
        ReceiptRequest receiptRequest = this.createReceiptRequest(this.signerCertificate_.getPublicKey(), message.getSentDate(), this.senderAddress_);
        sMimeSignerInfo.addSignedAttribute(new Attribute((AttributeValue)receiptRequest));
        signedContent.addSigner((SignerInfo)sMimeSignerInfo);
        message.setContent((Object)signedContent, signedContent.getContentType());
        signedContent.setHeaders((Part)message);
        message.saveChanges();
        message.writeTo(outputStream);
        this.storeDigestValues(signedContent);
        return message;
    }

    public ReceiptRequest createReceiptRequest(PublicKey publicKey, Date date, String string) {
        ReceiptsFrom receiptsFrom = new ReceiptsFrom(0);
        String[] stringArray = new String[]{string};
        ContentIdentifier contentIdentifier = new ContentIdentifier(publicKey, date, null);
        ReceiptRequest receiptRequest = new ReceiptRequest(contentIdentifier, receiptsFrom, stringArray);
        return receiptRequest;
    }

    public Message createMessageWithSignedReceipt(Session session, Message message) throws Exception {
        SignedReceipt signedReceipt = new SignedReceipt((Part)message, this.recipientAddress_, (OutputStream)System.out);
        String string = "IAIK-S/MIME: Signed Receipt";
        MimeMessage mimeMessage = signedReceipt.createReceiptMessage(this.recipientPrivateKey_, this.recipientCertificates_, this.recipientCertificates_[0], AlgorithmID.sha1, AlgorithmID.rsaEncryption, this.encryptionCertOfRecipient_, true, session, string);
        return mimeMessage;
    }

    public Message createMessage(Session session, String string, String string2, String string3) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setFrom((Address)new InternetAddress(string));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string2, (boolean)false));
        mimeMessage.setSentDate(new Date());
        return mimeMessage;
    }

    public static MLExpansionHistory createMLExpansionHistory(X509Certificate x509Certificate, Date date, String string) {
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
        MLData mLData = new MLData(new EntityIdentifier((CertificateIdentifier)issuerAndSerialNumber), date);
        MLReceiptPolicy mLReceiptPolicy = new MLReceiptPolicy(2);
        mLReceiptPolicy.setRecipientList(new String[]{string});
        mLData.setMLReceiptPolicy(mLReceiptPolicy);
        return new MLExpansionHistory(mLData);
    }

    public SignedReceiptDemo() {
        this.recipientAddress_ = "\"" + this.recipientName_ + "\" <smimetest@iaik.at>";
        this.mlaAddress_ = "\"" + this.mlaName_ + "\" <smimetest@iaik.tugraz.at>";
        System.out.println();
        System.out.println("******************************************************************************************");
        System.out.println("*                               SignedReceiptDemo                                        *");
        System.out.println("*       (shows the usage of the IAIK-CMS library for handling ESS signed receipts)       *");
        System.out.println("******************************************************************************************");
        System.out.println();
        this.signerCertificates_ = CMSKeyStore.getCertificateChain(0, 1);
        this.signerPrivateKey_ = CMSKeyStore.getPrivateKey(0, 1);
        this.signerCertificate_ = this.signerCertificates_[0];
        this.encryptionCertOfSigner_ = CMSKeyStore.getCertificateChain(0, 4)[0];
        this.recipientCertificates_ = CMSKeyStore.getCertificateChain(0, 0);
        this.recipientPrivateKey_ = CMSKeyStore.getPrivateKey(0, 0);
        this.recipientCertificate_ = this.recipientCertificates_[0];
        this.encryptionCertOfRecipient_ = CMSKeyStore.getCertificateChain(0, 3)[0];
        this.signerCertificatesOfMLA_ = CMSKeyStore.getCertificateChain(1, 1);
        this.signerPrivateKeyOfMLA_ = CMSKeyStore.getPrivateKey(1, 1);
        X509Certificate[] x509CertificateArray = new X509Certificate[this.signerCertificates_.length + 1];
        System.arraycopy(this.signerCertificates_, 0, x509CertificateArray, 0, this.signerCertificates_.length);
        x509CertificateArray[this.signerCertificates_.length] = this.encryptionCertOfSigner_;
        this.signerCertificates_ = x509CertificateArray;
        x509CertificateArray = new X509Certificate[this.recipientCertificates_.length + 1];
        System.arraycopy(this.recipientCertificates_, 0, x509CertificateArray, 0, this.recipientCertificates_.length);
        x509CertificateArray[this.recipientCertificates_.length] = this.encryptionCertOfRecipient_;
        this.recipientCertificates_ = x509CertificateArray;
    }
}

