/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class PKCS7CMSTestEncryptedContentInfo {
    SecureRandom random;
    PrivateKey user2_pk;
    X509Certificate user2;
    PrivateKey user1_pk;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("\nEnvelopedDataStream demo for algorithm ARCFOUR [create]:\n");
            byte[] byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.arcfour, 128);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEnvelopedDataStream demo for algorithm RC2 [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.rc2_CBC, 128);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nEnvelopedDataStream demo for algorithm CAST5_CBC [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.cast5_CBC, 128);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("Test compatibility to PKCS#7....");
            System.out.println("\nCMS EnvelopedDataStream demo for algorithm ARCFOUR [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.arcfour, 128);
            System.out.println("\nPKCS#7 EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getPKCS7EnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS#7 EnvelopedDataStream demo for algorithm ARCFOUR [create]:\n");
            byArray3 = this.createPKCS7EnvelopedDataStream(byArray, AlgorithmID.arcfour, 128);
            System.out.println("\nCMS EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCMS EnvelopedDataStream demo for algorithm RC2 [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.rc2_CBC, 128);
            System.out.println("\nPKCS#7 EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getPKCS7EnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS#7 EnvelopedDataStream demo for algorithm RC2 [create]:\n");
            byArray3 = this.createPKCS7EnvelopedDataStream(byArray, AlgorithmID.rc2_CBC, 128);
            System.out.println("\nCMS EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCMS EnvelopedDataStream demo for algorithm CAST5_CBC [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray, AlgorithmID.cast5_CBC, 128);
            System.out.println("\nPKCS#7 EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getPKCS7EnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS#7 EnvelopedDataStream demo for algorithm CAST5_CBC [create]:\n");
            byArray3 = this.createPKCS7EnvelopedDataStream(byArray, AlgorithmID.cast5_CBC, 128);
            System.out.println("\nCMS EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new PKCS7CMSTestEncryptedContentInfo().start();
        System.in.read();
    }

    public byte[] getPKCS7EnvelopedDataStream(byte[] byArray, PrivateKey privateKey, int n) throws Exception {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        AlgorithmParameterSpec algorithmParameterSpec = null;
        iaik.pkcs.pkcs7.RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getIssuerAndSerialNumber());
            ++n2;
        }
        SecretKey secretKey = recipientInfoArray[n].decryptKey(this.user1_pk);
        EncryptedContentInfoStream encryptedContentInfoStream = (EncryptedContentInfoStream)envelopedDataStream.getEncryptedContentInfo();
        AlgorithmID algorithmID = encryptedContentInfoStream.getContentEncryptionAlgorithm();
        System.out.println("Content Encryption Algorithm: " + algorithmID);
        if (algorithmID.equals((Object)AlgorithmID.rc2_CBC)) {
            object = (SEQUENCE)algorithmID.getParameter();
            OCTET_STRING cfr_ignored_0 = (OCTET_STRING)object.getComponentAt(1);
            int n3 = ((BigInteger)object.getComponentAt(0).getValue()).intValue();
            int n4 = 32;
            switch (n3) {
                case 160: {
                    n4 = 40;
                    break;
                }
                case 120: {
                    n4 = 64;
                    break;
                }
                case 58: {
                    n4 = 128;
                    break;
                }
                default: {
                    throw new Exception("Invalid rc2ParameterVersion " + n3 + "!");
                }
            }
            algorithmParameterSpec = new RC2ParameterSpec(n4, (byte[])object.getComponentAt(1).getValue());
        } else if (algorithmID.equals((Object)AlgorithmID.rc5_CBC)) {
            object = (OCTET_STRING)algorithmID.getParameter();
            algorithmParameterSpec = new IvParameterSpec((byte[])object.getValue());
        } else if (algorithmID.equals((Object)AlgorithmID.arcfour)) {
            algorithmParameterSpec = null;
        } else if (algorithmID.equals((Object)AlgorithmID.cast5_CBC)) {
            object = algorithmID.getParameter();
            algorithmParameterSpec = object.isA(ASN.SEQUENCE) ? new IvParameterSpec((byte[])object.getComponentAt(0).getValue()) : new IvParameterSpec((byte[])object.getValue());
        } else {
            throw new Exception("Algorithm " + algorithmID + " not supportted for this test!");
        }
        encryptedContentInfoStream.setupCipher((Key)secretKey, algorithmParameterSpec);
        object = encryptedContentInfoStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)object, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, PrivateKey privateKey, int n) throws Exception {
        Object object;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iaik.cms.EnvelopedDataStream envelopedDataStream = new iaik.cms.EnvelopedDataStream((InputStream)byteArrayInputStream);
        AlgorithmParameterSpec algorithmParameterSpec = null;
        RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        SecretKey secretKey = recipientInfoArray[n].decryptKey((Key)this.user1_pk);
        iaik.cms.EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        AlgorithmID algorithmID = encryptedContentInfoStream.getContentEncryptionAlgorithm();
        System.out.println("Content Encryption Algorithm: " + algorithmID);
        if (algorithmID.equals((Object)AlgorithmID.rc2_CBC)) {
            object = (SEQUENCE)algorithmID.getParameter();
            OCTET_STRING cfr_ignored_0 = (OCTET_STRING)object.getComponentAt(1);
            int n3 = ((BigInteger)object.getComponentAt(0).getValue()).intValue();
            int n4 = 32;
            switch (n3) {
                case 160: {
                    n4 = 40;
                    break;
                }
                case 120: {
                    n4 = 64;
                    break;
                }
                case 58: {
                    n4 = 128;
                    break;
                }
                default: {
                    throw new Exception("Invalid rc2ParameterVersion " + n3 + "!");
                }
            }
            algorithmParameterSpec = new RC2ParameterSpec(n4, (byte[])object.getComponentAt(1).getValue());
        } else if (algorithmID.equals((Object)AlgorithmID.rc5_CBC)) {
            object = (OCTET_STRING)algorithmID.getParameter();
            algorithmParameterSpec = new IvParameterSpec((byte[])object.getValue());
        } else if (algorithmID.equals((Object)AlgorithmID.arcfour)) {
            algorithmParameterSpec = null;
        } else if (algorithmID.equals((Object)AlgorithmID.cast5_CBC)) {
            object = algorithmID.getParameter();
            algorithmParameterSpec = object.isA(ASN.SEQUENCE) ? new IvParameterSpec((byte[])object.getComponentAt(0).getValue()) : new IvParameterSpec((byte[])object.getValue());
        } else {
            throw new Exception("Algorithm " + algorithmID + " not supportted for this test!");
        }
        encryptedContentInfoStream.setupCipher((Key)secretKey, algorithmParameterSpec);
        object = encryptedContentInfoStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier((InputStream)object, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public byte[] createPKCS7EnvelopedDataStream(byte[] byArray, AlgorithmID algorithmID, int n) throws Exception {
        SEQUENCE sEQUENCE;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AlgorithmID algorithmID2 = (AlgorithmID)algorithmID.clone();
        AlgorithmParameterSpec algorithmParameterSpec = null;
        KeyGenerator keyGenerator = null;
        SecretKey secretKey = null;
        byte[] byArray2 = new byte[8];
        this.random.nextBytes(byArray2);
        int n2 = 58;
        if (algorithmID2.equals((Object)AlgorithmID.rc2_CBC)) {
            keyGenerator = KeyGenerator.getInstance("RC2");
            switch (n) {
                case 40: {
                    n2 = 160;
                    break;
                }
                case 64: {
                    n2 = 120;
                    break;
                }
                default: {
                    n2 = 58;
                    n = 128;
                }
            }
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new INTEGER(n2));
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray2));
            algorithmID2.setParameter((ASN1Object)sEQUENCE);
            algorithmParameterSpec = new RC2ParameterSpec(n, byArray2);
        } else if (algorithmID2.equals((Object)AlgorithmID.arcfour)) {
            keyGenerator = KeyGenerator.getInstance("ARCFOUR");
            algorithmParameterSpec = null;
        } else if (algorithmID2.equals((Object)AlgorithmID.cast5_CBC)) {
            keyGenerator = KeyGenerator.getInstance("CAST5");
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray2));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(n));
            algorithmID2.setParameter((ASN1Object)sEQUENCE);
            algorithmParameterSpec = new IvParameterSpec(byArray2);
        } else {
            throw new Exception("Algorithm " + algorithmID2 + " not supportted for this test!");
        }
        keyGenerator.init(n);
        secretKey = keyGenerator.generateKey();
        sEQUENCE = new EncryptedContentInfoStream(ObjectID.pkcs7_data, (InputStream)byteArrayInputStream);
        sEQUENCE.setupCipher(algorithmID2, (Key)secretKey, algorithmParameterSpec);
        iaik.pkcs.pkcs7.RecipientInfo[] recipientInfoArray = new iaik.pkcs.pkcs7.RecipientInfo[2];
        recipientInfoArray[0] = new iaik.pkcs.pkcs7.RecipientInfo((java.security.cert.X509Certificate)this.user1, AlgorithmID.rsaEncryption);
        recipientInfoArray[0].encryptKey(secretKey);
        recipientInfoArray[1] = new iaik.pkcs.pkcs7.RecipientInfo((java.security.cert.X509Certificate)this.user2, AlgorithmID.rsaEncryption);
        recipientInfoArray[1].encryptKey(secretKey);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream(recipientInfoArray, (EncryptedContentInfoStream)sEQUENCE);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.writeTo((OutputStream)byteArrayOutputStream, 2048);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return byArray3;
    }

    public byte[] createEnvelopedDataStream(byte[] byArray, AlgorithmID algorithmID, int n) throws Exception {
        SEQUENCE sEQUENCE;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        AlgorithmID algorithmID2 = (AlgorithmID)algorithmID.clone();
        AlgorithmParameterSpec algorithmParameterSpec = null;
        KeyGenerator keyGenerator = null;
        SecretKey secretKey = null;
        byte[] byArray2 = new byte[8];
        this.random.nextBytes(byArray2);
        int n2 = 58;
        if (algorithmID2.equals((Object)AlgorithmID.rc2_CBC)) {
            keyGenerator = KeyGenerator.getInstance("RC2");
            switch (n) {
                case 40: {
                    n2 = 160;
                    break;
                }
                case 64: {
                    n2 = 120;
                    break;
                }
                default: {
                    n2 = 58;
                    n = 128;
                }
            }
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new INTEGER(n2));
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray2));
            algorithmID2.setParameter((ASN1Object)sEQUENCE);
            algorithmParameterSpec = new RC2ParameterSpec(n, byArray2);
        } else if (algorithmID2.equals((Object)AlgorithmID.arcfour)) {
            keyGenerator = KeyGenerator.getInstance("ARCFOUR");
            algorithmParameterSpec = null;
        } else if (algorithmID2.equals((Object)AlgorithmID.cast5_CBC)) {
            keyGenerator = KeyGenerator.getInstance("CAST5");
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray2));
            sEQUENCE.addComponent((ASN1Object)new INTEGER(n));
            algorithmID2.setParameter((ASN1Object)sEQUENCE);
            algorithmParameterSpec = new IvParameterSpec(byArray2);
        } else {
            throw new Exception("Algorithm " + algorithmID2 + " not supportted for this test!");
        }
        keyGenerator.init(n);
        secretKey = keyGenerator.generateKey();
        sEQUENCE = new iaik.cms.EncryptedContentInfoStream(ObjectID.pkcs7_data, (InputStream)byteArrayInputStream);
        sEQUENCE.setupCipher(algorithmID2, (Key)secretKey, algorithmParameterSpec);
        RecipientInfo[] recipientInfoArray = new RecipientInfo[2];
        recipientInfoArray[0] = new KeyTransRecipientInfo(this.user1, AlgorithmID.rsaEncryption);
        recipientInfoArray[0].encryptKey(secretKey);
        recipientInfoArray[1] = new KeyTransRecipientInfo(this.user2, AlgorithmID.rsaEncryption);
        recipientInfoArray[1].encryptKey(secretKey);
        iaik.cms.EnvelopedDataStream envelopedDataStream = new iaik.cms.EnvelopedDataStream(recipientInfoArray, (iaik.cms.EncryptedContentInfoStream)sEQUENCE);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.writeTo((OutputStream)byteArrayOutputStream, 2048);
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return byArray3;
    }

    public PKCS7CMSTestEncryptedContentInfo() throws IOException {
        System.out.println();
        System.out.println("********************************************************************************************************");
        System.out.println("*                           PKCS7CMSTestEncryptedContentInfo demo                                      *");
        System.out.println("* (tests the CMS EncryptedContentInfo against the IAIK-JCE PKCS#7 EncryptedContentInfo implementation) *");
        System.out.println("********************************************************************************************************");
        System.out.println();
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 4);
        this.user1 = x509CertificateArray[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(0, 4);
        this.user2 = CMSKeyStore.getCertificateChain(0, 6)[0];
        this.user2_pk = CMSKeyStore.getPrivateKey(0, 6);
        this.random = SecRandom.getDefault();
    }
}

