/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.EnvelopedData;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;

public class PKCS7CMSEnvelopedData {
    SecureRandom random;
    PrivateKey user2_pk;
    X509Certificate user2;
    PrivateKey user1_pk;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nCMS EnvelopedDataStream demo [create]:\n");
            byte[] byArray3 = this.createEnvelopedDataStream(byArray);
            System.out.println("\nCMS EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("Testing compatibility to PKCS#7...");
            System.out.println("\nPKCS7 EnvelopedDataStream demo [create]:\n");
            byArray3 = this.createPKCS7EnvelopedDataStream(byArray);
            System.out.println("\nCMS EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS7 EnvelopedDataStream demo [create]:\n");
            byArray3 = this.createPKCS7EnvelopedDataStream(byArray);
            System.out.println("\nCMS EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCMS EnvelopedDataStream demo [create]:\n");
            byArray3 = this.createEnvelopedDataStream(byArray);
            System.out.println("\nPKCS7 EnvelopedDataStream demo [parse]:\n");
            byArray2 = this.getPKCS7EnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            ASN1Object aSN1Object = null;
            aSN1Object = null;
            System.out.println("\nCMS EnvelopedData demo [create]:\n");
            aSN1Object = this.createEnvelopedData(byArray);
            System.out.println("\nCMS EnvelopedData demo [parse]:\n");
            byArray2 = this.getEnvelopedData(aSN1Object, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("Testing compatibility to PKCS#7...");
            aSN1Object = null;
            System.out.println("\nPKCS7 EnvelopedData demo [create]:\n");
            aSN1Object = this.createPKCS7EnvelopedData(byArray);
            System.out.println("\nCMS EnvelopedData demo [parse]:\n");
            byArray2 = this.getEnvelopedData(aSN1Object, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            aSN1Object = null;
            System.out.println("\nCMS EnvelopedData demo [create]:\n");
            aSN1Object = this.createPKCS7EnvelopedData(byArray);
            System.out.println("\nPKCS7 EnvelopedData demo [parse]:\n");
            byArray2 = this.getPKCS7EnvelopedData(aSN1Object, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new PKCS7CMSEnvelopedData().start();
        System.in.read();
    }

    public byte[] getPKCS7EnvelopedDataStream(byte[] byArray, PrivateKey privateKey, int n) throws IOException, PKCSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = (EncryptedContentInfoStream)envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        iaik.pkcs.pkcs7.RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getIssuerAndSerialNumber());
            ++n2;
        }
        try {
            envelopedDataStream.setupCipher(privateKey, n);
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException("Private key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getPKCS7EnvelopedData(ASN1Object aSN1Object, PrivateKey privateKey, int n) throws IOException, PKCSException {
        iaik.pkcs.pkcs7.EnvelopedData envelopedData = new iaik.pkcs.pkcs7.EnvelopedData(aSN1Object);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        iaik.pkcs.pkcs7.RecipientInfo[] recipientInfoArray = envelopedData.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getIssuerAndSerialNumber());
            ++n2;
        }
        try {
            envelopedData.setupCipher(privateKey, n);
            return envelopedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKCSException("Private key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, PrivateKey privateKey, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iaik.cms.EnvelopedDataStream envelopedDataStream = new iaik.cms.EnvelopedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        iaik.cms.EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            envelopedDataStream.setupCipher((Key)privateKey, n);
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] getEnvelopedData(ASN1Object aSN1Object, PrivateKey privateKey, int n) throws CMSException {
        EnvelopedData envelopedData = new EnvelopedData(aSN1Object);
        System.out.println("Information about the encrypted data:");
        iaik.cms.EncryptedContentInfo encryptedContentInfo = (iaik.cms.EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedData.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient " + (n2 + 1) + ":");
            System.out.println(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            envelopedData.setupCipher((Key)privateKey, n);
            return envelopedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("Private key error: " + invalidKeyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] createPKCS7EnvelopedDataStream(byte[] byArray) throws IOException, PKCSException {
        Object object;
        EnvelopedDataStream envelopedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("No implementation for Triple-DES-CBC.");
        }
        try {
            object = new iaik.pkcs.pkcs7.RecipientInfo[]{new iaik.pkcs.pkcs7.RecipientInfo((java.security.cert.X509Certificate)this.user1, AlgorithmID.rsaEncryption), new iaik.pkcs.pkcs7.RecipientInfo((java.security.cert.X509Certificate)this.user2, AlgorithmID.rsaEncryption)};
            envelopedDataStream.setRecipientInfos((iaik.pkcs.pkcs7.RecipientInfo[])object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Algorithm not supported: " + noSuchAlgorithmException.toString());
        }
        object = new ByteArrayOutputStream();
        envelopedDataStream.writeTo((OutputStream)object, 2048);
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    public ASN1Object createPKCS7EnvelopedData(byte[] byArray) throws IOException, PKCSException {
        iaik.pkcs.pkcs7.EnvelopedData envelopedData;
        try {
            envelopedData = new iaik.pkcs.pkcs7.EnvelopedData(byArray, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("No implementation for Triple-DES-CBC.");
        }
        try {
            iaik.pkcs.pkcs7.RecipientInfo[] recipientInfoArray = new iaik.pkcs.pkcs7.RecipientInfo[]{new iaik.pkcs.pkcs7.RecipientInfo((java.security.cert.X509Certificate)this.user1, AlgorithmID.rsaEncryption), new iaik.pkcs.pkcs7.RecipientInfo((java.security.cert.X509Certificate)this.user2, AlgorithmID.rsaEncryption)};
            envelopedData.setRecipientInfos(recipientInfoArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("Algorithm not supported: " + noSuchAlgorithmException.toString());
        }
        return envelopedData.toASN1Object();
    }

    public byte[] createEnvelopedDataStream(byte[] byArray) throws IOException, CMSException {
        iaik.cms.EnvelopedDataStream envelopedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            envelopedDataStream = new iaik.cms.EnvelopedDataStream((InputStream)byteArrayInputStream, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        KeyTransRecipientInfo[] keyTransRecipientInfoArray = new KeyTransRecipientInfo[]{new KeyTransRecipientInfo(this.user1, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2, AlgorithmID.rsaEncryption)};
        envelopedDataStream.setRecipientInfos((RecipientInfo[])keyTransRecipientInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.writeTo((OutputStream)byteArrayOutputStream, 2048);
        return byteArrayOutputStream.toByteArray();
    }

    public ASN1Object createEnvelopedData(byte[] byArray) throws CMSException {
        EnvelopedData envelopedData;
        try {
            envelopedData = new EnvelopedData(byArray, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        KeyTransRecipientInfo[] keyTransRecipientInfoArray = new KeyTransRecipientInfo[]{new KeyTransRecipientInfo(this.user1, AlgorithmID.rsaEncryption), new KeyTransRecipientInfo(this.user2, AlgorithmID.rsaEncryption)};
        envelopedData.setRecipientInfos((RecipientInfo[])keyTransRecipientInfoArray);
        return envelopedData.toASN1Object();
    }

    public PKCS7CMSEnvelopedData() throws IOException {
        System.out.println();
        System.out.println("***********************************************************************************************");
        System.out.println("*                                 PKCS7CMSEnvelopedData demo                                  *");
        System.out.println("* (tests the CMS EnvelopedData against the IAIK-JCE PKCS#7 EnvelopedData type implementation) *");
        System.out.println("***********************************************************************************************");
        System.out.println();
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 4);
        this.user1 = x509CertificateArray[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(0, 4);
        this.user2 = CMSKeyStore.getCertificateChain(0, 6)[0];
        this.user2_pk = CMSKeyStore.getPrivateKey(0, 6);
        this.random = SecRandom.getDefault();
    }
}

