/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.Content;
import iaik.cms.ContentInfo;
import iaik.cms.ContentInfoStream;
import iaik.cms.ContentStream;
import iaik.cms.EncryptedContentInfo;
import iaik.cms.EncryptedContentInfoStream;
import iaik.cms.EnvelopedData;
import iaik.cms.EnvelopedDataStream;
import iaik.cms.KeyTransRecipientInfo;
import iaik.cms.RecipientInfo;
import iaik.pkcs.pkcs1.MGF1ParameterSpec;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAOaepParameterSpec;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class OaepEnvelopedData {
    PrivateKey user2_pk;
    X509Certificate user2;
    PrivateKey user1_pk;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos (OAEP)");
            System.out.println("==================================");
            System.out.println("\nEnvelopedDataStream demo [create]:\n");
            byte[] byArray3 = this.createEnvelopedDataStream(byArray);
            System.out.println("\nEnvelopedDataStream demo [parse]:\n");
            System.out.println("\nDecrypt for recipient 1:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for recipient 1:\n");
            byArray2 = this.getEnvelopedDataStream(byArray3, this.user2_pk, 1);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos (OAEP)");
            System.out.println("========================================");
            System.out.println("\nEnvelopedData demo [create]:\n");
            byArray3 = this.createEnvelopedData(byArray);
            System.out.println("\nEnvelopedData demo [parse]:\n");
            System.out.println("\nDecrypt for recipient 1:\n");
            byArray2 = this.getEnvelopedData(byArray3, this.user1_pk, 0);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nDecrypt for recipient 2:\n");
            byArray2 = this.getEnvelopedData(byArray3, this.user2_pk, 1);
            System.out.print("\nDecrypted content: ");
            System.out.println(new String(byArray2));
            System.out.println("Ready!");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new OaepEnvelopedData().start();
        System.in.read();
    }

    public byte[] getEnvelopedDataStream(byte[] byArray, PrivateKey privateKey, int n) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream);
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfoStream encryptedContentInfoStream = envelopedDataStream.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfoStream.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfoStream.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient: " + (n2 + 1));
            System.out.print(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            envelopedDataStream.setupCipher((Key)privateKey, n);
            InputStream inputStream = envelopedDataStream.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
            streamCopier.copyStream();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("Private key error: " + invalidKeyException.getMessage());
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
            return null;
        }
    }

    public byte[] getEnvelopedData(byte[] byArray, PrivateKey privateKey, int n) throws IOException, CMSException {
        EnvelopedData envelopedData = new EnvelopedData((InputStream)new ByteArrayInputStream(byArray));
        System.out.println("Information about the encrypted data:");
        EncryptedContentInfo encryptedContentInfo = (EncryptedContentInfo)envelopedData.getEncryptedContentInfo();
        System.out.println("Content type: " + encryptedContentInfo.getContentType().getName());
        System.out.println("Content encryption algorithm: " + encryptedContentInfo.getContentEncryptionAlgorithm().getName());
        System.out.println("\nThis message can be decrypted by the owners of the following certificates:");
        RecipientInfo[] recipientInfoArray = envelopedData.getRecipientInfos();
        int n2 = 0;
        while (n2 < recipientInfoArray.length) {
            System.out.println("Recipient: " + (n2 + 1));
            System.out.print(recipientInfoArray[n2].getRecipientIdentifiers()[0]);
            ++n2;
        }
        try {
            envelopedData.setupCipher((Key)privateKey, n);
            return envelopedData.getContent();
        }
        catch (InvalidKeyException invalidKeyException) {
            System.out.println("Private key error: " + invalidKeyException.getMessage());
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.out.println("Content encryption algorithm not implemented: " + noSuchAlgorithmException.getMessage());
            return null;
        }
    }

    public AlgorithmID createOaepAlgorithmID(AlgorithmID algorithmID, AlgorithmID algorithmID2, AlgorithmID algorithmID3, byte[] byArray) throws CMSException {
        MGF1ParameterSpec mGF1ParameterSpec;
        AlgorithmID algorithmID4 = (AlgorithmID)AlgorithmID.rsaesOAEP.clone();
        algorithmID2.setParameter(algorithmID.toASN1Object());
        algorithmID3.setParameter((ASN1Object)new OCTET_STRING(byArray));
        MessageDigest messageDigest = null;
        MaskGenerationAlgorithm maskGenerationAlgorithm = null;
        try {
            messageDigest = algorithmID.getMessageDigestInstance();
            maskGenerationAlgorithm = algorithmID2.getMaskGenerationAlgorithmInstance();
            mGF1ParameterSpec = new MGF1ParameterSpec(algorithmID);
            mGF1ParameterSpec.setHashEngine(messageDigest);
            maskGenerationAlgorithm.setParameters((AlgorithmParameterSpec)mGF1ParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException(noSuchAlgorithmException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("Cannot init MGF engine: " + invalidAlgorithmParameterException.toString());
        }
        mGF1ParameterSpec = new RSAOaepParameterSpec(algorithmID, algorithmID2, algorithmID3);
        mGF1ParameterSpec.setHashEngine(messageDigest);
        mGF1ParameterSpec.setMGFEngine(maskGenerationAlgorithm);
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("RSAES-OAEP", "IAIK");
            algorithmParameters.init((AlgorithmParameterSpec)mGF1ParameterSpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("RSA-OAEP implementation of provider IAIK not available!");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CMSException("RSA-OAEP implementation of provider IAIK not available!");
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("Cannot init OAEP params: " + invalidParameterSpecException.getMessage());
        }
        algorithmID4.setAlgorithmParameters(algorithmParameters);
        return algorithmID4;
    }

    public byte[] createEnvelopedDataStream(byte[] byArray) throws IOException, CMSException {
        EnvelopedDataStream envelopedDataStream;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            envelopedDataStream = new EnvelopedDataStream((InputStream)byteArrayInputStream, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[2];
        recipientInfoArray[0] = new KeyTransRecipientInfo(this.user1, (AlgorithmID)AlgorithmID.rsaesOAEP.clone());
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.md5.clone();
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.mgf1.clone();
        AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.pSpecified.clone();
        byte[] byArray2 = new byte[]{};
        AlgorithmID algorithmID4 = this.createOaepAlgorithmID(algorithmID, algorithmID2, algorithmID3, byArray2);
        recipientInfoArray[1] = new KeyTransRecipientInfo(this.user2, algorithmID4);
        envelopedDataStream.setRecipientInfos(recipientInfoArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        envelopedDataStream.setBlockSize(2048);
        ContentInfoStream contentInfoStream = new ContentInfoStream((ContentStream)envelopedDataStream);
        contentInfoStream.writeTo((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] createEnvelopedData(byte[] byArray) throws IOException, CMSException {
        EnvelopedData envelopedData;
        try {
            envelopedData = new EnvelopedData(byArray, (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for Triple-DES-CBC.");
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[2];
        recipientInfoArray[0] = new KeyTransRecipientInfo(this.user1, (AlgorithmID)AlgorithmID.rsaesOAEP.clone());
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.md5.clone();
        AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.mgf1.clone();
        AlgorithmID algorithmID3 = (AlgorithmID)AlgorithmID.pSpecified.clone();
        byte[] byArray2 = new byte[]{};
        AlgorithmID algorithmID4 = this.createOaepAlgorithmID(algorithmID, algorithmID2, algorithmID3, byArray2);
        recipientInfoArray[1] = new KeyTransRecipientInfo(this.user2, algorithmID4);
        envelopedData.setRecipientInfos(recipientInfoArray);
        ContentInfo contentInfo = new ContentInfo((Content)envelopedData);
        return contentInfo.toByteArray();
    }

    public OaepEnvelopedData() throws IOException {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           OaepEnvelopedData demo                               *");
        System.out.println("*    (shows the usage of the CMS EnvelopedData type with the RSA OAEP method)    *");
        System.out.println("**********************************************************************************");
        System.out.println();
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 4);
        this.user1 = x509CertificateArray[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(0, 4);
        this.user2 = CMSKeyStore.getCertificateChain(0, 5)[0];
        this.user2_pk = CMSKeyStore.getPrivateKey(0, 5);
    }
}

