/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.DigestedData;
import iaik.cms.DigestedDataStream;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class CMSDigestedData {
    SecureRandom random;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nImplicit DigestedDataStream demo [create]:\n");
            byte[] byArray3 = this.createDigestedDataStream(byArray, 1);
            System.out.println("\nImplicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createDigestedDataStream(byArray, 2);
            System.out.println("\nExplicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            System.out.println("\nImplicit DigestedData demo [create]:\n");
            byArray3 = this.createDigestedData(byArray, 1);
            System.out.println("\nImplicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(byArray3, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit DigestedData demo [create]:\n");
            byArray3 = this.createDigestedData(byArray, 2);
            System.out.println("\nExplicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(byArray3, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new CMSDigestedData().start();
        System.in.read();
    }

    public byte[] getDigestedDataStream(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DigestedDataStream digestedDataStream = null;
        digestedDataStream = byArray2 == null ? new DigestedDataStream((InputStream)byteArrayInputStream) : new DigestedDataStream((InputStream)new ByteArrayInputStream(byArray2), AlgorithmID.md5);
        InputStream inputStream = digestedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            digestedDataStream.decode((InputStream)byteArrayInputStream);
        }
        if (!digestedDataStream.verify()) {
            throw new CMSException("Hash verification failed!");
        }
        System.out.println("Hash ok!");
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getDigestedData(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DigestedData digestedData = null;
        if (byArray2 == null) {
            digestedData = new DigestedData((InputStream)byteArrayInputStream);
        } else {
            try {
                digestedData = new DigestedData(byArray2, AlgorithmID.sha);
                digestedData.decode((InputStream)byteArrayInputStream);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.getMessage());
            }
        }
        if (!digestedData.verify()) {
            throw new CMSException("Hash verification failed!");
        }
        System.out.println("Hash ok!");
        return digestedData.getContent();
    }

    public byte[] createDigestedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        Closeable closeable;
        System.out.println("Create a new message to be digested:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DigestedDataStream digestedDataStream = null;
        digestedDataStream = new DigestedDataStream((InputStream)byteArrayInputStream, AlgorithmID.md5, n);
        if (n == 2) {
            int n2;
            closeable = digestedDataStream.getInputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = ((InputStream)closeable).read(byArray2)) > 0) {
            }
        }
        closeable = new ByteArrayOutputStream();
        digestedDataStream.writeTo((OutputStream)closeable, 2048);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public byte[] createDigestedData(byte[] byArray, int n) throws IOException, CMSException {
        System.out.println("Create a new digested message:");
        DigestedData digestedData = new DigestedData(byArray, AlgorithmID.sha, n);
        return digestedData.getEncoded();
    }

    public CMSDigestedData() throws IOException {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                           CMSDigestedData demo                                 *");
        System.out.println("*        (shows the usage of the CMS DigestedData type implementation)           *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.random = SecRandom.getDefault();
    }
}

